/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import org.nustaq.kontraktor.remoting.http.javascript.ModuleProperties;
import org.nustaq.kontraktor.remoting.http.javascript.jsmin.JSMin;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kson.Kson;

public class DependencyResolver {
    protected String mergedPrefix;
    protected String lookupPrefix;
    protected File[] resourcePath;
    protected File[] lookupDirs;
    protected String baseDir = ".";
    protected String rootComponent;

    public DependencyResolver(String lookupPrefix, String mergedPrefix, String rootComponent, String[] resourcePath) {
        this.lookupPrefix = lookupPrefix;
        this.mergedPrefix = mergedPrefix;
        this.setResourcePath(resourcePath);
        this.setRootComponent(rootComponent);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected DependencyResolver setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    protected DependencyResolver setResourcePath(String ... path) {
        this.resourcePath = new File[path.length];
        for (int i = 0; i < path.length; ++i) {
            String dir = this.baseDir + "/" + path[i];
            File f = new File(dir).getAbsoluteFile();
            if (f.exists() && !f.isDirectory()) {
                throw new RuntimeException("only directorys can reside on resourcepath");
            }
            this.resourcePath[i] = f;
        }
        return this;
    }

    protected void setRootComponent(String name) {
        this.rootComponent = name;
        List<File> dependentDirs = null;
        try {
            dependentDirs = this.getDependentDirs(name, new ArrayList<File>(), new HashSet<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lookupDirs = new File[dependentDirs.size()];
        dependentDirs.toArray(this.lookupDirs);
    }

    public String getRootComponent() {
        return this.rootComponent;
    }

    public List<String> findFilesInDirs(BiFunction<String, String, Boolean> filter) {
        HashSet<String> done = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lookupDirs.length; ++i) {
            File lookupDir = this.lookupDirs[i];
            String[] list = lookupDir.list();
            for (int j = 0; j < list.length; ++j) {
                String file = list[j];
                if (!done.contains(file) && filter.apply(lookupDir.getName(), file).booleanValue()) {
                    result.add(lookupDir.getName() + "/" + file);
                }
                done.add(file);
            }
        }
        return result;
    }

    public File locateResource(String name) {
        File fi;
        int i;
        for (i = 0; i < this.resourcePath.length; ++i) {
            fi = new File(this.resourcePath[i].getAbsolutePath() + File.separator + name);
            if (!fi.exists()) continue;
            return fi;
        }
        for (i = 0; i < this.lookupDirs.length; ++i) {
            fi = new File(this.lookupDirs[i], name);
            if (!fi.exists()) continue;
            return fi;
        }
        return null;
    }

    public List<File> locateComponent(String name) {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.resourcePath.length; ++i) {
            File file = this.resourcePath[i];
            File newOne = new File(file, name);
            if (!newOne.exists() || !newOne.isDirectory()) continue;
            result.add(newOne);
        }
        return result;
    }

    protected List<File> getDependentDirs(String comp, List<File> li, HashSet<String> alreadyCheckedDependencies) throws IOException {
        if (alreadyCheckedDependencies.contains(comp)) {
            return li;
        }
        alreadyCheckedDependencies.add(comp);
        for (int i = 0; i < this.resourcePath.length; ++i) {
            File file = this.resourcePath[i];
            File newOne = new File(file, comp).getCanonicalFile();
            if (li.contains(newOne) || !newOne.exists() || !newOne.isDirectory()) continue;
            File dep = new File(newOne, "dep.kson");
            if (dep.exists()) {
                try {
                    String[] deps = ((ModuleProperties)new Kson().map((Class[])new Class[]{ModuleProperties.class}).readObject((File)dep, ModuleProperties.class)).depends;
                    for (int j = 0; j < deps.length; ++j) {
                        this.getDependentDirs(deps[j], li, alreadyCheckedDependencies);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (li.contains(newOne)) continue;
            li.add(newOne.getCanonicalFile());
        }
        return li;
    }

    public byte[] createScriptTags(List<String> jsFileNames) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
        PrintStream ps = new PrintStream(bout);
        for (int i = 0; i < jsFileNames.size(); ++i) {
            String f = jsFileNames.get(i);
            if (!f.endsWith(".js")) continue;
            Log.Info((Object)this, (String)("   " + f + " size:" + f.length()));
            ps.println("document.write(\"<script src='" + this.lookupPrefix + f + "'></script>\")");
            Log.Info((Object)this, (String)("document.write(\"<script src='" + this.lookupPrefix + f + "'></script>\")"));
        }
        ps.flush();
        byte[] bytes = bout.toByteArray();
        return bytes;
    }

    public byte[] mergeScripts(List<String> fileNames) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
        for (int i = 0; i < fileNames.size(); ++i) {
            String jsFileName = fileNames.get(i);
            File f = this.locateResource(jsFileName);
            String absolutePath = f.getAbsolutePath();
            if (!f.getName().endsWith(".js")) continue;
            Log.Info((Object)this, (String)("   " + f.getName() + " size:" + f.length()));
            byte[] bytes = new byte[(int)f.length()];
            try (FileInputStream fileInputStream = new FileInputStream(f);){
                fileInputStream.read(bytes);
                bout.write(bytes);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.reset();
        JSMin.builder().inputStream(bin).outputStream(bout).build().minify();
        byte[] bytes = bout.toByteArray();
        return bytes;
    }

    public byte[] mergeBinary(List<String> fileNames) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
        for (int i = 0; i < fileNames.size(); ++i) {
            String jsFileName = fileNames.get(i);
            File f = this.locateResource(jsFileName);
            String absolutePath = f.getAbsolutePath();
            if (f == null) continue;
            Log.Info((Object)this, (String)("   " + f.getName() + " size:" + f.length()));
            byte[] bytes = new byte[(int)f.length()];
            try (FileInputStream fileInputStream = new FileInputStream(f);){
                fileInputStream.read(bytes);
                bout.write(bytes);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] bytes = bout.toByteArray();
        return bytes;
    }

    public byte[] mergeTextSnippets(List<String> names, String startTag, String endTag) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(2000);
        HashSet hs = new HashSet();
        PrintStream pout = new PrintStream(bout);
        pout.println("document.write('\\" + startTag);
        for (int i = 0; i < names.size(); ++i) {
            String finam = names.get(i);
            File f = this.locateResource(finam);
            if (f == null) continue;
            try (FileReader fileInputStream = new FileReader(f);){
                BufferedReader in = new BufferedReader(fileInputStream);
                while (in.ready()) {
                    String line = in.readLine();
                    line = line.replace("'", "\\'");
                    pout.println(line + "\\");
                }
                in.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        pout.println(endTag + "');");
        pout.flush();
        return bout.toByteArray();
    }
}

