/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.barebone;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.nustaq.kontraktor.barebone.Callback;
import org.nustaq.kontraktor.barebone.CallbackRefSerializer;
import org.nustaq.kontraktor.barebone.ConnectionListener;
import org.nustaq.kontraktor.barebone.Promise;
import org.nustaq.kontraktor.barebone.RemoteActor;
import org.nustaq.kontraktor.barebone.RemoteCallEntry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.coders.Unknown;

public class RemoteActorConnection {
    public static final int LONG_POLL_MAX_TIME = 15000;
    public static int MAX_CONN_PER_ROUTE = 1000;
    public static int MAX_CONN_TOTAL = 1000;
    public static boolean DumpProtocol = false;
    protected static CloseableHttpAsyncClient asyncHttpClient;
    protected volatile boolean isConnected;
    private static final boolean SENDDEBUG = false;
    static final Header NO_CACHE;
    protected FSTConfiguration conf;
    protected static ExecutorService myExec;
    protected String sessionId;
    protected String sessionUrl;
    protected int lastSeenSeq;
    protected ConnectionListener connectionListener;
    protected volatile long timeout = 30000L;
    protected long lastPing;
    protected String jwt = "";
    protected String id = "";
    protected ConcurrentHashMap<Long, Callback> callbackMap = new ConcurrentHashMap();
    protected AtomicLong idCount = new AtomicLong(0L);
    protected boolean requestUnderway = false;
    protected ArrayList<RemoteCallEntry> requests = new ArrayList();
    protected AtomicInteger openFutureRequests = new AtomicInteger(0);
    protected static Timer timer;
    Map sequenceCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpAsyncClient getClient() {
        RemoteActorConnection remoteActorConnection = this;
        synchronized (remoteActorConnection) {
            if (asyncHttpClient == null) {
                asyncHttpClient = HttpAsyncClients.custom().setMaxConnPerRoute(MAX_CONN_PER_ROUTE).setMaxConnTotal(MAX_CONN_TOTAL).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(8).setSoKeepAlive(true).setSoReuseAddress(true).build()).build();
                asyncHttpClient.start();
            }
            return asyncHttpClient;
        }
    }

    public RemoteActorConnection(ConnectionListener connectionListener) {
        this(connectionListener, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteActorConnection(ConnectionListener connectionListener, boolean sharedRefs) {
        this.initConf(sharedRefs);
        this.connectionListener = connectionListener;
        try {
            if (Class.forName("org.nustaq.kontraktor.Actor") == null) {
                // empty if block
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        myExec.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("kontraktor-bare client");
            }
        });
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    protected void initConf(boolean sharedRefs) {
        this.conf = FSTConfiguration.createJsonConfiguration((boolean)DumpProtocol, (!DumpProtocol && sharedRefs ? 1 : 0) != 0);
        this.conf.registerCrossPlatformClassMapping((String[][])new String[][]{{"call", RemoteCallEntry.class.getName()}, {"cbw", Callback.class.getName()}});
        this.conf.registerSerializer(Callback.class, (FSTObjectSerializer)new CallbackRefSerializer(this), true);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Promise<RemoteActor> connect(final String url, final boolean longPoll) {
        final Promise<RemoteActor> res = new Promise<RemoteActor>();
        byte[] message = this.conf.asByteArray(null);
        if (DumpProtocol) {
            try {
                System.out.println("auth-req:" + new String(message, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        HttpPost req = this.createRequest(url, message);
        this.getClient().execute((HttpUriRequest)req, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                block8: {
                    RemoteActorConnection.this.lastPing = System.currentTimeMillis();
                    if (result.getStatusLine().getStatusCode() != 200) {
                        res.receive(null, "connection failed with status:" + result.getStatusLine().getStatusCode());
                        return;
                    }
                    String cl = result.getFirstHeader("Content-Length").getValue();
                    int len = Integer.parseInt(cl);
                    if (len > 0) {
                        final byte[] resp = new byte[len];
                        try {
                            result.getEntity().getContent().read(resp);
                            if (DumpProtocol) {
                                try {
                                    System.out.println("auth-resp:" + new String(resp, "UTF-8"));
                                }
                                catch (UnsupportedEncodingException e) {
                                    e.printStackTrace();
                                }
                            }
                            myExec.execute(new Runnable(){

                                @Override
                                public void run() {
                                    RemoteActorConnection.this.sessionId = (String)RemoteActorConnection.this.conf.asObject(resp);
                                    RemoteActorConnection.this.isConnected = true;
                                    if (longPoll) {
                                        RemoteActorConnection.this.startLongPoll();
                                    }
                                    RemoteActorConnection.this.sessionUrl = url + "/" + RemoteActorConnection.this.sessionId;
                                    System.out.println("session id:" + RemoteActorConnection.this.sessionId);
                                    res.complete(new RemoteActor("App", 1, RemoteActorConnection.this), null);
                                }
                            });
                        }
                        catch (Exception e) {
                            res.complete(null, e);
                            if (DumpProtocol) {
                                e.printStackTrace();
                            }
                            break block8;
                        }
                    }
                    res.complete(null, "connection rejected, no connection id");
                }
            }

            public void failed(Exception ex) {
                res.complete(null, ex);
            }

            public void cancelled() {
                res.complete(null, "connection failed. Canceled request");
            }
        });
        return res;
    }

    protected void startLongPoll() {
        final AtomicReference<4> lp = new AtomicReference<4>();
        lp.set(new Runnable(){

            @Override
            public void run() {
                if (!RemoteActorConnection.this.isConnected) {
                    return;
                }
                final AtomicInteger timedout = new AtomicInteger(0);
                RemoteActorConnection.this.delayed(new Runnable(){

                    @Override
                    public void run() {
                        RemoteActorConnection.this.checkTimeout();
                        if (timedout.compareAndSet(0, 2)) {
                            myExec.execute((Runnable)lp.get());
                        }
                    }
                }, 16000L);
                HttpPost request = RemoteActorConnection.this.createRequest(RemoteActorConnection.this.sessionUrl, RemoteActorConnection.this.conf.asByteArray((Object)new Object[]{RemoteActorConnection.this.lastSeenSeq}));
                RemoteActorConnection.this.getClient().execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

                    public void completed(HttpResponse result) {
                        if (!timedout.compareAndSet(0, 1)) {
                            return;
                        }
                        if (result.getStatusLine().getStatusCode() != 200) {
                            RemoteActorConnection.this.log("unexpected return status " + result.getStatusLine().getReasonPhrase());
                            RemoteActorConnection.this.delayed((Runnable)lp.get(), 2000L);
                            return;
                        }
                        RemoteActorConnection.this.lastPing = System.currentTimeMillis();
                        String cl = result.getFirstHeader("Content-Length").getValue();
                        int len = Integer.parseInt(cl);
                        if (len > 0) {
                            final byte[] b = new byte[len];
                            try {
                                result.getEntity().getContent().read(b);
                                myExec.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        RemoteActorConnection.this.processResponse(b);
                                    }
                                });
                                myExec.execute((Runnable)lp.get());
                            }
                            catch (Throwable e) {
                                RemoteActorConnection.this.log(e);
                                RemoteActorConnection.this.delayed((Runnable)lp.get(), 2000L);
                            }
                        } else {
                            myExec.execute((Runnable)lp.get());
                        }
                    }

                    public void failed(Exception ex) {
                        if (!timedout.compareAndSet(0, 1)) {
                            return;
                        }
                        RemoteActorConnection.this.log(ex);
                        RemoteActorConnection.this.delayed((Runnable)lp.get(), 2000L);
                    }

                    public void cancelled() {
                        if (!timedout.compareAndSet(0, 1)) {
                            return;
                        }
                        RemoteActorConnection.this.log("request canceled");
                        RemoteActorConnection.this.delayed((Runnable)lp.get(), 2000L);
                    }
                });
            }
        });
        this.delayed((Runnable)lp.get(), 1000L);
    }

    protected void checkTimeout() {
        if (System.currentTimeMillis() - this.lastPing > this.timeout) {
            this.disconnect("timed out");
        }
    }

    protected void delayed(final Runnable runnable, long millis) {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    myExec.execute(runnable);
                }
                catch (Throwable t) {
                    RemoteActorConnection.this.log(t);
                }
            }
        }, millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(RemoteCallEntry remoteCallEntry, Promise res) {
        if (res != null) {
            long key;
            remoteCallEntry.futureKey = key = this.registerCallback(res);
            this.openFutureRequests.incrementAndGet();
        }
        ArrayList<RemoteCallEntry> arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.add(remoteCallEntry);
            this.sendRequests();
        }
    }

    public int getOpenFutureRequests() {
        return this.openFutureRequests.get();
    }

    public void sendShortPoll() {
        myExec.execute(new Runnable(){

            @Override
            public void run() {
                Object[] req = new Object[]{"SP", RemoteActorConnection.this.lastSeenSeq};
                RemoteActorConnection.this.sendCallArray(req);
            }
        });
    }

    protected void sendRequests() {
        if (!this.requestUnderway) {
            this.requestUnderway = true;
            this.delayed(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<RemoteCallEntry> arrayList = RemoteActorConnection.this.requests;
                    synchronized (arrayList) {
                        Object[] req;
                        if (RemoteActorConnection.this.openFutureRequests.get() > 0 && RemoteActorConnection.this.requests.size() == 0) {
                            req = new Object[]{"SP", RemoteActorConnection.this.lastSeenSeq};
                        } else {
                            req = new Object[RemoteActorConnection.this.requests.size() + 1];
                            for (int i = 0; i < RemoteActorConnection.this.requests.size(); ++i) {
                                req[i] = RemoteActorConnection.this.requests.get(i);
                            }
                            req[req.length - 1] = RemoteActorConnection.this.lastSeenSeq;
                            RemoteActorConnection.this.requests.clear();
                        }
                        RemoteActorConnection.this.sendCallArray(req).then(new Callback<Integer>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void receive(Integer result, Object error) {
                                ArrayList<RemoteCallEntry> arrayList = RemoteActorConnection.this.requests;
                                synchronized (arrayList) {
                                    RemoteActorConnection.this.requestUnderway = false;
                                    if (RemoteActorConnection.this.requests.size() > 0 || result != null && result > 0 && RemoteActorConnection.this.openFutureRequests.get() > 0) {
                                        myExec.execute(new Runnable(){

                                            @Override
                                            public void run() {
                                                RemoteActorConnection.this.sendRequests();
                                            }
                                        });
                                    }
                                }
                            }
                        });
                    }
                }
            }, 1L);
        }
    }

    protected Promise<Integer> sendCallArray(Object[] req) {
        final Promise<Integer> p = new Promise<Integer>();
        for (int i = 0; i < req.length; ++i) {
            Object o = req[i];
            if (!(o instanceof RemoteCallEntry)) continue;
            ((RemoteCallEntry)o).pack(this.conf);
        }
        byte[] message = this.conf.asByteArray((Object)req);
        HttpPost request = this.createRequest(this.sessionUrl, message);
        if (DumpProtocol) {
            try {
                System.out.println("req:" + new String(message, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        this.getClient().execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                if (result.getStatusLine().getStatusCode() != 200) {
                    String error = "Unexpected status:" + result.getStatusLine().getStatusCode();
                    p.reject(error);
                    return;
                }
                RemoteActorConnection.this.lastPing = System.currentTimeMillis();
                String cl = result.getFirstHeader("Content-Length").getValue();
                int len = Integer.parseInt(cl);
                if (len > 0) {
                    final byte[] b = new byte[len];
                    try {
                        result.getEntity().getContent().read(b);
                        myExec.execute(new Runnable(){

                            @Override
                            public void run() {
                                int numMsgResp = 0;
                                try {
                                    numMsgResp = RemoteActorConnection.this.processResponse(b);
                                }
                                finally {
                                    p.complete(numMsgResp, null);
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        p.complete(null, e);
                        RemoteActorConnection.this.log(e);
                    }
                } else {
                    p.complete(0, null);
                }
            }

            public void failed(Exception ex) {
                p.complete(null, ex);
                RemoteActorConnection.this.log(ex);
            }

            public void cancelled() {
                p.complete(0, null);
                RemoteActorConnection.this.log("request canceled");
            }
        });
        return p;
    }

    public String getJwt() {
        return this.jwt;
    }

    public String getId() {
        return this.id;
    }

    public RemoteActorConnection jwt(String jwt) {
        this.jwt = jwt;
        return this;
    }

    public RemoteActorConnection id(String id) {
        this.id = id;
        return this;
    }

    protected int processResponse(byte[] b) {
        Object[] o;
        int seq;
        if (DumpProtocol) {
            try {
                System.out.println("resp:" + new String(b, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if ((seq = ((Number)(o = (Object[])this.conf.asObject(b))[o.length - 1]).intValue()) == this.lastSeenSeq + 1 || this.lastSeenSeq == 0) {
            Object[] next;
            this.lastSeenSeq = seq;
            this.processDecodedResultArray(o);
            while ((next = (Object[])this.sequenceCache.get(this.lastSeenSeq + 1)) != null) {
                ++this.lastSeenSeq;
                this.sequenceCache.remove(this.lastSeenSeq);
                this.log("replay " + this.lastSeenSeq);
                this.processDecodedResultArray(next);
            }
        } else {
            this.log("ignored result with sequence:" + seq + " lastSeen:" + this.lastSeenSeq);
            if (seq > this.lastSeenSeq) {
                this.sequenceCache.put(seq, o);
                if (this.sequenceCache.size() > 5) {
                    this.disconnect("Unrecoverable Gap");
                }
            }
        }
        return o.length - 1;
    }

    public void close() {
        this.disconnect("closed");
    }

    protected void disconnect(String s) {
        this.isConnected = false;
        if (this.connectionListener != null) {
            this.connectionListener.connectionClosed(s);
        }
        this.lastSeenSeq = 0;
        myExec.shutdown();
    }

    protected void processDecodedResultArray(Object[] o) {
        for (int i = 0; i < o.length - 1; ++i) {
            Callback callback;
            Unknown uk;
            List items;
            final RemoteCallEntry call = (RemoteCallEntry)o[i];
            if (call.getQueue() != 1) continue;
            call.unpack(this.conf);
            this.transformRecursive(this.conf, call.getArgs(), null, -1, null);
            if (call.getArgs()[0] instanceof Unknown && (items = (uk = (Unknown)call.getArgs()[0]).getItems()).size() == 2 && items.get(0) instanceof Number && items.get(1) instanceof String && ((String)items.get(1)).endsWith("_ActorProxy")) {
                String actorName = (String)items.get(1);
                actorName = actorName.substring(0, actorName.length() - "_ActorProxy".length());
                call.getArgs()[0] = new RemoteActor(actorName, ((Number)items.get(0)).intValue(), this);
            }
            if ((callback = this.callbackMap.get(call.getReceiverKey())) == null) {
                this.log("unknown callback receiver " + call);
                continue;
            }
            final Object error = call.getArgs()[1];
            if (callback instanceof Promise) {
                this.openFutureRequests.decrementAndGet();
                this.callbackMap.remove(call.getReceiverKey());
            } else if (!call.isContinue()) {
                this.callbackMap.remove(call.getReceiverKey());
            }
            myExec.execute(new Runnable(){

                @Override
                public void run() {
                    callback.receive(call.getArgs()[0], error);
                }
            });
        }
    }

    protected void transformRecursive(FSTConfiguration conf, Object obj, Object parent, int parindex, String attr) {
        block8: {
            Unknown unk;
            block9: {
                RemoteActor replaced;
                block10: {
                    block7: {
                        if (!(obj instanceof Object[])) break block7;
                        Object[] arr = (Object[])obj;
                        for (int i = 0; i < arr.length; ++i) {
                            Object o = arr[i];
                            this.transformRecursive(conf, o, (Object[])obj, i, null);
                        }
                        break block8;
                    }
                    if (!(obj instanceof Unknown)) break block8;
                    unk = (Unknown)obj;
                    String actorName = unk.getType();
                    if (actorName == null || !unk.getType().endsWith("_ActorProxy")) break block9;
                    actorName = actorName.substring(0, actorName.length() - "_ActorProxy".length());
                    replaced = new RemoteActor(actorName, ((Number)unk.getItems().get(0)).intValue(), this);
                    if (!(parent instanceof Object[]) || parindex < 0) break block10;
                    ((Object[])parent)[parindex] = replaced;
                    break block8;
                }
                if (!(parent instanceof Unknown)) break block8;
                if (parindex >= 0) {
                    ((Unknown)parent).getItems().set(parindex, replaced);
                } else {
                    ((Unknown)parent).set(attr, (Object)replaced);
                }
                break block8;
            }
            if (unk.isSequence()) {
                for (int j = 0; j < unk.getItems().size(); ++j) {
                    Object obj1 = unk.getItems().get(j);
                    this.transformRecursive(conf, obj1, unk, j, null);
                }
            } else {
                Map fields = unk.getFields();
                for (String s : fields.keySet()) {
                    this.transformRecursive(conf, unk.get(s), unk, -1, s);
                }
            }
        }
    }

    protected long registerCallback(Callback res) {
        long key = this.idCount.incrementAndGet();
        this.callbackMap.put(key, res);
        return key;
    }

    protected void log(Throwable e) {
        e.printStackTrace();
    }

    protected void log(String s) {
        System.out.println(s);
    }

    protected HttpPost createRequest(String url, byte[] message) {
        HttpPost req = new HttpPost(url);
        req.addHeader(NO_CACHE);
        req.addHeader((Header)new JWTHeadeer(this.jwt));
        req.addHeader((Header)new IDHeadeer(this.id));
        req.setEntity((HttpEntity)new ByteArrayEntity(message));
        return req;
    }

    static {
        NO_CACHE = new Header(){

            public String getName() {
                return "Cache-Control";
            }

            public String getValue() {
                return "no-cache";
            }

            public HeaderElement[] getElements() throws ParseException {
                return new HeaderElement[0];
            }
        };
        myExec = Executors.newSingleThreadExecutor();
        timer = new Timer();
    }

    static final class IDHeadeer
    implements Header {
        String id;

        public IDHeadeer(String id) {
            this.id = id;
        }

        public String getName() {
            return "ID";
        }

        public String getValue() {
            return this.id;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }
    }

    static final class JWTHeadeer
    implements Header {
        String jwt;

        public JWTHeadeer(String jwt) {
            this.jwt = jwt;
        }

        public String getName() {
            return "JWT";
        }

        public String getValue() {
            return this.jwt;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }
    }
}

