/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.barebone;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.nustaq.kontraktor.barebone.Callback;
import org.nustaq.serialization.util.FSTUtil;

public class Promise<T>
extends Callback<T> {
    Callback<T> cb;
    T result;
    Object error;
    boolean hasFired = false;
    boolean isComplete = false;

    public void resolve(T result) {
        this.complete(result, null);
    }

    public void reject(Object error) {
        this.complete(null, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(T result, Object error) {
        Promise promise = this;
        synchronized (promise) {
            if (this.isComplete) {
                throw new RuntimeException("Promise can be completed only once");
            }
            this.result = result;
            this.error = error;
            this.isComplete = true;
            this.tryFire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryFire() {
        Promise promise = this;
        synchronized (promise) {
            if (this.cb != null && this.isComplete && !this.hasFired) {
                this.hasFired = true;
                this.cb.receive(this.result, this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void then(Callback<T> callback) {
        Promise promise = this;
        synchronized (promise) {
            if (this.cb != null) {
                throw new RuntimeException("only one callback can be used");
            }
            this.cb = callback;
        }
        this.tryFire();
    }

    @Override
    public void receive(T result, Object error) {
        this.complete(result, error);
    }

    public T await() {
        return this.await(5000L);
    }

    public T await(long timeout) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.cb = new Callback<T>(){

            @Override
            public void receive(T result, Object error) {
                latch.countDown();
            }
        };
        boolean timedOut = true;
        try {
            timedOut = !latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (timedOut) {
            throw new RuntimeException("promise timed out");
        }
        if (this.error instanceof Throwable) {
            FSTUtil.rethrow((Throwable)((Throwable)this.error));
        } else if (this.error != null) {
            throw new RuntimeException("" + this.error);
        }
        return this.result;
    }
}

