/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.bytez.malloc;

import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import jdk.incubator.foreign.MemoryHandles;
import jdk.incubator.foreign.MemorySegment;
import org.nustaq.offheap.bytez.BasicBytez;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.malloc.MallocBytezAllocator;

public class MemoryBytez
implements Bytez {
    static VarHandle byteHandle = MemoryHandles.varHandle(Byte.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    static VarHandle charHandle = MemoryHandles.varHandle(Character.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    static VarHandle shortHandle = MemoryHandles.varHandle(Short.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    static VarHandle intHandle = MemoryHandles.varHandle(Integer.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    static VarHandle longHandle = MemoryHandles.varHandle(Long.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    static VarHandle floatHandle = MemoryHandles.varHandle(Float.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    static VarHandle doubleHandle = MemoryHandles.varHandle(Double.TYPE, (ByteOrder)ByteOrder.nativeOrder());
    MemorySegment memseg;

    protected MemoryBytez() {
    }

    public MemoryBytez(long len) {
        this.memseg = MemorySegment.allocateNative((long)len);
    }

    public MemoryBytez(MemorySegment mem) {
        this.memseg = mem;
    }

    @Override
    public MemoryBytez slice(long off, int len) {
        return new MemoryBytez(this.memseg.asSlice(off, (long)len));
    }

    @Override
    public byte get(long byteIndex) {
        return byteHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public boolean getBool(long byteIndex) {
        return this.get(byteIndex) != 0;
    }

    @Override
    public char getChar(long byteIndex) {
        return charHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public short getShort(long byteIndex) {
        return shortHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public int getInt(long byteIndex) {
        return intHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public long getLong(long byteIndex) {
        return longHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public float getFloat(long byteIndex) {
        return floatHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public double getDouble(long byteIndex) {
        return doubleHandle.get(this.memseg.baseAddress().addOffset(byteIndex));
    }

    @Override
    public void put(long byteIndex, byte value) {
        byteHandle.set(this.memseg.baseAddress().addOffset(byteIndex), value);
    }

    @Override
    public void putBool(long byteIndex, boolean val) {
        byteHandle.set(this.memseg.baseAddress().addOffset(byteIndex), val ? 1 : 0);
    }

    @Override
    public void putChar(long byteIndex, char c) {
        charHandle.set(this.memseg.baseAddress().addOffset(byteIndex), c);
    }

    @Override
    public void putShort(long byteIndex, short s) {
        shortHandle.set(this.memseg.baseAddress().addOffset(byteIndex), s);
    }

    @Override
    public void putInt(long byteIndex, int i) {
        intHandle.set(this.memseg.baseAddress().addOffset(byteIndex), i);
    }

    @Override
    public void putLong(long byteIndex, long l) {
        longHandle.set(this.memseg.baseAddress().addOffset(byteIndex), l);
    }

    @Override
    public void putFloat(long byteIndex, float f) {
        floatHandle.set(this.memseg.baseAddress().addOffset(byteIndex), f);
    }

    @Override
    public void putDouble(long byteIndex, double d) {
        doubleHandle.set(this.memseg.baseAddress().addOffset(byteIndex), d);
    }

    @Override
    public long length() {
        return this.memseg.byteSize();
    }

    @Override
    public void getArr(long byteIndex, byte[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.get(byteIndex + (long)i);
        }
    }

    @Override
    public void getCharArr(long byteIndex, char[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getChar(byteIndex * 2L + (long)i);
        }
    }

    @Override
    public void getShortArr(long byteIndex, short[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getShort(byteIndex * 2L + (long)i);
        }
    }

    @Override
    public void getIntArr(long byteIndex, int[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getInt(byteIndex * 4L + (long)i);
        }
    }

    @Override
    public void getLongArr(long byteIndex, long[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getLong(byteIndex * 8L + (long)i);
        }
    }

    @Override
    public void getFloatArr(long byteIndex, float[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getFloat(byteIndex * 4L + (long)i);
        }
    }

    @Override
    public void getDoubleArr(long byteIndex, double[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getDouble(byteIndex * 8L + (long)i);
        }
    }

    @Override
    public void getBooleanArr(long byteIndex, boolean[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getBool(byteIndex + (long)i);
        }
    }

    @Override
    public void set(long byteIndex, byte[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.put(byteIndex + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setChar(long byteIndex, char[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.putChar(byteIndex * 2L + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setShort(long byteIndex, short[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.putShort(byteIndex * 2L + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setInt(long byteIndex, int[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.putInt(byteIndex * 4L + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setLong(long byteIndex, long[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.putLong(byteIndex * 8L + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setFloat(long byteIndex, float[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.putFloat(byteIndex * 4L + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setDouble(long byteIndex, double[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.putDouble(byteIndex * 8L + (long)i, source[i + elemoff]);
        }
    }

    @Override
    public void setBoolean(long byteIndex, boolean[] o, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.put(byteIndex + (long)i, (byte)(o[i + elemoff] ? 1 : 0));
        }
    }

    @Override
    public void copyTo(BasicBytez other, long otherByteIndex, long myByteIndex, long lenBytes) {
        for (long i = 0L; i < lenBytes; ++i) {
            other.put(otherByteIndex + i, this.get(myByteIndex + i));
        }
    }

    @Override
    public BasicBytez newInstance(long size) {
        return new MemoryBytez(size);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expect, int newVal) {
        return intHandle.compareAndExchange(this.memseg.baseAddress().addOffset(offset), expect, newVal) == expect;
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expect, long newVal) {
        return longHandle.compareAndExchange(this.memseg.baseAddress().addOffset(offset), expect, newVal) == expect;
    }

    @Override
    public byte[] toBytes(long startIndex, int len) {
        return this.memseg.asSlice(startIndex, (long)len).toByteArray();
    }

    @Override
    public byte[] asByteArray() {
        return this.memseg.toByteArray();
    }

    @Override
    public int getBAOffsetIndex() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    @Override
    public int getBALength() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    public int hashCode() {
        return this.memseg.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemoryBytez) {
            return this.memseg.equals(((MemoryBytez)obj).memseg);
        }
        return false;
    }

    void free() {
        this.memseg.close();
    }

    public long getLength() {
        return this.memseg.byteSize();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        siz = 1000000000L;
        m = new MallocBytezAllocator().alloc(siz);
        m1 = new MemoryBytez(siz);
        while (true) {
            for (i = 0; i < 10; ++i) {
                MemoryBytez.testPerf(m, "unsafe");
            }
            i = 0;
            while (true) {
                if (i >= 10) ** continue;
                MemoryBytez.testPerf(m, "safe");
                ++i;
            }
            break;
        }
    }

    private static long testPerf(Bytez m, String unsafe) {
        long ti = System.currentTimeMillis();
        long sum = 0L;
        long max = m.length() / 4L;
        for (long i = 0L; i < max; ++i) {
            sum += (long)m.getInt(i);
        }
        System.out.println(unsafe + " tim " + (System.currentTimeMillis() - ti));
        return sum;
    }
}

