/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import java.io.IOException;
import java.io.OutputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTOutputStream;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStreamEncoder
implements FSTEncoder {
    private FSTConfiguration conf;
    private FSTClazzNameRegistry clnames;
    private FSTOutputStream buffout;
    private byte[] ascStringCache;

    public FSTStreamEncoder(FSTConfiguration conf) {
        this.conf = conf;
        this.clnames = (FSTClazzNameRegistry)conf.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(conf.getClassRegistry());
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    void writeFBooleanArr(boolean[] arr, int off, int len) throws IOException {
        this.buffout.ensureFree(len);
        for (int i = off; i < off + len; ++i) {
            this.buffout.buf[this.buffout.pos++] = (byte)(arr[i] ? 1 : 0);
        }
    }

    public void writeFFloatArr(float[] arr, int off, int len) throws IOException {
        int byteLen = arr.length * 4;
        this.buffout.ensureFree(byteLen);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            long anInt = Float.floatToIntBits(arr[i]);
            buf[count] = (byte)(anInt >>> 0);
            buf[count + 1] = (byte)(anInt >>> 8);
            buf[count + 2] = (byte)(anInt >>> 16);
            buf[count + 3] = (byte)(anInt >>> 24);
            count += 4;
        }
        this.buffout.pos += byteLen;
    }

    public void writeFDoubleArr(double[] arr, int off, int len) throws IOException {
        int byteLen = arr.length * 8;
        this.buffout.ensureFree(byteLen);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            long aLong = Double.doubleToLongBits(arr[i]);
            buf[count] = (byte)(aLong >>> 0);
            buf[count + 1] = (byte)(aLong >>> 8);
            buf[count + 2] = (byte)(aLong >>> 16);
            buf[count + 3] = (byte)(aLong >>> 24);
            buf[count + 4] = (byte)(aLong >>> 32);
            buf[count + 5] = (byte)(aLong >>> 40);
            buf[count + 6] = (byte)(aLong >>> 48);
            buf[count + 7] = (byte)(aLong >>> 56);
            count += 8;
        }
        this.buffout.pos += byteLen;
    }

    public void writeFShortArr(short[] arr, int off, int len) throws IOException {
        this.buffout.ensureFree(len * 3);
        for (int i = off; i < off + len; ++i) {
            short c = arr[i];
            if (c < 255 && c >= 0) {
                this.buffout.buf[this.buffout.pos++] = (byte)c;
                continue;
            }
            this.buffout.buf[this.buffout.pos] = -1;
            this.buffout.buf[this.buffout.pos + 1] = (byte)(c >>> 0);
            this.buffout.buf[this.buffout.pos + 2] = (byte)(c >>> 8);
            this.buffout.pos += 3;
        }
    }

    public void writeFCharArr(char[] arr, int off, int len) throws IOException {
        this.buffout.ensureFree(len * 3);
        for (int i = off; i < off + len; ++i) {
            char c = arr[i];
            if (c < '\u00ff' && c >= '\u0000') {
                this.buffout.buf[this.buffout.pos++] = (byte)c;
                continue;
            }
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count] = -1;
            buf[count + 1] = (byte)(c >>> 0);
            buf[count + 2] = (byte)(c >>> 8);
            this.buffout.pos += 3;
        }
    }

    public void writeFIntArr(int[] arr, int off, int len) throws IOException {
        int byteLen = arr.length * 4;
        this.buffout.ensureFree(byteLen);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            long anInt = arr[i];
            buf[count] = (byte)(anInt >>> 0);
            buf[count + 1] = (byte)(anInt >>> 8);
            buf[count + 2] = (byte)(anInt >>> 16);
            buf[count + 3] = (byte)(anInt >>> 24);
            count += 4;
        }
        this.buffout.pos += byteLen;
    }

    public void _writeFIntArr(int[] v, int off, int len) throws IOException {
        int free = 5 * len;
        this.buffout.ensureFree(free);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = off; i < off + len; ++i) {
            int anInt = v[i];
            if (anInt > -127 && anInt <= 127) {
                this.buffout.buf[count++] = (byte)anInt;
                continue;
            }
            if (anInt >= Short.MIN_VALUE && anInt <= Short.MAX_VALUE) {
                buf[count++] = -128;
                buf[count++] = (byte)(anInt >>> 0 & 0xFF);
                buf[count++] = (byte)(anInt >>> 8 & 0xFF);
                continue;
            }
            buf[count++] = -127;
            buf[count++] = (byte)(anInt >>> 0 & 0xFF);
            buf[count++] = (byte)(anInt >>> 8 & 0xFF);
            buf[count++] = (byte)(anInt >>> 16 & 0xFF);
            buf[count++] = (byte)(anInt >>> 24 & 0xFF);
        }
        this.buffout.pos = count;
    }

    void writeFLongArr(long[] arr, int off, int len) throws IOException {
        int byteLen = arr.length * 8;
        this.buffout.ensureFree(byteLen);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = off; i < off + len; ++i) {
            long anInt = arr[i];
            buf[count] = (byte)(anInt >>> 0);
            buf[count + 1] = (byte)(anInt >>> 8);
            buf[count + 2] = (byte)(anInt >>> 16);
            buf[count + 3] = (byte)(anInt >>> 24);
            buf[count + 4] = (byte)(anInt >>> 32);
            buf[count + 5] = (byte)(anInt >>> 40);
            buf[count + 6] = (byte)(anInt >>> 48);
            buf[count + 7] = (byte)(anInt >>> 56);
            count += 8;
        }
        this.buffout.pos += byteLen;
    }

    @Override
    public void writePrimitiveArray(Object array, int off, int len) throws IOException {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Byte.TYPE) {
            this.writeRawBytes((byte[])array, off, len);
        } else if (componentType == Character.TYPE) {
            this.writeFCharArr((char[])array, off, len);
        } else if (componentType == Short.TYPE) {
            this.writeFShortArr((short[])array, off, len);
        } else if (componentType == Integer.TYPE) {
            this.writeFIntArr((int[])array, off, len);
        } else if (componentType == Double.TYPE) {
            this.writeFDoubleArr((double[])array, off, len);
        } else if (componentType == Float.TYPE) {
            this.writeFFloatArr((float[])array, off, len);
        } else if (componentType == Long.TYPE) {
            this.writeFLongArr((long[])array, off, len);
        } else if (componentType == Boolean.TYPE) {
            this.writeFBooleanArr((boolean[])array, off, len);
        } else {
            throw new RuntimeException("expected primitive array");
        }
    }

    @Override
    public void writeRawBytes(byte[] array, int start, int length) throws IOException {
        this.buffout.ensureFree(length);
        System.arraycopy(array, start, this.buffout.buf, this.buffout.pos, length);
        this.buffout.pos += length;
    }

    @Override
    public void writeStringUTF(String str) throws IOException {
        int strlen = str.length();
        this.writeFInt(strlen);
        this.buffout.ensureFree(strlen * 3);
        byte[] bytearr = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            bytearr[count++] = (byte)c;
            if (c < '\u00ff') continue;
            bytearr[count - 1] = -1;
            bytearr[count++] = (byte)(c >>> 0 & 0xFF);
            bytearr[count++] = (byte)(c >>> 8 & 0xFF);
        }
        this.buffout.pos = count;
    }

    void writeStringAsc(String name) throws IOException {
        int len = name.length();
        if (len >= 127) {
            throw new RuntimeException("Ascii String too long");
        }
        this.writeFByte((byte)len);
        this.buffout.ensureFree(len);
        if (this.ascStringCache == null || this.ascStringCache.length < len) {
            this.ascStringCache = new byte[len];
        }
        name.getBytes(0, len, this.ascStringCache, 0);
        this.writeRawBytes(this.ascStringCache, 0, len);
    }

    @Override
    public void writeFShort(short c) throws IOException {
        if (c < 255 && c >= 0) {
            this.writeFByte(c);
        } else {
            this.writeFByte(255);
            this.writePlainShort(c);
        }
    }

    @Override
    public void writeAttributeName(FSTClazzInfo.FSTFieldInfo subInfo) {
    }

    @Override
    public boolean writeTag(byte tag, Object info, long somValue, Object toWrite, FSTObjectOutput oout) throws IOException {
        this.writeFByte(tag);
        return false;
    }

    @Override
    public void writeFChar(char c) throws IOException {
        if (c < '\u00ff' && c >= '\u0000') {
            this.buffout.ensureFree(1);
            this.buffout.buf[this.buffout.pos++] = (byte)c;
        } else {
            this.buffout.ensureFree(3);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -1;
            buf[count++] = (byte)(c >>> 0);
            buf[count++] = (byte)(c >>> 8);
            this.buffout.pos += 3;
        }
    }

    @Override
    public final void writeFByte(int v) throws IOException {
        this.buffout.ensureFree(1);
        this.buffout.buf[this.buffout.pos++] = (byte)v;
    }

    @Override
    public void writeFInt(int anInt) throws IOException {
        if (anInt > -127 && anInt <= 127) {
            if (this.buffout.buf.length <= this.buffout.pos + 1) {
                this.buffout.ensureFree(1);
            }
            this.buffout.buf[this.buffout.pos++] = (byte)anInt;
        } else if (anInt >= Short.MIN_VALUE && anInt <= Short.MAX_VALUE) {
            this.ensureFree(3);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -128;
            buf[count++] = (byte)(anInt >>> 0);
            buf[count++] = (byte)(anInt >>> 8);
            this.buffout.pos = count;
        } else {
            this.buffout.ensureFree(5);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -127;
            buf[count++] = (byte)(anInt >>> 0 & 0xFF);
            buf[count++] = (byte)(anInt >>> 8 & 0xFF);
            buf[count++] = (byte)(anInt >>> 16 & 0xFF);
            buf[count++] = (byte)(anInt >>> 24 & 0xFF);
            this.buffout.pos = count;
        }
    }

    @Override
    public void writeFLong(long anInt) throws IOException {
        if (anInt > -126L && anInt <= 127L) {
            this.writeFByte((int)anInt);
        } else if (anInt >= -32768L && anInt <= 32767L) {
            this.ensureFree(3);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -128;
            buf[count++] = (byte)(anInt >>> 0);
            buf[count++] = (byte)(anInt >>> 8);
            this.buffout.pos = count;
        } else if (anInt >= Integer.MIN_VALUE && anInt <= Integer.MAX_VALUE) {
            this.buffout.ensureFree(5);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -127;
            buf[count++] = (byte)(anInt >>> 0 & 0xFFL);
            buf[count++] = (byte)(anInt >>> 8 & 0xFFL);
            buf[count++] = (byte)(anInt >>> 16 & 0xFFL);
            buf[count++] = (byte)(anInt >>> 24 & 0xFFL);
            this.buffout.pos = count;
        } else {
            this.buffout.ensureFree(9);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -126;
            buf[count++] = (byte)(anInt >>> 0);
            buf[count++] = (byte)(anInt >>> 8);
            buf[count++] = (byte)(anInt >>> 16);
            buf[count++] = (byte)(anInt >>> 24);
            buf[count++] = (byte)(anInt >>> 32);
            buf[count++] = (byte)(anInt >>> 40);
            buf[count++] = (byte)(anInt >>> 48);
            buf[count++] = (byte)(anInt >>> 56);
            this.buffout.pos = count;
        }
    }

    @Override
    public void writeFFloat(float value) throws IOException {
        this.writePlainInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeFDouble(double value) throws IOException {
        this.writePlainLong(Double.doubleToLongBits(value));
    }

    @Override
    public int getWritten() {
        return this.buffout.pos - this.buffout.getOff();
    }

    @Override
    public void close() throws IOException {
        this.buffout.close();
        this.conf.returnObject(this.clnames);
    }

    @Override
    public void reset(byte[] out) {
        if (out == null) {
            this.buffout.reset();
        } else {
            this.buffout.reset(out);
        }
        this.clnames.clear();
    }

    @Override
    public void skip(int i) {
        this.buffout.pos += i;
    }

    @Override
    public void writeInt32At(int position, int v) {
        this.buffout.buf[position] = (byte)(v >>> 0);
        this.buffout.buf[position + 1] = (byte)(v >>> 8);
        this.buffout.buf[position + 2] = (byte)(v >>> 16);
        this.buffout.buf[position + 3] = (byte)(v >>> 24);
    }

    @Override
    public void setOutstream(OutputStream outstream) {
        if (this.buffout == null) {
            this.buffout = (FSTOutputStream)this.conf.getCachedObject(FSTOutputStream.class);
            if (this.buffout == null) {
                this.buffout = new FSTOutputStream(1000, outstream);
            } else {
                this.buffout.reset();
            }
        }
        if (outstream == null) {
            this.buffout.setOutstream(this.buffout);
        } else {
            this.buffout.setOutstream(outstream);
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffout.flush();
    }

    @Override
    public void ensureFree(int bytes) throws IOException {
        this.buffout.ensureFree(bytes);
    }

    @Override
    public byte[] getBuffer() {
        return this.buffout.buf;
    }

    @Override
    public void registerClass(Class possible) {
        this.clnames.registerClass(possible, this.conf);
    }

    @Override
    public final void writeClass(Class cl) {
        try {
            this.clnames.encodeClass((FSTEncoder)this, cl);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public final void writeClass(FSTClazzInfo clInf) {
        try {
            this.clnames.encodeClass((FSTEncoder)this, clInf);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    private void writePlainLong(long v) throws IOException {
        this.buffout.ensureFree(8);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0);
        buf[count++] = (byte)(v >>> 8);
        buf[count++] = (byte)(v >>> 16);
        buf[count++] = (byte)(v >>> 24);
        buf[count++] = (byte)(v >>> 32);
        buf[count++] = (byte)(v >>> 40);
        buf[count++] = (byte)(v >>> 48);
        buf[count++] = (byte)(v >>> 56);
        this.buffout.pos += 8;
    }

    private void writePlainShort(int v) throws IOException {
        this.buffout.ensureFree(2);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0);
        buf[count++] = (byte)(v >>> 8);
        this.buffout.pos += 2;
    }

    private void writePlainChar(int v) throws IOException {
        this.buffout.ensureFree(2);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0);
        buf[count++] = (byte)(v >>> 8);
        this.buffout.pos += 2;
    }

    private void writePlainInt(int v) throws IOException {
        this.buffout.ensureFree(4);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0 & 0xFF);
        buf[count++] = (byte)(v >>> 8 & 0xFF);
        buf[count++] = (byte)(v >>> 16 & 0xFF);
        buf[count++] = (byte)(v >>> 24 & 0xFF);
        this.buffout.pos = count;
    }

    @Override
    public void externalEnd(FSTClazzInfo clz) {
    }

    @Override
    public boolean isWritingAttributes() {
        return false;
    }

    @Override
    public boolean isPrimitiveArray(Object array, Class<?> componentType) {
        return componentType.isPrimitive();
    }

    @Override
    public boolean isTagMultiDimSubArrays() {
        return false;
    }

    @Override
    public void writeVersionTag(int version) throws IOException {
        this.writeFByte(version);
    }

    @Override
    public boolean isByteArrayBased() {
        return true;
    }

    @Override
    public void writeArrayEnd() {
    }

    @Override
    public void writeFieldsEnd(FSTClazzInfo serializationInfo) {
    }

    @Override
    public FSTConfiguration getConf() {
        return this.conf;
    }
}

