/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTBigNumberSerializers {

    public static class FSTDoubleSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeDouble((Double)toWrite);
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            Double res = new Double(in.readDouble());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTFloatSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeFloat(((Float)toWrite).floatValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            Float res = new Float(in.readFloat());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTShortSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeShort(((Short)toWrite).shortValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            Short res = new Short(in.readShort());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTCharSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeChar(((Character)toWrite).charValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            Character res = new Character(in.readChar());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTByteSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            out.writeByte(((Byte)toWrite).byteValue());
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            Byte res = new Byte(in.readByte());
            return res;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }
}

