/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.serializers;

import de.ruedigermoeller.serialization.FSTBasicObjectSerializer;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.IOException;
import java.util.ArrayList;

public class FSTArrayListSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        ArrayList col = (ArrayList)toWrite;
        int size = col.size();
        out.writeCInt(size);
        Class[] possibleClasses = referencedBy.getPossibleClasses();
        for (int i = 0; i < size; ++i) {
            Object o = col.get(i);
            out.writeObjectInternal(o, possibleClasses);
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            int len = in.readCInt();
            ArrayList<Object> res = new ArrayList<Object>(len);
            in.registerObject(res, streamPositioin, serializationInfo, referencee);
            Class[] possibleClasses = referencee.getPossibleClasses();
            for (int i = 0; i < len; ++i) {
                Object o = in.readObjectInternal(possibleClasses);
                res.add(o);
            }
            return res;
        }
        catch (Throwable th) {
            throw FSTUtil.rethrow(th);
        }
    }
}

