/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class FSTOutputStream
extends OutputStream {
    public byte[] buf;
    public int pos;
    OutputStream outstream;

    public FSTOutputStream(OutputStream out) {
        this(32000, out);
    }

    public FSTOutputStream(int size, OutputStream out) {
        this.buf = new byte[size];
        this.outstream = out;
    }

    public OutputStream getOutstream() {
        return this.outstream;
    }

    public void setOutstream(OutputStream outstream) {
        this.outstream = outstream;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public void setBuf(byte[] buf) {
        this.buf = buf;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public final void ensureFree(int free) throws IOException {
        if (this.pos + free - this.buf.length > 0) {
            this.grow(this.pos + free);
        }
    }

    public final void ensureCapacity(int minCapacity) throws IOException {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity * 2;
        if (oldCapacity > 0x3200000) {
            newCapacity = minCapacity + 0x1400000;
        } else if (oldCapacity < 1001) {
            newCapacity = 4000;
        }
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        try {
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
        catch (OutOfMemoryError ome) {
            System.out.println("OME resize from " + this.buf.length + " to " + newCapacity + " clearing caches ..");
            throw new RuntimeException(ome);
        }
    }

    public void write(int b) throws IOException {
        this.ensureCapacity(this.pos + 1);
        this.buf[this.pos] = (byte)b;
        ++this.pos;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(this.pos + len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    public void copyTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.pos);
    }

    public void reset() {
        this.pos = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    public int size() {
        return this.pos;
    }

    public void close() throws IOException {
        this.flush();
        if (this.outstream != this) {
            this.outstream.close();
        }
    }

    public void flush() throws IOException {
        if (this.pos > 0 && this.outstream != null && this.outstream != this) {
            this.copyTo(this.outstream);
            this.reset();
        }
        if (this.outstream != this) {
            this.outstream.flush();
        }
    }

    public void reset(byte[] out) {
        this.reset();
        this.buf = out;
    }
}

