/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTClazzInfoRegistry;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.util.FSTIdentity2IdMap;
import de.ruedigermoeller.serialization.util.FSTInt2ObjectMap;
import de.ruedigermoeller.serialization.util.FSTObject2IntMap;
import de.ruedigermoeller.serialization.util.FSTUtil;

public final class FSTObjectRegistry {
    public static final int OBJ_DIVISOR = 16;
    boolean disabled = false;
    FSTIdentity2IdMap objects = new FSTIdentity2IdMap(97);
    FSTInt2ObjectMap idToObject = new FSTInt2ObjectMap(17);
    FSTObject2IntMap equalsMap = new FSTObject2IntMap(17, true);
    FSTConfiguration conf;
    FSTClazzInfoRegistry reg;
    Object[] reuseMap = new Object[4000];
    private int highestPos;

    public FSTObjectRegistry(FSTConfiguration conf) {
        this.conf = conf;
        this.disabled = !conf.isShareReferences();
        this.reg = conf.getCLInfoRegistry();
    }

    public void clearFully() {
        this.objects.clear();
        this.idToObject.clear();
        this.equalsMap.clear();
        this.disabled = !this.conf.isShareReferences();
        FSTUtil.clear(this.reuseMap);
    }

    public void clearForRead() {
        boolean bl = this.disabled = !this.conf.isShareReferences();
        if (!this.disabled) {
            this.idToObject.clear();
            FSTUtil.clear(this.reuseMap, this.highestPos);
        }
        this.highestPos = 0;
    }

    public void clearForWrite() {
        this.objects.clear();
        this.equalsMap.clear();
        this.disabled = !this.conf.isShareReferences();
    }

    public Object getReadRegisteredObject(int handle) {
        if (this.disabled) {
            return null;
        }
        int pos = handle / 16;
        if (pos < this.reuseMap.length) {
            if (this.reuseMap[pos] == null) {
                return null;
            }
            Object candidate = this.idToObject.get(handle);
            if (candidate == null) {
                return this.reuseMap[pos];
            }
            return candidate;
        }
        this.idToObject.get(handle);
        return this.idToObject.get(FSTConfiguration.getInt(handle));
    }

    public void replace(Object old, Object replaced, int streamPos) {
        int pos = streamPos / 16;
        Object[] reuseMap = this.reuseMap;
        if (pos < reuseMap.length) {
            if (this.reuseMap[pos] == old) {
                this.reuseMap[pos] = replaced;
            } else if (this.reuseMap[pos] == null) {
                this.reuseMap[pos] = replaced;
            } else {
                this.idToObject.put(streamPos, replaced);
            }
        } else {
            this.idToObject.put(streamPos, replaced);
        }
    }

    public void registerObjectForRead(Object o, int streamPosition) {
        if (this.disabled) {
            return;
        }
        int pos = streamPosition / 16;
        Object[] reuseMap = this.reuseMap;
        if (pos < reuseMap.length) {
            int n = this.highestPos = pos > this.highestPos ? pos : this.highestPos;
            if (this.reuseMap[pos] == null) {
                this.reuseMap[pos] = o;
            } else {
                this.idToObject.put(streamPosition, o);
            }
        } else {
            this.idToObject.put(streamPosition, o);
        }
    }

    public int registerObjectForWrite(Object o, boolean dontCheckEqual, int streamPosition, FSTClazzInfo clzInfo, int[] reUseType) {
        boolean reUseEquals;
        if (this.disabled) {
            return Integer.MIN_VALUE;
        }
        Class<?> clazz = o.getClass();
        if (clzInfo == null) {
            clzInfo = this.reg.getCLInfo(clazz);
        } else if (clzInfo.isFlat()) {
            return Integer.MIN_VALUE;
        }
        int handle = this.objects.putOrGet(o, streamPosition);
        if (handle >= 0) {
            reUseType[0] = 0;
            return handle;
        }
        boolean bl = reUseEquals = !dontCheckEqual && clzInfo != null && !clazz.isArray() && !clazz.isPrimitive();
        if (reUseEquals) {
            int integer;
            boolean bl2 = reUseEquals = reUseEquals && (clzInfo.isEqualIsIdentity() || clzInfo.isEqualIsBinary());
            if (reUseEquals && (integer = this.equalsMap.get(o)) != Integer.MIN_VALUE) {
                reUseType[0] = 1;
                return integer;
            }
        }
        if (reUseEquals) {
            this.equalsMap.put(o, streamPosition);
        }
        return Integer.MIN_VALUE;
    }

    boolean isReuseEqualsByIdentity(Class aClass, FSTClazzInfo serializationInfo) {
        return serializationInfo.isEqualIsIdentity();
    }

    boolean isReuseByCopy(Class aClass, FSTClazzInfo serializationInfo) {
        return serializationInfo.isEqualIsBinary();
    }

    public int getObjectSize() {
        return this.objects.size();
    }
}

