/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.dson;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.dson.DsonCharInput;
import de.ruedigermoeller.serialization.dson.DsonPSCharOut;
import de.ruedigermoeller.serialization.dson.DsonParseException;
import de.ruedigermoeller.serialization.dson.DsonSerializer;
import de.ruedigermoeller.serialization.dson.DsonStringCharInput;
import de.ruedigermoeller.serialization.dson.DsonTypeMapper;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class DsonDeserializer {
    protected DsonCharInput in;
    protected DsonTypeMapper mapper;

    public DsonDeserializer(DsonCharInput in, DsonTypeMapper mapper) {
        this.in = in;
        this.mapper = mapper;
    }

    protected void skipWS() {
        int ch = this.in.readChar();
        while (ch >= 0 && Character.isWhitespace(ch)) {
            ch = this.in.readChar();
        }
        if (ch == 35) {
            ch = this.in.readChar();
            while (ch >= 0 && ch != 10) {
                ch = this.in.readChar();
            }
            this.skipWS();
        } else {
            this.in.back(1);
        }
    }

    public Object readObject() throws Exception {
        try {
            this.skipWS();
            String type = this.readId();
            Object literal = this.mapper.mapLiteral(type);
            if (literal != null) {
                return literal;
            }
            this.skipWS();
            Class mappedClass = this.mapper.getType(type);
            if (mappedClass == null) {
                throw new RuntimeException("could not ressolve class '" + type + "' position " + this.in.position());
            }
            FSTClazzInfo clInfo = FSTConfiguration.getDefaultConfiguration().getCLInfoRegistry().getCLInfo(mappedClass);
            int ch = this.in.readChar();
            if (ch != 123) {
                this.in.back(1);
            }
            String implied = null;
            if (this.in.peekChar() == 58) {
                implied = this.mapper.getImpliedAttr(mappedClass, type);
                if (implied == null) {
                    throw new DsonParseException("expected implied attribute", this.in);
                }
                this.skipWS();
            }
            Object res = clInfo.newInstance();
            this.readFields(implied, res, clInfo);
            return res;
        }
        catch (Exception ex) {
            throw new DsonParseException("unexpected error, tried reading object", this.in, ex);
        }
    }

    protected void readFields(String implied, Object target, FSTClazzInfo clz) throws Exception {
        this.skipWS();
        while (this.in.peekChar() != 125 && this.in.peekChar() != 59) {
            String name = this.readId();
            if (name.length() == 0 && implied != null) {
                name = implied;
            }
            this.skipWS();
            int ch = this.in.readChar();
            FSTClazzInfo.FSTFieldInfo fieldInfo = clz.getFieldInfo(name, null);
            if (ch == 58) {
                this.skipWS();
                if (implied != null && name.equals(implied) && this.in.peekChar() == 123) {
                    this.in.readChar();
                }
                this.readValue(target, fieldInfo);
            } else if (fieldInfo.getType() == Boolean.TYPE) {
                fieldInfo.setBooleanValue(target, true);
                this.in.back(1);
            } else {
                throw new DsonParseException("expected key value", this.in);
            }
            this.skipWS();
        }
        this.in.readChar();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readValue(Object target, FSTClazzInfo.FSTFieldInfo field) throws Exception {
        this.skipWS();
        int ch = this.in.peekChar();
        if (ch == 34 || ch == 39 || field != null && this.isStringValue(field.getType())) {
            field.setObjectValue(target, this.mapper.coerceReading(field.getType(), this.readString(ch == 34 || ch == 39)));
            return;
        } else if (ch == 91) {
            this.readArray(target, field);
            return;
        } else if (Character.isLetter(ch)) {
            field.setObjectValue(target, this.readObject());
            return;
        } else {
            if (!Character.isDigit(ch) && ch != 43 && ch != 45 && ch != 46) return;
            Class type = field.getType();
            if (type == Float.TYPE || type == Double.TYPE) {
                String num = this.readNums();
                double val = Double.parseDouble(num);
                if (type == Double.TYPE) {
                    field.setDoubleValue(target, val);
                    return;
                } else if (type == Float.TYPE) {
                    field.setFloatValue(target, (float)val);
                    return;
                } else {
                    if (type != String.class) throw new RuntimeException("cannot assign floating point to " + type.getName());
                    field.setObjectValue(target, "" + val);
                }
                return;
            } else {
                boolean neg = false;
                if (ch == 43) {
                    this.in.readChar();
                } else if (ch == 45) {
                    neg = true;
                    this.in.readChar();
                }
                long l = this.readLong() * (long)(neg ? -1 : 1);
                if (type == Boolean.TYPE) {
                    field.setBooleanValue(target, l != 0L);
                    return;
                } else if (type == Byte.TYPE) {
                    field.setByteValue(target, (byte)l);
                    return;
                } else if (type == Character.TYPE) {
                    field.setCharValue(target, (char)l);
                    return;
                } else if (type == Short.TYPE) {
                    field.setShortValue(target, (short)l);
                    return;
                } else if (type == Integer.TYPE) {
                    field.setIntValue(target, (int)l);
                    return;
                } else if (type == Long.TYPE) {
                    field.setLongValue(target, l);
                    return;
                } else if (type == String.class) {
                    field.setObjectValue(target, "" + l);
                    return;
                } else {
                    if (type != Object.class) throw new RuntimeException("cannot assign number to " + type.getName());
                    field.setObjectValue(target, l);
                }
            }
        }
    }

    protected void readArray(Object target, FSTClazzInfo.FSTFieldInfo field) throws Exception {
        this.in.readChar();
        this.skipWS();
        int ch = this.in.peekChar();
        ArrayList<Object> objects = new ArrayList<Object>();
        while (ch != 93) {
            if (ch == 34 || ch == 39 || field != null && this.isStringValue(field.getType().getComponentType())) {
                objects.add(this.readString(ch == 34 || ch == 39));
            } else if (this.isIdStart(ch)) {
                objects.add(this.readObject());
            } else if (Character.isDigit(ch) || ch == 43 || ch == 45 || ch == 46) {
                boolean neg = false;
                if (ch == 43) {
                    this.in.readChar();
                } else if (ch == 45) {
                    neg = true;
                    this.in.readChar();
                }
                long l = this.readLong() * (long)(neg ? -1 : 1);
                if (this.in.peekChar() == 46) {
                    String num = l + this.readNums();
                    objects.add(Double.parseDouble(num));
                } else {
                    objects.add(l);
                }
            } else {
                throw new RuntimeException("could not parse '" + this.in.getString(this.in.position() - 10, 10) + "' expected array elements or ]");
            }
            this.skipWS();
            ch = this.in.peekChar();
            if (ch != 44 && ch != 62 && ch != 58) continue;
            this.in.readChar();
            this.skipWS();
            ch = this.in.peekChar();
        }
        this.in.readChar();
        Class<Object> arrayType = field.getArrayType();
        if (arrayType == null) {
            arrayType = Object.class;
        }
        Object array = Array.newInstance(arrayType, objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            Class<Object> type = arrayType;
            if (type == Boolean.TYPE) {
                ((boolean[])array)[i] = ((Number)o).intValue() != 0;
                continue;
            }
            if (type == Byte.TYPE) {
                ((byte[])array)[i] = ((Number)o).byteValue();
                continue;
            }
            if (type == Character.TYPE) {
                ((char[])array)[i] = (char)((Number)o).intValue();
                continue;
            }
            if (type == Short.TYPE) {
                ((short[])array)[i] = ((Number)o).shortValue();
                continue;
            }
            if (type == Integer.TYPE) {
                ((int[])array)[i] = ((Number)o).intValue();
                continue;
            }
            if (type == Long.TYPE) {
                ((long[])array)[i] = ((Number)o).longValue();
                continue;
            }
            if (type == Float.TYPE) {
                ((float[])array)[i] = ((Number)o).floatValue();
                continue;
            }
            if (type == Double.TYPE) {
                ((double[])array)[i] = ((Number)o).doubleValue();
                continue;
            }
            Array.set(array, i, this.mapper.coerceReading(type, o));
        }
        field.setObjectValue(target, this.mapper.coerceReading(field.getType(), array));
    }

    protected boolean isStringValue(Class type) {
        return type == String.class;
    }

    protected long readLong() {
        long res = 0L;
        long fak = 1L;
        int ch = this.in.readChar();
        while (Character.isDigit(ch)) {
            res += (long)(ch - 48) * fak;
            fak *= 10L;
            ch = this.in.readChar();
        }
        this.in.back(1);
        long reverse = 0L;
        while (res != 0L) {
            reverse = reverse * 10L + res % 10L;
            res /= 10L;
        }
        return reverse;
    }

    protected String readString(boolean quoted) {
        StringBuilder b = new StringBuilder(15);
        int end = quoted ? this.in.readChar() : 32;
        int ch = this.in.readChar();
        while (quoted && ch != end || !quoted && ch > 32 && ch != 35 && ch != 125 && ch != 93 && ch != 59 && ch != 44 && !Character.isWhitespace(ch)) {
            block14: {
                block13: {
                    if (ch != 92) break block13;
                    ch = this.in.readChar();
                    switch (ch) {
                        case 92: {
                            b.append(ch);
                            break block14;
                        }
                        case 34: {
                            b.append('\"');
                            break block14;
                        }
                        case 47: {
                            b.append('/');
                            break block14;
                        }
                        case 98: {
                            b.append('\b');
                            break block14;
                        }
                        case 102: {
                            b.append('\f');
                            break block14;
                        }
                        case 110: {
                            b.append('\n');
                            break block14;
                        }
                        case 114: {
                            b.append('\r');
                            break block14;
                        }
                        case 116: {
                            b.append('\t');
                            break block14;
                        }
                        case 117: {
                            b.append("\\u" + (char)this.in.readChar() + (char)this.in.readChar() + (char)this.in.readChar() + (char)this.in.readChar());
                            break block14;
                        }
                        default: {
                            throw new RuntimeException("unknown escape " + (char)ch + " in " + this.in.position());
                        }
                    }
                }
                b.append((char)ch);
            }
            ch = this.in.readChar();
        }
        if (!quoted) {
            this.in.back(1);
        }
        return b.toString();
    }

    protected String readNums() {
        this.skipWS();
        int pos = this.in.position();
        int ch = this.in.readChar();
        while (Character.isDigit(ch) || ch == 46 || ch == 69 || ch == 101 || ch == 43 || ch == 45) {
            ch = this.in.readChar();
        }
        this.in.back(1);
        return this.in.getString(pos, this.in.position() - pos);
    }

    protected String readId() {
        this.skipWS();
        int pos = this.in.position();
        int ch = this.in.readChar();
        while (this.isIdPart(ch) && ch != 58) {
            ch = this.in.readChar();
        }
        this.in.back(1);
        return this.in.getString(pos, this.in.position() - pos);
    }

    protected boolean isIdPart(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 36 || ch == 35;
    }

    protected boolean isIdStart(int ch) {
        return Character.isLetter(ch) || ch == 36 || ch == 35;
    }

    public static void main(String[] a) throws Exception {
        DsonTypeMapper mapper = new DsonTypeMapper();
        mapper.map("cond", UD.class).map("and", UD.class).map("or", UD.class).map("attr", UD.class).map("select", Sel.class).map("subscribe", Sub.class).implyAttrFromType("and", "and").implyAttrFromType("or", "or").implyAttrFromType("attr", "attr").implyAttrFromType("select", "cond").implyAttrFromType("subscribe", "cond");
        DsonDeserializer ser = null;
        DataInputStream in = new DataInputStream(new FileInputStream("c:\\tmp\\test.dson"));
        StringBuilder b = new StringBuilder();
        int c = 0;
        try {
            do {
                if ((c = in.read()) < 0) continue;
                b.append((char)c);
            } while (c >= 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        String file = b.toString();
        long tim = System.currentTimeMillis();
        Object read = null;
        for (int i = 0; i < 1; ++i) {
            ser = new DsonDeserializer(new DsonStringCharInput(file), mapper);
            read = ser.readObject();
        }
        new DsonSerializer(new DsonPSCharOut(System.out), mapper).writeObject(read);
    }

    public static class Sub {
        UD cond;
    }

    public static class Sel {
        UD cond;
    }

    public static class UD {
        String attr;
        Object greater;
        String contains;
        Object lesser;
        Object equals;
        Object greaterEq;
        Object lesserEq;
        UD[] and;
        UD[] or;
        boolean negate;
    }
}

