/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTClazzInfoRegistry;
import de.ruedigermoeller.serialization.FSTClazzNameRegistry;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectRegistry;
import de.ruedigermoeller.serialization.FSTObjectSerializer;
import de.ruedigermoeller.serialization.FSTSerialisationListener;
import de.ruedigermoeller.serialization.util.FSTOutputStream;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;

public class FSTObjectOutput
extends DataOutputStream
implements ObjectOutput {
    private static final boolean UNSAFE_MEMCOPY_ARRAY_INT = true;
    private static final boolean UNSAFE_MEMCOPY_ARRAY_LONG = true;
    private static final boolean UNSAFE_WRITE_CINT_ARR = true;
    private static final boolean UNSAFE_WRITE_CINT = true;
    private static final boolean UNSAFE_WRITE_FINT = true;
    private static final boolean UNSAFE_WRITE_FLONG = true;
    private static final boolean UNSAFE_WRITE_UTF = true;
    static final long bufoff;
    static final long choff;
    static final long intoff;
    static final long longoff;
    static final long intscal;
    static final long longscal;
    static final long chscal;
    static final byte ONE_OF = -18;
    static final byte BIG_BOOLEAN_FALSE = -17;
    static final byte BIG_BOOLEAN_TRUE = -16;
    static final byte BIG_LONG = -10;
    static final byte BIG_INT = -9;
    static final byte COPYHANDLE = -8;
    static final byte HANDLE = -7;
    static final byte ENUM = -6;
    static final byte ARRAY = -5;
    static final byte TYPED = -3;
    static final byte NULL = -1;
    static final byte OBJECT = 0;
    public static final boolean DUMP = false;
    public FSTClazzNameRegistry clnames;
    FSTConfiguration conf;
    FSTObjectRegistry objects;
    FSTOutputStream buffout;
    FSTSerialisationListener listener;
    int curDepth = 0;
    int writeExternalWriteAhead = 5000;
    Unsafe unsafe;
    static ByteArrayOutputStream empty;
    boolean closed = false;
    FSTClazzInfo.FSTFieldInfo[] refs = new FSTClazzInfo.FSTFieldInfo[20];
    int[] tmp = new int[]{0};
    static int[] charMap;
    static String enc;
    char[] charBuf;

    public FSTObjectOutput(OutputStream out) {
        this(out, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectOutput(OutputStream out, FSTConfiguration conf) {
        super(null);
        this.unsafe = FSTUtil.unsafe;
        this.conf = conf;
        this.buffout = (FSTOutputStream)conf.getCachedObject(FSTOutputStream.class);
        if (this.buffout == null) {
            this.buffout = new FSTOutputStream(1000, out);
        } else {
            this.buffout.reset();
            this.buffout.setOutstream(out);
        }
        this.out = this.buffout;
        this.objects = (FSTObjectRegistry)conf.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(conf);
            this.objects.disabled = !conf.isShareReferences();
        } else {
            this.objects.clearForWrite();
        }
        this.clnames = (FSTClazzNameRegistry)conf.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(conf.getClassRegistry(), conf);
        } else {
            this.clnames.clear();
        }
    }

    public FSTObjectOutput(FSTConfiguration conf) {
        this(null, conf);
        this.buffout.setOutstream(this.buffout);
    }

    public FSTObjectOutput() {
        this(null, FSTConfiguration.getDefaultConfiguration());
        this.buffout.setOutstream(this.buffout);
    }

    @Override
    public void flush() throws IOException {
        this.buffout.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        super.close();
        this.resetAndClearRefs();
        this.conf.returnObject(this.buffout, this.objects, this.clnames);
    }

    public int getWriteExternalWriteAhead() {
        return this.writeExternalWriteAhead;
    }

    public void setWriteExternalWriteAhead(int writeExternalWriteAhead) {
        this.writeExternalWriteAhead = writeExternalWriteAhead;
    }

    public void ensureFree(int bytes) throws IOException {
        this.buffout.ensureFree(bytes);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.writeObject(obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object obj, Class ... possibles) throws IOException {
        ++this.curDepth;
        try {
            if (possibles != null) {
                for (int i = 0; i < possibles.length; ++i) {
                    Class possible = possibles[i];
                    this.clnames.registerClass(possible);
                    this.clnames.addCLNameSnippets(possible);
                }
            }
            this.writeObjectInternal(obj, possibles);
        }
        finally {
            this.buffout.flush();
            --this.curDepth;
        }
    }

    FSTClazzInfo.FSTFieldInfo getCachedFI(Class ... possibles) {
        if (this.curDepth >= this.refs.length) {
            return new FSTClazzInfo.FSTFieldInfo(possibles, null, true);
        }
        FSTClazzInfo.FSTFieldInfo inf = this.refs[this.curDepth];
        if (inf == null) {
            this.refs[this.curDepth] = inf = new FSTClazzInfo.FSTFieldInfo(possibles, null, true);
            return inf;
        }
        inf.setPossibleClasses(possibles);
        return inf;
    }

    public void writeObjectInternal(Object obj, Class ... possibles) throws IOException {
        if (this.curDepth == 0) {
            throw new RuntimeException("not intended to be called from external application. Use public writeObject instead");
        }
        FSTClazzInfo.FSTFieldInfo info = this.getCachedFI(possibles);
        ++this.curDepth;
        this.writeObjectWithContext(info, obj);
        --this.curDepth;
    }

    public FSTSerialisationListener getListener() {
        return this.listener;
    }

    public void setListener(FSTSerialisationListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        block37: {
            int startPosition = 0;
            if (this.listener != null) {
                startPosition = this.getWritten();
                this.listener.objectWillBeWritten(toWrite, startPosition);
            }
            try {
                boolean needsEqualMap;
                int handle;
                if (toWrite == null) {
                    this.writeFByte(-1);
                    return;
                }
                Class<?> clazz = toWrite.getClass();
                if (clazz == Integer.class) {
                    this.writeFByte(-9);
                    this.writeCInt((Integer)toWrite);
                    return;
                }
                if (clazz == Long.class) {
                    this.writeFByte(-10);
                    this.writeCLong((Long)toWrite);
                    return;
                }
                if (clazz == Boolean.class) {
                    this.writeFByte((Boolean)toWrite != false ? -16 : -17);
                    return;
                }
                if (clazz.isArray()) {
                    this.writeFByte(-5);
                    this.writeArray(referencee, toWrite);
                    return;
                }
                if (toWrite instanceof Enum) {
                    this.writeFByte(-6);
                    boolean isEnumClass = toWrite.getClass().isEnum();
                    if (!isEnumClass) {
                        Class<?> c = toWrite.getClass();
                        while (c != null && !c.isEnum()) {
                            c = toWrite.getClass().getEnclosingClass();
                        }
                        if (c == null) {
                            throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                        }
                        this.clnames.encodeClass(this, c);
                    } else {
                        this.writeClass(toWrite);
                    }
                    this.writeCInt(((Enum)toWrite).ordinal());
                    return;
                }
                String[] oneOf = referencee.getOneOf();
                if (oneOf != null) {
                    for (int i = 0; i < oneOf.length; ++i) {
                        String s = oneOf[i];
                        if (!s.equals(toWrite)) continue;
                        this.writeFByte(-18);
                        this.writeFByte(i);
                        return;
                    }
                }
                FSTClazzInfo serializationInfo = this.getFstClazzInfo(referencee, clazz);
                FSTObjectSerializer ser = serializationInfo.getSer();
                if (!(referencee.isFlat() || serializationInfo.isFlat() || ser != null && ser.alwaysCopy() || (handle = this.objects.registerObjectForWrite(toWrite, !(needsEqualMap = serializationInfo.isEqualIsBinary() || serializationInfo.isEqualIsIdentity()), this.written, serializationInfo, this.tmp)) < 0)) {
                    boolean isIdentical;
                    boolean bl = isIdentical = this.tmp[0] == 0;
                    if (isIdentical || serializationInfo.isEqualIsIdentity()) {
                        this.writeFByte(-7);
                        this.writeCInt(handle);
                        return;
                    }
                    if (serializationInfo.isEqualIsBinary()) {
                        this.writeFByte(-8);
                        this.writeCInt(handle);
                        return;
                    }
                }
                if (ser == null) {
                    if (serializationInfo.getWriteReplaceMethod() != null) {
                        Object replaced = null;
                        try {
                            replaced = serializationInfo.getWriteReplaceMethod().invoke(toWrite, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new IOException(e);
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        if (replaced != toWrite) {
                            toWrite = replaced;
                            serializationInfo = this.getClassInfoRegistry().getCLInfo(toWrite.getClass());
                        }
                    }
                    if (serializationInfo.useCompatibleMode()) {
                        this.writeObjectCompatible(referencee, toWrite, serializationInfo);
                        return;
                    }
                    this.writeObjectHeader(serializationInfo, referencee, toWrite);
                    this.defaultWriteObject(toWrite, serializationInfo);
                    break block37;
                }
                int pos = this.written;
                this.writeObjectHeader(serializationInfo, referencee, toWrite);
                ser.writeObject(this, toWrite, serializationInfo, referencee, pos);
            }
            finally {
                if (this.listener != null) {
                    this.listener.objectHasBeenWritten(toWrite, startPosition, this.getWritten());
                }
            }
        }
    }

    private FSTClazzInfo getFstClazzInfo(FSTClazzInfo.FSTFieldInfo referencee, Class clazz) {
        FSTClazzInfo serializationInfo = null;
        FSTClazzInfo lastInfo = referencee.lastInfo;
        if (lastInfo != null && lastInfo.getClazz() == clazz) {
            serializationInfo = lastInfo;
        } else {
            referencee.lastInfo = serializationInfo = this.getClassInfoRegistry().getCLInfo(clazz);
        }
        return serializationInfo;
    }

    public void defaultWriteObject(Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        if (serializationInfo.isExternalizable()) {
            this.buffout.ensureFree(this.writeExternalWriteAhead);
            ((Externalizable)toWrite).writeExternal(this);
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = serializationInfo.getFieldInfo();
            this.writeObjectFields(toWrite, serializationInfo, fieldInfo);
        }
    }

    private void writeObjectCompatible(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        this.writeObjectHeader(serializationInfo, referencee, toWrite);
        Class cl = serializationInfo.getClazz();
        this.writeObjectCompatibleRecursive(referencee, toWrite, serializationInfo, cl);
    }

    private void writeObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo serializationInfo, Class cl) throws IOException {
        FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = serializationInfo.compInfo.get(cl);
        if (!Serializable.class.isAssignableFrom(cl)) {
            return;
        }
        this.writeObjectCompatibleRecursive(referencee, toWrite, serializationInfo, cl.getSuperclass());
        if (fstCompatibilityInfo != null && fstCompatibilityInfo.getWriteMethod() != null) {
            try {
                fstCompatibilityInfo.getWriteMethod().invoke(toWrite, this.getObjectOutputStream(cl, serializationInfo, referencee, toWrite));
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        } else if (fstCompatibilityInfo != null) {
            this.writeObjectFields(toWrite, serializationInfo, fstCompatibilityInfo.getFieldArray());
        }
    }

    private void writeObjectFields(Object toWrite, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo) throws IOException {
        if (this.unsafe != null) {
            this.writeObjectFieldsUnsafe(toWrite, serializationInfo, fieldInfo, !this.conf.preferSpeed);
        } else {
            this.writeObjectFieldsSafe(toWrite, serializationInfo, fieldInfo, !this.conf.preferSpeed);
        }
    }

    private void writeObjectFieldsSafe(Object toWrite, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, boolean compact) throws IOException {
        try {
            int booleanMask = 0;
            int boolcount = 0;
            int length = fieldInfo.length;
            for (int j = 0; j < length; ++j) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[j];
                if (subInfo.getType() != Boolean.TYPE) {
                    if (boolcount <= 0) break;
                    this.writeFByte(booleanMask << 8 - boolcount);
                    break;
                }
                if (boolcount == 8) {
                    this.writeFByte(booleanMask << 8 - boolcount);
                    boolcount = 0;
                    booleanMask = 0;
                }
                boolean booleanValue = subInfo.getBooleanValue(toWrite);
                booleanMask <<= 1;
                booleanMask |= booleanValue ? 1 : 0;
                ++boolcount;
            }
            for (int i = j; i < length; ++i) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isPrimitive()) {
                    int integralType = subInfo.getIntegralType();
                    if (compact) {
                        switch (integralType) {
                            case 2: {
                                this.writeFByte(subInfo.getByteValue(toWrite));
                                break;
                            }
                            case 3: {
                                this.writeCChar((char)subInfo.getCharValue(toWrite));
                                break;
                            }
                            case 4: {
                                this.writeCShort((short)subInfo.getShortValue(toWrite));
                                break;
                            }
                            case 5: {
                                this.writeCInt(subInfo.getIntValue(toWrite));
                                break;
                            }
                            case 6: {
                                this.writeCLong(subInfo.getLongValue(toWrite));
                                break;
                            }
                            case 7: {
                                this.writeCFloat(subInfo.getFloatValue(toWrite));
                                break;
                            }
                            case 8: {
                                this.writeCDouble(subInfo.getDoubleValue(toWrite));
                            }
                        }
                        continue;
                    }
                    switch (integralType) {
                        case 2: {
                            this.writeFByte(subInfo.getByteValue(toWrite));
                            break;
                        }
                        case 3: {
                            this.writeFChar((char)subInfo.getCharValue(toWrite));
                            break;
                        }
                        case 4: {
                            this.writeFShort((short)subInfo.getShortValue(toWrite));
                            break;
                        }
                        case 5: {
                            this.writeFInt(subInfo.getIntValue(toWrite));
                            break;
                        }
                        case 6: {
                            this.writeFLong(subInfo.getLongValue(toWrite));
                            break;
                        }
                        case 7: {
                            this.writeFFloat(subInfo.getFloatValue(toWrite));
                            break;
                        }
                        case 8: {
                            this.writeFDouble(subInfo.getDoubleValue(toWrite));
                        }
                    }
                    continue;
                }
                if (subInfo.isConditional()) {
                    int conditional = this.buffout.pos;
                    this.buffout.pos += 4;
                    this.written += 4;
                    Object subObject = subInfo.getObjectValue(toWrite);
                    if (subObject == null) {
                        this.writeFByte(-1);
                    } else {
                        this.writeObjectWithContext(subInfo, subObject);
                    }
                    int v = this.buffout.pos;
                    this.buffout.buf[conditional] = (byte)(v >>> 24 & 0xFF);
                    this.buffout.buf[conditional + 1] = (byte)(v >>> 16 & 0xFF);
                    this.buffout.buf[conditional + 2] = (byte)(v >>> 8 & 0xFF);
                    this.buffout.buf[conditional + 3] = (byte)(v >>> 0 & 0xFF);
                    continue;
                }
                Object subObject = subInfo.getObjectValue(toWrite);
                if (subObject == null) {
                    this.writeFByte(-1);
                    continue;
                }
                this.writeObjectWithContext(subInfo, subObject);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex);
        }
    }

    private void writeObjectFieldsUnsafe(Object toWrite, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, boolean compact) throws IOException {
        try {
            int booleanMask = 0;
            int boolcount = 0;
            int length = fieldInfo.length;
            for (int j = 0; j < length; ++j) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[j];
                if (subInfo.getType() != Boolean.TYPE) {
                    if (boolcount <= 0) break;
                    this.writeFByteUnsafe(booleanMask << 8 - boolcount);
                    break;
                }
                if (boolcount == 8) {
                    this.writeFByteUnsafe(booleanMask << 8 - boolcount);
                    boolcount = 0;
                    booleanMask = 0;
                }
                boolean booleanValue = this.unsafe.getBoolean(toWrite, subInfo.memOffset);
                booleanMask <<= 1;
                booleanMask |= booleanValue ? 1 : 0;
                ++boolcount;
            }
            for (int i = j; i < length; ++i) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isPrimitive()) {
                    int integralType = subInfo.getIntegralType();
                    if (integralType == 5) {
                        if (compact) {
                            this.writeCIntUnsafe(this.unsafe.getInt(toWrite, subInfo.memOffset));
                            continue;
                        }
                        int val = this.unsafe.getInt(toWrite, subInfo.memOffset);
                        this.buffout.ensureFree(4);
                        this.unsafe.putInt(this.buffout.buf, (long)this.buffout.pos + bufoff, val);
                        this.buffout.pos += 4;
                        this.written += 4;
                        continue;
                    }
                    if (integralType == 6) {
                        if (compact) {
                            this.writeCLong(this.unsafe.getLong(toWrite, subInfo.memOffset));
                            continue;
                        }
                        long lval = this.unsafe.getLong(toWrite, subInfo.memOffset);
                        this.buffout.ensureFree(8);
                        this.unsafe.putLong(this.buffout.buf, (long)this.buffout.pos + bufoff, lval);
                        this.buffout.pos += 8;
                        this.written += 8;
                        continue;
                    }
                    if (compact) {
                        switch (integralType) {
                            case 2: {
                                this.writeFByteUnsafe(this.unsafe.getByte(toWrite, subInfo.memOffset));
                                break;
                            }
                            case 3: {
                                this.writeCChar(this.unsafe.getChar(toWrite, subInfo.memOffset));
                                break;
                            }
                            case 4: {
                                this.writeCShort(this.unsafe.getShort(toWrite, subInfo.memOffset));
                                break;
                            }
                            case 7: {
                                this.writeCFloatUnsafe(this.unsafe.getFloat(toWrite, subInfo.memOffset));
                                break;
                            }
                            case 8: {
                                this.writeCDoubleUnsafe(this.unsafe.getDouble(toWrite, subInfo.memOffset));
                            }
                        }
                        continue;
                    }
                    switch (integralType) {
                        case 2: {
                            this.writeFByteUnsafe(this.unsafe.getByte(toWrite, subInfo.memOffset));
                            break;
                        }
                        case 3: {
                            this.writeFChar(this.unsafe.getChar(toWrite, subInfo.memOffset));
                            break;
                        }
                        case 4: {
                            this.writeFShort(this.unsafe.getShort(toWrite, subInfo.memOffset));
                            break;
                        }
                        case 7: {
                            this.writeFFloat(this.unsafe.getFloat(toWrite, subInfo.memOffset));
                            break;
                        }
                        case 8: {
                            this.writeFDoubleUnsafe(this.unsafe.getDouble(toWrite, subInfo.memOffset));
                        }
                    }
                    continue;
                }
                if (subInfo.isConditional()) {
                    int conditional = this.buffout.pos;
                    this.buffout.pos += 4;
                    this.written += 4;
                    Object subObject = subInfo.getObjectValueUnsafe(toWrite);
                    if (subObject == null) {
                        this.writeFByteUnsafe(-1);
                    } else {
                        this.writeObjectWithContext(subInfo, subObject);
                    }
                    int v = this.buffout.pos;
                    this.buffout.buf[conditional] = (byte)(v >>> 24 & 0xFF);
                    this.buffout.buf[conditional + 1] = (byte)(v >>> 16 & 0xFF);
                    this.buffout.buf[conditional + 2] = (byte)(v >>> 8 & 0xFF);
                    this.buffout.buf[conditional + 3] = (byte)(v >>> 0 & 0xFF);
                    continue;
                }
                Object subObject = subInfo.getObjectValueUnsafe(toWrite);
                if (subObject == null) {
                    this.writeFByteUnsafe(-1);
                    continue;
                }
                this.writeObjectWithContext(subInfo, subObject);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex);
        }
    }

    private void writeCompatibleObjectFields(Object toWrite, Map fields, FSTClazzInfo.FSTFieldInfo[] fieldInfo) throws IOException {
        int booleanMask = 0;
        int boolcount = 0;
        if (fieldInfo.length != fields.size()) {
            System.out.println("=(((((((((((((((((((((((((((((((((((((((((((((((");
        }
        for (int i = 0; i < fieldInfo.length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (!fields.containsKey(subInfo.getField().getName())) {
                    System.out.println("(((((((((((((((((((((((((((((((((((((((((((");
                }
                boolean isarr = subInfo.isArray();
                Class subInfType = subInfo.getType();
                if ((subInfType != Boolean.TYPE || isarr) && boolcount > 0) {
                    this.writeFByte(booleanMask << 8 - boolcount);
                    boolcount = 0;
                    booleanMask = 0;
                }
                if (subInfo.isIntegral() && !isarr) {
                    if (subInfType == Boolean.TYPE) {
                        if (boolcount == 8) {
                            this.writeFByte(booleanMask << 8 - boolcount);
                            boolcount = 0;
                            booleanMask = 0;
                        }
                        boolean booleanValue = (Boolean)fields.get(subInfo.getField().getName());
                        booleanMask <<= 1;
                        booleanMask |= booleanValue ? 1 : 0;
                        ++boolcount;
                        continue;
                    }
                    if (subInfType == Integer.TYPE) {
                        this.writeCInt(((Number)fields.get(subInfo.getField().getName())).intValue());
                        continue;
                    }
                    if (subInfType == Long.TYPE) {
                        this.writeCLong(((Number)fields.get(subInfo.getField().getName())).longValue());
                        continue;
                    }
                    if (subInfType == Byte.TYPE) {
                        this.writeFByte(((Number)fields.get(subInfo.getField().getName())).byteValue());
                        continue;
                    }
                    if (subInfType == Character.TYPE) {
                        this.writeCChar((char)((Number)fields.get(subInfo.getField().getName())).intValue());
                        continue;
                    }
                    if (subInfType == Short.TYPE) {
                        this.writeCShort(((Number)fields.get(subInfo.getField().getName())).shortValue());
                        continue;
                    }
                    if (subInfType == Float.TYPE) {
                        this.writeCFloat(((Number)fields.get(subInfo.getField().getName())).floatValue());
                        continue;
                    }
                    if (subInfType != Double.TYPE) continue;
                    this.writeCDouble(((Number)fields.get(subInfo.getField().getName())).doubleValue());
                    continue;
                }
                Object subObject = fields.get(subInfo.getField().getName());
                this.writeObjectWithContext(subInfo, subObject);
                continue;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (boolcount > 0) {
            this.writeFByte(booleanMask << 8 - boolcount);
            boolcount = 0;
            booleanMask = 0;
        }
    }

    protected void writeObjectHeader(FSTClazzInfo clsInfo, FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        if (clsInfo.isEqualIsBinary()) {
            this.writeFByte(0);
            this.writeClass(toWrite);
            return;
        }
        if (!(toWrite instanceof Serializable) && !this.conf.isIgnoreSerialInterfaces()) {
            throw new RuntimeException(toWrite.getClass().getName() + " is not serializable. referenced by " + referencee.getDesc());
        }
        if (toWrite.getClass() == referencee.getType() && !clsInfo.useCompatibleMode()) {
            this.writeFByte(-3);
        } else {
            Class[] possibleClasses = referencee.getPossibleClasses();
            if (possibleClasses == null) {
                this.writeFByte(0);
                this.clnames.encodeClass(this, toWrite.getClass());
            } else {
                int length = possibleClasses.length;
                for (int j = 0; j < length; ++j) {
                    Class possibleClass = possibleClasses[j];
                    if (possibleClass != toWrite.getClass()) continue;
                    this.writeFByte(j + 1);
                    return;
                }
                this.writeFByte(0);
                this.clnames.encodeClass(this, toWrite.getClass());
            }
        }
    }

    private void writeArray(FSTClazzInfo.FSTFieldInfo referencee, Object array) throws IOException {
        if (array == null) {
            this.writeCInt(-1);
            return;
        }
        int len = Array.getLength(array);
        this.writeClass(array);
        this.writeCInt(len);
        Class<?> componentType = array.getClass().getComponentType();
        if (!componentType.isArray()) {
            if (componentType == Byte.TYPE) {
                this.writeFByteArr((byte[])array);
            } else if (componentType == Character.TYPE) {
                this.writeCCharArr((char[])array);
            } else if (componentType == Short.TYPE) {
                this.writeFShortArr((short[])array);
            } else if (componentType == Integer.TYPE) {
                if (referencee.isThin()) {
                    this.writeFIntThin((int[])array);
                } else if (referencee.isCompressed()) {
                    this.writeIntArrCompressed((int[])array);
                } else {
                    this.writeFIntArr((int[])array);
                }
            } else if (componentType == Double.TYPE) {
                this.writeFDoubleArr((double[])array);
            } else if (componentType == Float.TYPE) {
                this.writeFFloatArr((float[])array);
            } else if (componentType == Long.TYPE) {
                this.writeFLongArr((long[])array);
            } else if (componentType == Boolean.TYPE) {
                this.writeFBooleanArr((boolean[])array);
            } else {
                Object[] arr = (Object[])array;
                if (referencee.isThin()) {
                    for (int i = 0; i < len; ++i) {
                        Object toWrite = arr[i];
                        if (toWrite == null) continue;
                        this.writeCInt(i);
                        this.writeObjectWithContext(referencee, toWrite);
                    }
                    this.writeCInt(len);
                } else {
                    for (int i = 0; i < len; ++i) {
                        Object toWrite = arr[i];
                        if (toWrite == null) {
                            this.writeFByte(-1);
                            continue;
                        }
                        this.writeObjectWithContext(referencee, toWrite);
                    }
                }
            }
        } else {
            Object[] arr = (Object[])array;
            FSTClazzInfo.FSTFieldInfo ref1 = new FSTClazzInfo.FSTFieldInfo(referencee.getPossibleClasses(), null, this.conf.getCLInfoRegistry().isIgnoreAnnotations());
            for (int i = 0; i < len; ++i) {
                Object subArr = arr[i];
                if (subArr != null && !FSTUtil.isPrimitiveArray(subArr.getClass())) {
                    this.objects.registerObjectForWrite(subArr, true, this.written, null, this.tmp);
                }
                this.writeArray(ref1, subArr);
            }
        }
    }

    public void writeFBooleanArr(boolean[] array) throws IOException {
        boolean[] arr = array;
        for (int i = 0; i < arr.length; ++i) {
            this.writeBoolean(arr[i]);
        }
    }

    public void writeFLongArr(long[] array) throws IOException {
        long[] arr = array;
        if (this.unsafe != null) {
            this.writeFLongArrayUnsafe(arr);
        } else {
            for (int i = 0; i < arr.length; ++i) {
                this.writeFLong(arr[i]);
            }
        }
    }

    public void writeFFloatArr(float[] array) throws IOException {
        float[] arr = array;
        for (int i = 0; i < array.length; ++i) {
            this.writeFFloat(arr[i]);
        }
    }

    public void writeFDoubleArr(double[] array) throws IOException {
        double[] arr = array;
        for (int i = 0; i < arr.length; ++i) {
            this.writeFDouble(arr[i]);
        }
    }

    public void writeFShortArr(short[] array) throws IOException {
        short[] arr = array;
        for (int i = 0; i < array.length; ++i) {
            this.writeFShort(arr[i]);
        }
    }

    public void writeFCharArr(char[] array) throws IOException {
        this.writeCCharArr(array);
    }

    public void writeCCharArr(char[] array) throws IOException {
        char[] arr = array;
        for (int i = 0; i < arr.length; ++i) {
            this.writeCChar(arr[i]);
        }
    }

    public void writeFByteArr(byte[] array) throws IOException {
        byte[] arr = array;
        this.write(arr);
    }

    public void writeFLongArrayUnsafe(long[] arr) throws IOException {
        int length = arr.length;
        this.buffout.ensureFree((int)(longscal * (long)length));
        byte[] buf = this.buffout.buf;
        long siz = (long)length * longscal;
        this.unsafe.copyMemory(arr, longoff, buf, (long)this.buffout.pos + bufoff, siz);
        this.buffout.pos = (int)((long)this.buffout.pos + siz);
        this.written = (int)((long)this.written + siz);
    }

    public int writeStringCompressed(String str) throws IOException {
        int count;
        int strlen = str.length();
        this.writeCInt(strlen);
        this.buffout.ensureFree(strlen * 3);
        int fourBitCnt = 0;
        byte[] bytearr = this.buffout.buf;
        int initpos = count = this.buffout.pos;
        int compressBuffIdx = count;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c < '\u00fe') {
                int mapped = charMap[c];
                if (mapped < 16) {
                    ++fourBitCnt;
                } else {
                    if (fourBitCnt > 5) {
                        count = this.reEncodeStr(str, fourBitCnt, bytearr, compressBuffIdx, i);
                    }
                    fourBitCnt = 0;
                    compressBuffIdx = count + 1;
                }
            } else {
                if (fourBitCnt > 5) {
                    count = this.reEncodeStr(str, fourBitCnt, bytearr, compressBuffIdx, i);
                }
                fourBitCnt = 0;
                compressBuffIdx = count + 1;
            }
            if (c < '\u00fe') {
                bytearr[count++] = (byte)c;
                continue;
            }
            bytearr[count++] = -1;
            bytearr[count++] = (byte)(c >>> 8 & 0xFF);
            bytearr[count++] = (byte)(c >>> 0 & 0xFF);
        }
        if (fourBitCnt > 5) {
            count = this.reEncodeStr(str, fourBitCnt, bytearr, compressBuffIdx, str.length());
        }
        int required = count - initpos;
        this.written += required;
        this.buffout.pos = count;
        return required;
    }

    private int reEncodeStr(String str, int minMaxCount, byte[] bytearr, int compressBuffIdx, int i) {
        bytearr[compressBuffIdx++] = -2;
        bytearr[compressBuffIdx++] = (byte)minMaxCount;
        int bc = 0;
        for (int ii = minMaxCount; ii > 0; --ii) {
            int cc = charMap[str.charAt(i - ii)];
            if (!(bc & true)) {
                bytearr[compressBuffIdx] = (byte)cc;
                if (bc == minMaxCount - 1) {
                    ++compressBuffIdx;
                }
            } else {
                int n = compressBuffIdx++;
                bytearr[n] = (byte)(bytearr[n] | cc << 4);
            }
            ++bc;
        }
        return compressBuffIdx;
    }

    public void writeStringUTF(String str) throws IOException {
        if (this.conf.isPreferSpeed()) {
            this.writeStringUTFSpeed(str);
            return;
        }
        if (this.unsafe != null) {
            this.writeStringUTFUnsafe(str);
            return;
        }
        int strlen = str.length();
        this.writeCInt(strlen);
        this.buffout.ensureFree(strlen * 3);
        byte[] bytearr = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c < '\u00ff') {
                bytearr[count++] = (byte)c;
                ++this.written;
                continue;
            }
            bytearr[count++] = -1;
            bytearr[count++] = (byte)(c >>> 8 & 0xFF);
            bytearr[count++] = (byte)(c >>> 0 & 0xFF);
            this.written += 3;
        }
        this.buffout.pos = count;
    }

    public void writeStringUTFSpeed(String str) throws IOException {
        int strlen = str.length();
        if (this.unsafe != null) {
            this.writeFIntUnsafe(strlen);
            int added = (int)(chscal * (long)strlen);
            this.buffout.ensureFree(added);
            if (this.charBuf == null || this.charBuf.length < strlen) {
                this.charBuf = new char[strlen];
            }
            str.getChars(0, strlen, this.charBuf, 0);
            this.unsafe.copyMemory(this.charBuf, choff, this.buffout.buf, (long)this.buffout.pos + bufoff, (long)strlen * chscal);
            this.written += added;
            this.buffout.pos += added;
            return;
        }
        this.writeFInt(strlen);
        this.buffout.ensureFree(strlen * 2);
        byte[] bytearr = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            bytearr[count++] = (byte)(c >>> 0 & 0xFF);
            bytearr[count++] = (byte)(c >>> 8 & 0xFF);
            this.written += 2;
        }
        this.buffout.pos = count;
    }

    public void writeStringUTFUnsafe(String str) throws IOException {
        byte[] buf = this.buffout.buf;
        int strlen = str.length();
        this.writeCIntUnsafe(strlen);
        this.buffout.ensureFree(strlen * 3);
        byte[] bytearr = this.buffout.buf;
        long count = (long)this.buffout.pos + bufoff;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c < '\u00ff') {
                this.unsafe.putByte(bytearr, count++, (byte)c);
                ++this.written;
                continue;
            }
            this.unsafe.putByte(bytearr, count++, (byte)-1);
            this.unsafe.putByte(bytearr, count++, (byte)(c >>> 8 & 0xFF));
            this.unsafe.putByte(bytearr, count++, (byte)(c >>> 0 & 0xFF));
            this.written += 3;
        }
        this.buffout.pos = (int)(count - bufoff);
    }

    public final void writeClass(Object toWrite) throws IOException {
        this.clnames.encodeClass(this, toWrite.getClass());
    }

    public static Class[] addToPredictionArray(Class[] possibleClasses, Class aClass) {
        if (possibleClasses == null) {
            return new Class[]{aClass};
        }
        for (int i = 0; i < possibleClasses.length; ++i) {
            Class possibleClass = possibleClasses[i];
            if (aClass == possibleClass) {
                return possibleClasses;
            }
            if (possibleClass != null) continue;
            possibleClasses[i] = aClass;
            return possibleClasses;
        }
        Class[] newPoss = Arrays.copyOf(possibleClasses, possibleClasses.length + 5);
        newPoss[possibleClasses.length] = aClass;
        return newPoss;
    }

    public void writeCShort(short c) throws IOException {
        if (c < 255 && c >= 0) {
            this.writeFByte(c);
        } else {
            this.writeFByte(255);
            this.writeFShort(c);
        }
    }

    public void writeCChar(char c) throws IOException {
        if (c < '\u00ff' && c >= '\u0000') {
            this.buffout.ensureFree(1);
            this.buffout.buf[this.buffout.pos++] = (byte)c;
            ++this.written;
        } else {
            this.buffout.ensureFree(3);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -1;
            buf[count++] = (byte)(c >>> 8 & 0xFF);
            buf[count++] = (byte)(c >>> 0 & 0xFF);
            this.buffout.pos += 3;
            this.written += 3;
        }
    }

    public void writeFChar(int v) throws IOException {
        this.buffout.ensureFree(2);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0 & 0xFF);
        buf[count++] = (byte)(v >>> 8 & 0xFF);
        this.buffout.pos += 2;
        this.written += 2;
    }

    public void writeFShort(int v) throws IOException {
        this.buffout.ensureFree(2);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 8 & 0xFF);
        buf[count++] = (byte)(v >>> 0 & 0xFF);
        this.buffout.pos += 2;
        this.written += 2;
    }

    public final void writeFByte(int v) throws IOException {
        this.buffout.ensureFree(1);
        this.buffout.buf[this.buffout.pos++] = (byte)v;
        ++this.written;
    }

    public final void writeFByteUnsafe(int v) throws IOException {
        this.buffout.ensureFree(1);
        byte[] buf = this.buffout.buf;
        this.unsafe.putByte(buf, (long)this.buffout.pos + bufoff, (byte)v);
        ++this.buffout.pos;
        ++this.written;
    }

    public final void writeFIntUnsafe(int v) throws IOException {
        this.buffout.ensureFree(4);
        byte[] buf = this.buffout.buf;
        this.unsafe.putInt(buf, (long)this.buffout.pos + bufoff, v);
        this.buffout.pos += 4;
        this.written += 4;
    }

    public void writeFInt(int v) throws IOException {
        if (this.unsafe != null) {
            this.writeFIntUnsafe(v);
            return;
        }
        this.buffout.ensureFree(4);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0 & 0xFF);
        buf[count++] = (byte)(v >>> 8 & 0xFF);
        buf[count++] = (byte)(v >>> 16 & 0xFF);
        buf[count++] = (byte)(v >>> 24 & 0xFF);
        this.buffout.pos += 4;
        this.written += 4;
    }

    public void writeFLongUnsafe(long v) throws IOException {
        this.buffout.ensureFree(8);
        byte[] buf = this.buffout.buf;
        this.unsafe.putLong(buf, (long)this.buffout.pos + bufoff, v);
        this.buffout.pos += 8;
        this.written += 8;
    }

    public void writeFLong(long v) throws IOException {
        if (this.unsafe != null) {
            this.writeFLongUnsafe(v);
            return;
        }
        this.buffout.ensureFree(8);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        buf[count++] = (byte)(v >>> 0 & 0xFFL);
        buf[count++] = (byte)(v >>> 8 & 0xFFL);
        buf[count++] = (byte)(v >>> 16 & 0xFFL);
        buf[count++] = (byte)(v >>> 24 & 0xFFL);
        buf[count++] = (byte)(v >>> 32);
        buf[count++] = (byte)(v >>> 40);
        buf[count++] = (byte)(v >>> 48);
        buf[count++] = (byte)(v >>> 56);
        this.buffout.pos += 8;
        this.written += 8;
    }

    public void writeFIntThin(int[] v) throws IOException {
        int length = v.length;
        for (int i = 0; i < length; ++i) {
            int anInt = v[i];
            if (anInt == 0) continue;
            this.writeCInt(i);
            this.writeCInt(anInt);
        }
        this.writeCInt(length);
    }

    public void writeIntArrCompressed(int[] v) throws IOException {
        int length = v.length;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int sizeNorm = 0;
        int sizDiff = 0;
        int sizOffs = 0;
        int sizeThin = 0;
        for (int i = 0; i < length; ++i) {
            int anInt = v[i];
            if (anInt != 0) {
                ++sizeThin;
                if (i > 128) {
                    sizeThin += 2;
                }
            }
            if (anInt < 127) {
                ++sizeNorm;
                if (anInt != 0) {
                    ++sizeThin;
                }
            } else if (anInt < Short.MAX_VALUE) {
                sizeNorm += 3;
                sizeThin += 3;
            } else {
                sizeNorm += 5;
                sizeThin += 3;
            }
            min = Math.min(anInt, min);
            max = Math.max(anInt, max);
            if (i <= 0) continue;
            int diff = Math.abs(anInt - v[i - 1]);
            if (diff < 127) {
                ++sizDiff;
                continue;
            }
            if (diff < Short.MAX_VALUE) {
                sizDiff += 3;
                continue;
            }
            sizDiff += 5;
        }
        int range = Math.abs(max - min);
        sizOffs = range < 127 ? v.length : (range < Short.MAX_VALUE ? v.length * 2 : v.length * 5);
        if (sizDiff <= sizeNorm && sizDiff <= sizeThin && sizDiff <= sizOffs) {
            this.writeFByte(0);
            this.writeDiffArr(v);
        } else if (sizeNorm <= sizDiff && sizeNorm <= sizeThin && sizeNorm <= sizOffs) {
            this.writeFByte(1);
            this.writeCIntArr(v);
        } else if (sizeThin <= sizeNorm && sizeThin <= sizDiff && sizeThin <= sizOffs) {
            this.writeFByte(2);
            this.writeFIntThin(v);
        } else if (sizOffs <= sizeNorm && sizOffs <= sizeThin && sizOffs <= sizDiff) {
            this.writeFByte(3);
            this.writeShortOffsArr(min, v);
        }
    }

    private void writeShortOffsArr(int min, int[] v) throws IOException {
        this.writeCInt(min);
        for (int i = 0; i < v.length; ++i) {
            this.writeFShort(v[i] - min);
        }
    }

    private void writeDiffArr(int[] v) throws IOException {
        this.writeCInt(v[0]);
        for (int i = 1; i < v.length; ++i) {
            this.writeCInt(v[i] - v[i - 1]);
        }
    }

    public void writePlainIntArrUnsafe(int[] v) throws IOException {
        int length = v.length;
        this.buffout.ensureFree(4 * length);
        byte[] buf = this.buffout.buf;
        int siz = (int)((long)length * intscal);
        this.unsafe.copyMemory(v, intoff, buf, (long)this.buffout.pos + bufoff, siz);
        this.buffout.pos += siz;
        this.written += siz;
    }

    public void writeFIntArr(int[] v) throws IOException {
        if (this.unsafe != null) {
            this.writePlainIntArrUnsafe(v);
            return;
        }
        int free = 4 * v.length;
        this.buffout.ensureFree(free);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = 0; i < v.length; ++i) {
            int anInt = v[i];
            buf[count++] = (byte)(anInt >>> 0 & 0xFF);
            buf[count++] = (byte)(anInt >>> 8 & 0xFF);
            buf[count++] = (byte)(anInt >>> 16 & 0xFF);
            buf[count++] = (byte)(anInt >>> 24 & 0xFF);
        }
        this.written += count - this.buffout.pos;
        this.buffout.pos = count;
    }

    public void writeCIntArr(int[] v) throws IOException {
        if (this.unsafe != null) {
            this.writeCIntArrUnsafe(v);
            return;
        }
        int free = 5 * v.length;
        this.buffout.ensureFree(free);
        byte[] buf = this.buffout.buf;
        int count = this.buffout.pos;
        for (int i = 0; i < v.length; ++i) {
            int anInt = v[i];
            if (anInt > -127 && anInt <= 127) {
                this.buffout.buf[count++] = (byte)anInt;
                ++this.written;
                continue;
            }
            if (anInt >= Short.MIN_VALUE && anInt <= Short.MAX_VALUE) {
                buf[count++] = -128;
                buf[count++] = (byte)(anInt >>> 8 & 0xFF);
                buf[count++] = (byte)(anInt >>> 0 & 0xFF);
                this.written += 3;
                continue;
            }
            buf[count++] = -127;
            buf[count++] = (byte)(anInt >>> 24 & 0xFF);
            buf[count++] = (byte)(anInt >>> 16 & 0xFF);
            buf[count++] = (byte)(anInt >>> 8 & 0xFF);
            buf[count++] = (byte)(anInt >>> 0 & 0xFF);
            this.written += 5;
        }
        this.buffout.pos = count;
    }

    public void writeCIntArrUnsafe(int[] v) throws IOException {
        int i;
        int free = 5 * v.length;
        this.buffout.ensureFree(free);
        byte[] buf = this.buffout.buf;
        long count = (long)this.buffout.pos + bufoff;
        for (i = 0; i < v.length; ++i) {
            int anInt = v[i];
            if (anInt > -127 && anInt <= 127) {
                this.unsafe.putByte(buf, count++, (byte)anInt);
                continue;
            }
            if (anInt >= Short.MIN_VALUE && anInt <= Short.MAX_VALUE) {
                this.unsafe.putByte(buf, count++, (byte)-128);
                this.unsafe.putByte(buf, count++, (byte)(anInt >>> 8 & 0xFF));
                this.unsafe.putByte(buf, count++, (byte)(anInt >>> 0 & 0xFF));
                continue;
            }
            this.unsafe.putByte(buf, count++, (byte)-127);
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 24 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 16 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 8 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 0 & 0xFF));
        }
        i = (int)(count - bufoff);
        this.written += i - this.buffout.pos;
        this.buffout.pos = i;
    }

    public void writeCInt(int anInt) throws IOException {
        if (this.unsafe != null) {
            this.writeCIntUnsafe(anInt);
            return;
        }
        if (anInt > -127 && anInt <= 127) {
            if (this.buffout.buf.length <= this.buffout.pos + 1) {
                this.buffout.ensureFree(1);
            }
            this.buffout.buf[this.buffout.pos++] = (byte)anInt;
            ++this.written;
        } else if (anInt >= Short.MIN_VALUE && anInt <= Short.MAX_VALUE) {
            if (this.buffout.buf.length <= this.buffout.pos + 2) {
                this.buffout.ensureFree(3);
            }
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -128;
            buf[count++] = (byte)(anInt >>> 8 & 0xFF);
            buf[count++] = (byte)(anInt >>> 0 & 0xFF);
            this.buffout.pos += 3;
            this.written += 3;
        } else {
            this.buffout.ensureFree(5);
            byte[] buf = this.buffout.buf;
            int count = this.buffout.pos;
            buf[count++] = -127;
            buf[count++] = (byte)(anInt >>> 24 & 0xFF);
            buf[count++] = (byte)(anInt >>> 16 & 0xFF);
            buf[count++] = (byte)(anInt >>> 8 & 0xFF);
            buf[count++] = (byte)(anInt >>> 0 & 0xFF);
            this.buffout.pos = count;
            this.written += 5;
        }
    }

    private void writeCIntUnsafe(int anInt) throws IOException {
        this.buffout.ensureFree(5);
        byte[] buf = this.buffout.buf;
        long count = (long)this.buffout.pos + bufoff;
        if (anInt > -127 && anInt <= 127) {
            this.unsafe.putByte(buf, count, (byte)anInt);
            ++this.buffout.pos;
            ++this.written;
        } else if (anInt >= Short.MIN_VALUE && anInt <= Short.MAX_VALUE) {
            this.unsafe.putByte(buf, count++, (byte)-128);
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 8 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 0 & 0xFF));
            this.buffout.pos += 3;
            this.written += 3;
        } else {
            this.unsafe.putByte(buf, count++, (byte)-127);
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 24 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 16 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 8 & 0xFF));
            this.unsafe.putByte(buf, count++, (byte)(anInt >>> 0 & 0xFF));
            this.buffout.pos += 5;
            this.written += 5;
        }
    }

    public void writeCFloat(float value) throws IOException {
        this.writeFInt(Float.floatToIntBits(value));
    }

    public void writeCFloatUnsafe(float value) throws IOException {
        this.writeFIntUnsafe(Float.floatToIntBits(value));
    }

    public void writeFFloat(float value) throws IOException {
        this.writeFInt(Float.floatToIntBits(value));
    }

    public void writeCDouble(double value) throws IOException {
        this.writeFLong(Double.doubleToLongBits(value));
    }

    public void writeCDoubleUnsafe(double value) throws IOException {
        this.writeFLongUnsafe(Double.doubleToLongBits(value));
    }

    public void writeFDouble(double value) throws IOException {
        this.writeFLong(Double.doubleToLongBits(value));
    }

    public void writeFDoubleUnsafe(double value) throws IOException {
        this.buffout.ensureFree(8);
        byte[] buf = this.buffout.buf;
        this.unsafe.putDouble(buf, (long)this.buffout.pos + bufoff, value);
        this.buffout.pos += 8;
        this.written += 8;
    }

    public void writeCLongUnsafe(long anInt) throws IOException {
        if (anInt > -126L && anInt <= 127L) {
            this.writeFByteUnsafe((int)anInt);
        } else if (anInt >= -32768L && anInt <= 32767L) {
            this.writeFByteUnsafe(-128);
            this.writeFShort((int)anInt);
        } else if (anInt >= Integer.MIN_VALUE && anInt <= Integer.MAX_VALUE) {
            this.writeFByteUnsafe(-127);
            this.writeFIntUnsafe((int)anInt);
        } else {
            this.writeFByteUnsafe(-126);
            this.writeFLongUnsafe(anInt);
        }
    }

    public void writeCLong(long anInt) throws IOException {
        if (anInt > -126L && anInt <= 127L) {
            this.writeFByte((int)anInt);
        } else if (anInt >= -32768L && anInt <= 32767L) {
            this.writeFByte(-128);
            this.writeFShort((int)anInt);
        } else if (anInt >= Integer.MIN_VALUE && anInt <= Integer.MAX_VALUE) {
            this.writeFByte(-127);
            this.writeFInt((int)anInt);
        } else {
            this.writeFByte(-126);
            this.writeFLong(anInt);
        }
    }

    void reset() {
        this.written = 0;
        this.buffout.reset();
        this.unsafe = FSTUtil.unsafe;
    }

    void resetAndClearRefs() {
        this.reset();
        this.objects.clearForWrite();
        this.clnames.clear();
    }

    public void resetForReUse(OutputStream out) {
        this.unsafe = FSTUtil.unsafe;
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.reset();
        if (out != null) {
            this.buffout.setOutstream(out);
        } else {
            this.out = this.buffout;
        }
        this.objects.clearForWrite();
        this.clnames.clear();
    }

    public FSTClazzInfoRegistry getClassInfoRegistry() {
        return this.conf.getCLInfoRegistry();
    }

    public ObjectOutputStream getObjectOutputStream(final Class cl, final FSTClazzInfo clinfo, final FSTClazzInfo.FSTFieldInfo referencee, final Object toWrite) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(){
            ObjectOutputStream.PutField pf;
            HashMap<String, Object> fields = new HashMap();

            @Override
            public void useProtocolVersion(int version) throws IOException {
            }

            @Override
            protected void writeObjectOverride(Object obj) throws IOException {
                FSTObjectOutput.this.writeObjectInternal(obj, referencee.getPossibleClasses());
            }

            @Override
            public void writeUnshared(Object obj) throws IOException {
                this.writeObjectOverride(obj);
            }

            @Override
            public void defaultWriteObject() throws IOException {
                FSTClazzInfo newInfo = clinfo;
                Object replObj = toWrite;
                if (newInfo.getWriteReplaceMethod() != null) {
                    System.out.println("WARNING: WRITE REPLACE NOT FULLY SUPPORTED");
                    try {
                        Object replaced = newInfo.getWriteReplaceMethod().invoke(replObj, new Object[0]);
                        if (replaced != null && replaced != toWrite) {
                            replObj = replaced;
                            newInfo = FSTObjectOutput.this.getClassInfoRegistry().getCLInfo(replObj.getClass());
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IOException(e);
                    }
                }
                FSTObjectOutput.this.writeObjectFields(replObj, newInfo, newInfo.compInfo.get(cl).getFieldArray());
            }

            @Override
            public ObjectOutputStream.PutField putFields() throws IOException {
                if (this.pf == null) {
                    this.pf = new ObjectOutputStream.PutField(){

                        @Override
                        public void put(String name, boolean val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, byte val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, char val) {
                            fields.put(name, Character.valueOf(val));
                        }

                        @Override
                        public void put(String name, short val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, int val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, long val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, float val) {
                            fields.put(name, Float.valueOf(val));
                        }

                        @Override
                        public void put(String name, double val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, Object val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void write(ObjectOutput out) throws IOException {
                            throw new IOException("cannot act compatible, use a custom serializer for this class");
                        }
                    };
                }
                return this.pf;
            }

            @Override
            public void writeFields() throws IOException {
                FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = clinfo.compInfo.get(cl);
                if (fstCompatibilityInfo.isAsymmetric()) {
                    FSTObjectOutput.this.writeCompatibleObjectFields(toWrite, this.fields, fstCompatibilityInfo.getFieldArray());
                } else {
                    FSTObjectOutput.this.writeObjectInternal(this.fields, HashMap.class);
                }
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("cannot act compatible, use a custom serializer for this class");
            }

            @Override
            public void write(int val) throws IOException {
                FSTObjectOutput.this.writeFByte(val);
            }

            @Override
            public void write(byte[] buf) throws IOException {
                FSTObjectOutput.this.buffout.ensureFree(buf.length);
                FSTObjectOutput.this.write(buf);
            }

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                FSTObjectOutput.this.buffout.ensureFree(len);
                FSTObjectOutput.this.write(buf, off, len);
            }

            @Override
            public void flush() throws IOException {
                FSTObjectOutput.this.flush();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void writeBoolean(boolean val) throws IOException {
                FSTObjectOutput.this.buffout.ensureFree(1);
                FSTObjectOutput.this.writeBoolean(val);
            }

            @Override
            public void writeByte(int val) throws IOException {
                FSTObjectOutput.this.writeFByte(val);
            }

            @Override
            public void writeShort(int val) throws IOException {
                FSTObjectOutput.this.writeFShort(val);
            }

            @Override
            public void writeChar(int val) throws IOException {
                FSTObjectOutput.this.writeFChar(val);
            }

            @Override
            public void writeInt(int val) throws IOException {
                FSTObjectOutput.this.writeFInt(val);
            }

            @Override
            public void writeLong(long val) throws IOException {
                FSTObjectOutput.this.writeFLong(val);
            }

            @Override
            public void writeFloat(float val) throws IOException {
                FSTObjectOutput.this.writeCFloat(val);
            }

            @Override
            public void writeDouble(double val) throws IOException {
                FSTObjectOutput.this.writeFDouble(val);
            }

            @Override
            public void writeBytes(String str) throws IOException {
                FSTObjectOutput.this.buffout.ensureFree(str.length() * 4);
                FSTObjectOutput.this.writeBytes(str);
            }

            @Override
            public void writeChars(String str) throws IOException {
                FSTObjectOutput.this.buffout.ensureFree(str.length() * 4);
                FSTObjectOutput.this.writeChars(str);
            }

            @Override
            public void writeUTF(String str) throws IOException {
                FSTObjectOutput.this.writeStringUTF(str);
            }
        };
        return out;
    }

    public FSTObjectRegistry getObjectMap() {
        return this.objects;
    }

    public byte[] getBuffer() {
        return this.buffout.buf;
    }

    public byte[] getCopyOfWrittenBuffer() {
        byte[] res = new byte[this.written];
        byte[] buffer = this.getBuffer();
        System.arraycopy(buffer, 0, res, 0, this.written);
        return res;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public static void main(String[] arg) throws IOException {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream(5000);
        FSTObjectOutput ou = new FSTObjectOutput(out1, FSTConfiguration.createDefaultConfiguration());
        String str = "word frequencies, tend to vary. More recent analyses show that letter frequencies, like word frequencies, tend to vary, both by writer and by subject. This is a standard text sequence which might get packed. One cannot write an essay about x-rays without using frequent Xs, and the essay will have an especially strange letter frequency if the essay is about the frequent use of x-rays to treat zebras in Qatar.";
        System.out.println(str.length() + " => " + ou.writeStringCompressed(str));
        String str1 = "Kann auch mal ein deutscher Text sein, oder ?";
        System.out.println(str1.length() + " => " + ou.writeStringCompressed(str1));
        String str2 = "Imagine is a song written and performed by English musician John Lennon. The best selling single of his solo career, its lyrical statement is one of idealistic collectivism. It challenges the listener to imagine a world at peace, without the divisiveness and barriers of borders, religious denominations and nationalities, and to consider the possibility that the focus of humanity should be living a life unattached to material possessions. Lennon and Yoko Ono co-produced the song and album of the same name with Phil Spector. One month after the September 1971 release of the LP, Lennon released Imagine as a single in the United States; the song peaked at number 3 on the Billboard Hot 100 and the album became the most commercially successful and critically acclaimed of his solo career. Lennon released \"Imagine\" as a single in the United Kingdom in 1975, and the song has since sold more than 1.6 million copies in the UK. It earned a Grammy Hall of Fame Award, was inducted into the Rock and Roll Hall of Fame's 500 Songs that Shaped Rock and Roll, and Rolling Stone ranked it number 3 in their list of \"The 500 Greatest Songs of All Time\". (Full article...)";
        System.out.println(str2.length() + " => " + ou.writeStringCompressed(str2));
        String str3 = "standard default waiting state init finish end";
        System.out.println(str3.length() + " => " + ou.writeStringCompressed(str3));
        ou.close();
        FSTObjectInput inp = new FSTObjectInput(new ByteArrayInputStream(out1.toByteArray()), ou.getConf());
        String ins = inp.readStringCompressed();
        System.out.println(str.equals(ins));
        System.out.println(str1.equals(inp.readStringCompressed()));
        System.out.println(str2.equals(inp.readStringCompressed()));
        System.out.println(str3.equals(inp.readStringCompressed()));
    }

    public int getWritten() {
        return this.written;
    }

    static {
        int i;
        Unsafe unsafe = FSTUtil.getUnsafe();
        if (unsafe != null) {
            bufoff = unsafe.arrayBaseOffset(byte[].class);
            intoff = unsafe.arrayBaseOffset(int[].class);
            longoff = unsafe.arrayBaseOffset(long[].class);
            longscal = unsafe.arrayIndexScale(long[].class);
            intscal = unsafe.arrayIndexScale(int[].class);
            chscal = unsafe.arrayIndexScale(char[].class);
            choff = unsafe.arrayBaseOffset(char[].class);
        } else {
            longoff = 0L;
            longscal = 0L;
            bufoff = 0L;
            intoff = 0L;
            intscal = 0L;
            choff = 0L;
            chscal = 0L;
        }
        empty = new ByteArrayOutputStream(0);
        charMap = new int[256];
        enc = "e itsanhurdmwgvl";
        FSTObjectOutput.charMap[32] = 0;
        for (i = 0; i < charMap.length; ++i) {
            FSTObjectOutput.charMap[i] = 999;
        }
        for (i = 0; i < enc.length(); ++i) {
            FSTObjectOutput.charMap[FSTObjectOutput.enc.charAt((int)i)] = i;
        }
    }
}

