/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.util.FSTInt2ObjectMap;
import de.ruedigermoeller.serialization.util.FSTObject2IntMap;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class FSTClazzNameRegistry {
    static final boolean ENABLE_SNIPPETS = false;
    private static final boolean DEBUG_CLNAMES = false;
    FSTObject2IntMap<Class> clzToId = new FSTObject2IntMap(13, false);
    FSTInt2ObjectMap idToClz = new FSTInt2ObjectMap(13);
    int classIdCount = 3;
    int lastCatch;
    Class lastClazz;
    FSTClazzNameRegistry parent;
    HashSet<Class> visitedClasses = new HashSet(13);
    FSTObject2IntMap<String> stringSnippets = new FSTObject2IntMap(13, false);
    FSTInt2ObjectMap stringSnippetsReverse = new FSTInt2ObjectMap(13);
    int snippetCount = 3;
    private FSTConfiguration conf;
    HashMap<String, Class> classCache = new HashMap(200);
    AtomicBoolean classCacheLock = new AtomicBoolean(false);

    public FSTClazzNameRegistry(FSTClazzNameRegistry par, FSTConfiguration conf) {
        this.parent = par;
        this.conf = conf;
        if (this.parent != null) {
            this.classIdCount = this.parent.classIdCount + 1;
            this.snippetCount = this.parent.snippetCount + 1;
        }
    }

    public void clear() {
        this.lastCatch = 0;
        this.clzToId.clear();
        this.idToClz.clear();
        this.classIdCount = 3;
        if (this.visitedClasses.size() > 0) {
            this.visitedClasses.clear();
        }
        this.snippetCount = 3;
        if (this.parent != null) {
            this.classIdCount = this.parent.classIdCount + 1;
            this.snippetCount = this.parent.snippetCount + 1;
        }
    }

    public void registerClass(Class c) {
        this.registerClass(c, false);
    }

    void registerClass(Class c, boolean forRead) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(c, this.classIdCount++);
        Class[] pred = this.conf.getCLInfoRegistry().getCLInfo(c).getPredict();
        if (pred != null) {
            for (int i = 0; i < pred.length; ++i) {
                Class aClass = pred[i];
                this.registerClass(aClass);
            }
        }
    }

    public void registerClass(Class c, int code) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(c, code);
    }

    protected void addClassMapping(Class c, int id) {
        this.clzToId.put(c, id);
        this.idToClz.put(id, this.conf.getCLInfoRegistry().getCLInfo(c));
    }

    public int getIdFromClazz(Class c) {
        int res = Integer.MIN_VALUE;
        if (this.parent != null) {
            res = this.parent.getIdFromClazz(c);
        }
        if (res == Integer.MIN_VALUE) {
            res = this.clzToId.get(c);
        }
        return res;
    }

    public void encodeClass(FSTObjectOutput out, Class c) throws IOException {
        int clid = this.getIdFromClazz(c);
        if (clid != Integer.MIN_VALUE) {
            out.writeCShort((short)clid);
        } else {
            int snippet = 0;
            if (snippet == 0) {
                out.writeCShort((short)0);
                out.writeStringUTF(c.getName());
            } else {
                out.writeCShort((short)1);
                String snippetString = this.getSnippetFromId(snippet);
                out.writeCShort((short)snippet);
                String written = null;
                written = c.getName().length() == snippetString.length() ? "" : c.getName().substring(snippetString.length() + 1);
                this.addCLNameSnippets(c);
                this.addCLNameSnippets(Array.newInstance(c, 0).getClass());
                out.writeStringUTF(written);
            }
            this.registerClass(c, false);
        }
    }

    public FSTClazzInfo decodeClass(FSTObjectInput in) throws IOException, ClassNotFoundException {
        short c = in.readCShort();
        if (c == 0) {
            String clName = in.readStringUTF();
            Class cl = this.classForName(clName);
            this.registerClass(cl, true);
            this.addCLNameSnippets(cl);
            this.addCLNameSnippets(Array.newInstance(cl, 0).getClass());
            return this.conf.getCLInfoRegistry().getCLInfo(cl);
        }
        if (c == 1) {
            String snippetString;
            short snippetId = in.readCShort();
            String clName = snippetString = this.getSnippetFromId(snippetId);
            String s = in.readStringUTF();
            if (clName.length() > 0 && s.length() > 0) {
                clName = clName + "." + s;
            }
            Class cl = null;
            try {
                cl = this.classForName(clName);
            }
            catch (ClassNotFoundException ex) {
                String oldTry = clName;
                clName = snippetString;
                if (clName.length() > 0 && s.length() > 0) {
                    clName = clName + "$" + s;
                }
                try {
                    cl = this.classForName(clName);
                    if (this.parent != null) {
                        while (!this.parent.classCacheLock.compareAndSet(false, true)) {
                        }
                        this.parent.classCache.put(oldTry, cl);
                        this.parent.classCacheLock.set(false);
                    }
                    this.classCache.put(oldTry, cl);
                }
                catch (ClassNotFoundException ex1) {
                    throw ex;
                }
            }
            this.registerClass(cl, true);
            this.addCLNameSnippets(cl);
            this.addCLNameSnippets(Array.newInstance(cl, 0).getClass());
            return this.conf.getCLInfoRegistry().getCLInfo(cl);
        }
        FSTClazzInfo aClass = this.getClazzFromId(c);
        if (aClass == null) {
            throw new RuntimeException("unable to decode class from code " + c);
        }
        return aClass;
    }

    private Class classForName(String clName) throws ClassNotFoundException {
        if (this.parent != null) {
            return this.parent.classForName(clName);
        }
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        Class res = this.classCache.get(clName);
        if (res == null) {
            try {
                res = Class.forName(clName, false, this.conf.getClassLoader());
            }
            catch (Throwable th) {
                if (clName.endsWith("_Struct")) {
                    try {
                        clName = clName.substring(0, clName.length() - "_Struct".length());
                        Class<?> onHeapStructClz = Class.forName(clName);
                        res = FSTStructFactory.getInstance().getProxyClass(onHeapStructClz);
                    }
                    catch (Throwable th1) {
                        throw new RuntimeException(th1);
                    }
                }
                System.out.println("CLASSNAME:" + clName);
                throw new RuntimeException(th);
            }
            if (res != null) {
                this.classCache.put(clName, res);
            }
        }
        this.classCacheLock.set(false);
        return res;
    }

    public void registerClazzFromOtherLoader(Class cl) {
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        this.classCache.put(cl.getName(), cl);
        this.classCacheLock.set(false);
    }

    private String getSnippetFromId(int snippetId) {
        String res = null;
        if (this.parent != null) {
            res = this.parent.getSnippetFromId(snippetId);
        }
        if (res == null) {
            return (String)this.stringSnippetsReverse.get(snippetId);
        }
        return res;
    }

    public FSTClazzInfo getClazzFromId(int c) {
        FSTClazzInfo res = null;
        if (this.parent != null) {
            res = this.parent.getClazzFromId(c);
        }
        if (res == null) {
            return (FSTClazzInfo)this.idToClz.get(c);
        }
        return res;
    }

    private int getStringId(String name) {
        return this.addSingleSnippet(name);
    }

    void addCLNameSnippets(Class cl) {
        if (!this.visitedClasses.contains(cl)) {
            // empty if block
        }
    }

    int findLongestSnippet(Class c) {
        String pack = c.getName();
        int idx = 1;
        int id = 0;
        while (idx > 0 && (id = this.getStringSnippet(pack)) == Integer.MIN_VALUE) {
            idx = pack.lastIndexOf(36);
            if (idx < 0) {
                idx = pack.lastIndexOf(46);
            }
            if (idx <= 0) continue;
            pack = pack.substring(0, idx);
        }
        if (id == Integer.MIN_VALUE) {
            return 0;
        }
        return id;
    }

    private int getStringSnippet(String pack) {
        int res = Integer.MIN_VALUE;
        if (this.parent != null) {
            res = this.parent.getStringSnippet(pack);
        }
        if (res == Integer.MIN_VALUE) {
            return this.stringSnippets.get(pack);
        }
        return res;
    }

    int addSingleSnippet(String pack) {
        int integer = this.getStringSnippet(pack);
        if (integer != Integer.MIN_VALUE) {
            return integer;
        }
        this.stringSnippets.put(pack, this.snippetCount);
        this.stringSnippetsReverse.put(this.snippetCount, pack);
        ++this.snippetCount;
        return this.snippetCount - 1;
    }
}

