/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import org.nustaq.fastcast.config.PhysicalTransportConf;
import org.nustaq.fastcast.transport.PhysicalTransport;
import org.nustaq.fastcast.util.FCLog;

public class MulticastChannelPhysicalTransport
implements PhysicalTransport {
    boolean blocking;
    DatagramChannel receiveSocket;
    DatagramChannel sendSocket;
    PhysicalTransportConf conf;
    NetworkInterface iface;
    InetAddress address;
    InetSocketAddress socketAddress;

    public MulticastChannelPhysicalTransport(PhysicalTransportConf conf, boolean blocking) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.conf = conf;
        this.blocking = blocking;
    }

    @Override
    public boolean receive(DatagramPacket pack) throws IOException {
        SocketAddress receive = this.receiveSocket.receive(ByteBuffer.wrap(pack.getData(), pack.getOffset(), pack.getLength()));
        if (receive instanceof InetSocketAddress) {
            pack.setAddress(((InetSocketAddress)receive).getAddress());
        }
        return receive != null;
    }

    @Override
    public boolean receive(ByteBuffer pack) throws IOException {
        SocketAddress receive = this.receiveSocket.receive(pack);
        return receive != null;
    }

    @Override
    public void send(DatagramPacket pack) throws IOException {
        this.sendSocket.send(ByteBuffer.wrap(pack.getData(), pack.getOffset(), pack.getLength()), this.socketAddress);
    }

    @Override
    public void send(byte[] bytes, int off, int len) throws IOException {
        this.sendSocket.send(ByteBuffer.wrap(bytes, off, len), this.socketAddress);
    }

    @Override
    public void send(ByteBuffer b) throws IOException {
        this.sendSocket.send(b, this.socketAddress);
    }

    public InetSocketAddress getAddress() {
        return this.socketAddress;
    }

    public NetworkInterface getInterface() {
        return this.iface;
    }

    @Override
    public void join() throws IOException {
        if (this.address == null) {
            this.address = InetAddress.getByName(this.conf.getMulticastAddr());
        }
        this.socketAddress = new InetSocketAddress(this.address, this.conf.getPort());
        if (this.iface == null && this.conf.getInterfaceAddr() != null) {
            this.iface = NetworkInterface.getByInetAddress(Inet4Address.getByName(this.conf.getInterfaceAddr()));
            if (this.iface == null) {
                this.iface = NetworkInterface.getByInetAddress(Inet4Address.getByName(this.conf.getInterfaceAddr()));
            }
            if (this.iface == null) {
                FCLog.log("Could not find a network interface named '" + this.conf.getInterfaceAddr() + "'");
            }
        }
        this.receiveSocket = this.ceateSocket(this.blocking);
        this.sendSocket = this.ceateSocket(true);
        MembershipKey key = this.receiveSocket.join(this.address, this.iface);
        FCLog.log("Connecting to interface " + this.iface.getName() + " on address " + this.address + " " + this.conf.getPort() + " dgramsize:" + this.getConf().getDgramsize());
    }

    private DatagramChannel ceateSocket(boolean block) throws IOException {
        DatagramChannel channel = ((DatagramChannel)((DatagramChannel)((DatagramChannel)((DatagramChannel)((DatagramChannel)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.iface)).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.conf.getSocketReceiveBufferSize())).setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)this.conf.getTrafficClass())).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)this.conf.isLoopBack())).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.conf.getTtl())).bind(new InetSocketAddress(this.conf.getPort()));
        channel.configureBlocking(block);
        return channel;
    }

    @Override
    public PhysicalTransportConf getConf() {
        return this.conf;
    }

    @Override
    public void close() {
        try {
            if (this.receiveSocket != null) {
                this.receiveSocket.close();
            }
            this.receiveSocket = null;
        }
        catch (IOException e) {
            FCLog.get().warn(e);
        }
        try {
            if (this.sendSocket != null) {
                this.sendSocket.close();
            }
            this.sendSocket = null;
        }
        catch (IOException e) {
            FCLog.get().warn(e);
        }
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }
}

