/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.impl;

import org.nustaq.fastcast.api.FCSubscriber;
import org.nustaq.fastcast.impl.DataPacket;
import org.nustaq.fastcast.impl.Defragmenter;
import org.nustaq.fastcast.impl.PacketSendBuffer;
import org.nustaq.fastcast.impl.RetransPacket;
import org.nustaq.fastcast.impl.Topic;
import org.nustaq.fastcast.util.FCLog;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.BytezAllocator;
import org.nustaq.offheap.bytez.malloc.MallocBytezAllocator;
import org.nustaq.offheap.structs.FSTStruct;
import org.nustaq.offheap.structs.FSTStructAllocator;
import org.nustaq.offheap.structs.structtypes.StructArray;
import org.nustaq.offheap.structs.structtypes.StructString;

public class PacketReceiveBuffer {
    public static final int MAX_NON_GAP_PACKET_SERIES_TO_JUSTIFY_NEW_RETRANS_ENTRY = 20;
    final int topic;
    final int payMaxLen;
    final FSTStructAllocator packetAllocator;
    final StructArray<DataPacket> readBuffer;
    long maxOrderedSeq = 0L;
    long highestSeq = 0L;
    String receivesFrom;
    final StructString nodeId;
    FCSubscriber receiver;
    RetransPacket retrans;
    Defragmenter decoder = new Defragmenter(){

        @Override
        public void msgDone(long seq, Bytez b, int off, int len) {
            if (len != 1 || b.get((long)off) != 1) {
                PacketReceiveBuffer.this.receiver.messageReceived(PacketReceiveBuffer.this.receivesFrom, seq, b, off, len);
            }
        }
    };
    private boolean isUnordered = false;
    private boolean isUnreliable = false;
    private volatile boolean terminated = false;
    int dGramSize;
    RetransPacket retransTemplate;
    DataPacket template;
    volatile long lastHBMillis;
    int retransCount = 0;
    long firstGapDetected = 0L;
    long maxDelayNextRetrans = 15L;
    long maxDelayRetrans = 0L;
    boolean inInitialSync = true;
    Topic topicEntry;
    long startTime = 0L;
    long logBremse;
    FSTStruct currentPacketBytePointer = new FSTStruct();
    long debugPrevSeq = 0L;
    long lastPacket = 0L;
    FSTStruct tmpStruct = new FSTStruct();
    DataPacket tmpPacket;

    public PacketReceiveBuffer(int dataGramSizeBytes, String theNodeId, int historySize, String receivesFrom, Topic entry, FCSubscriber receiver) {
        this.topicEntry = entry;
        this.dGramSize = dataGramSizeBytes;
        this.topic = entry.getTopicId();
        this.receiver = receiver;
        this.template = DataPacket.getTemplate(dataGramSizeBytes);
        this.payMaxLen = this.template.data.length;
        this.template.getSender().setString(theNodeId);
        this.template.setTopic(this.topic);
        this.retransTemplate = new RetransPacket();
        this.retransTemplate.getSender().setString(theNodeId);
        this.retransTemplate.getReceiver().setString(receivesFrom);
        this.retransTemplate.setTopic(this.topic);
        this.retransTemplate.setSeqNo(-1L);
        this.packetAllocator = new FSTStructAllocator(10, (BytezAllocator)new MallocBytezAllocator());
        this.readBuffer = this.packetAllocator.newArray(historySize, (FSTStruct)this.template);
        this.nodeId = (StructString)this.packetAllocator.newStruct((FSTStruct)new StructString(10));
        this.nodeId.setString(theNodeId);
        if (this.readBuffer.getByteSize() > 0x500000) {
            FCLog.log("allocating read buffer for topic '" + this.topicEntry.getTopicId() + "' of " + this.readBuffer.getByteSize() / 1024 / 1024 + " MByte");
        } else {
            FCLog.log("allocating read buffer for topic '" + this.topicEntry.getTopicId() + "' of " + this.readBuffer.getByteSize() / 1024 + " KByte");
        }
        this.retrans = (RetransPacket)this.packetAllocator.newStruct((FSTStruct)this.retransTemplate);
        if (this.dGramSize < this.retrans.getByteSize() + 10) {
            throw new RuntimeException("datagram size must not be smaller than " + this.retrans.getByteSize() + 10);
        }
        this.receivesFrom = receivesFrom;
        this.isUnordered = this.topicEntry.isUnordered();
        this.isUnreliable = this.topicEntry.isUnreliable();
        this.maxDelayRetrans = this.topicEntry.getSubscriberConf().getMaxDelayRetransMS();
        this.maxDelayNextRetrans = this.topicEntry.getSubscriberConf().getMaxDelayNextRetransMS();
    }

    public Topic getTopicEntry() {
        return this.topicEntry;
    }

    DataPacket getPacket(long seqNo) {
        return (DataPacket)this.readBuffer.get((int)(seqNo % (long)this.readBuffer.size()));
    }

    public long getMaxDelayNextRetrans() {
        return this.maxDelayNextRetrans;
    }

    public void setMaxDelayNextRetrans(long maxDelayNextRetrans) {
        this.maxDelayNextRetrans = maxDelayNextRetrans;
    }

    public long getMaxDelayRetrans() {
        return this.maxDelayRetrans;
    }

    public void setMaxDelayRetrans(long maxDelayRetrans) {
        this.maxDelayRetrans = maxDelayRetrans;
    }

    public RetransPacket receivePacket(DataPacket packet) {
        if (this.terminated) {
            return null;
        }
        this.updateHeartBeat(System.currentTimeMillis());
        if (this.maxOrderedSeq == 0L && this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.isUnreliable) {
            this.receivePacketUnreliable(packet);
            return null;
        }
        if (this.isUnordered) {
            RetransPacket retransPacket = this.receivePacketUnOrdered(packet);
            return retransPacket;
        }
        RetransPacket retransPacket = this.receivePacketOrdered(packet);
        return retransPacket;
    }

    public void receivePacketUnreliable(DataPacket packet) {
        DataPacket previousPacket;
        long seqNo = packet.getSeqNo();
        int index = (int)(seqNo % (long)this.readBuffer.size());
        this.highestSeq = Math.max(seqNo, this.highestSeq);
        if (this.maxOrderedSeq == 0L) {
            this.handleInitialSync(seqNo);
        }
        if (!(previousPacket = this.getPacket(seqNo)).isDecoded() && previousPacket.getSeqNo() > 0L) {
            return;
        }
        this.readBuffer.set(index, (FSTStruct)packet);
        DataPacket toDecode = (DataPacket)this.readBuffer.get(index);
        this.decodePacket(toDecode);
    }

    private boolean isForeignPacket(DataPacket toDecode) {
        StructString rec = toDecode.getReceiver();
        return rec != null && rec.getLen() > 0 && !this.nodeId.equals((Object)rec);
    }

    public RetransPacket receivePacketUnOrdered(DataPacket packet) {
        DataPacket previousPacket;
        RetransPacket toReturn = null;
        long seqNo = packet.getSeqNo();
        int index = (int)(seqNo % (long)this.readBuffer.size());
        this.highestSeq = Math.max(seqNo, this.highestSeq);
        long now = System.currentTimeMillis();
        if (seqNo != this.maxOrderedSeq + 1L && this.firstGapDetected > 0L && now - this.firstGapDetected > this.maxDelayRetrans) {
            toReturn = this.computeRetransPacket(now);
        }
        if (this.maxOrderedSeq == 0L) {
            this.handleInitialSync(seqNo);
        }
        if (!(previousPacket = this.getPacket(seqNo)).isDecoded() && previousPacket.getSeqNo() > 0L) {
            return toReturn;
        }
        if (seqNo == this.maxOrderedSeq + 1L) {
            this.readBuffer.set(index, (FSTStruct)packet);
            this.maxOrderedSeq = seqNo;
            DataPacket toDecode = (DataPacket)this.readBuffer.get(index);
            this.decodePacket(toDecode);
            if (!this.inSync()) {
                DataPacket pack = this.getPacket(seqNo + 1L);
                while (pack.getSeqNo() == seqNo + 1L) {
                    if (!pack.isDecoded()) {
                        this.decodePacket(pack);
                    }
                    this.maxOrderedSeq = ++seqNo;
                    pack = this.getPacket(seqNo + 1L);
                }
                this.highestSeq = Math.max(this.maxOrderedSeq, this.highestSeq);
                if (this.inSync()) {
                    if (PacketSendBuffer.RETRANSDEBUG) {
                        FCLog.get().net("**************** in sync");
                    }
                    this.firstGapDetected = 0L;
                    this.retransCount = 0;
                    return toReturn;
                }
                return toReturn;
            }
            return toReturn;
        }
        if (this.firstGapDetected == 0L) {
            this.firstGapDetected = now;
        }
        if (((DataPacket)this.readBuffer.get(index)).isDecoded()) {
            this.readBuffer.set(index, (FSTStruct)packet);
            this.decodePacket((DataPacket)this.readBuffer.get(index));
        }
        return toReturn;
    }

    public RetransPacket receivePacketOrdered(DataPacket packet) {
        long now;
        if (this.retransCount > 1 && PacketSendBuffer.RETRANSDEBUG && (now = System.currentTimeMillis()) - this.logBremse > 1000L) {
            FCLog.get().warn("wait for retrans, received " + packet.getSeqNo() + " " + this.getTopicEntry().getSubscriberConf().getTopicId() + " waiting for " + (this.maxOrderedSeq + 1L));
            if (packet.getSeqNo() < this.maxOrderedSeq) {
                FCLog.get().warn("   sent by " + packet.getSender());
            }
            this.logBremse = now;
        }
        RetransPacket toReturn = null;
        long seqNo = packet.getSeqNo();
        int index = (int)(seqNo % (long)this.readBuffer.size());
        this.highestSeq = Math.max(seqNo, this.highestSeq);
        long now2 = System.currentTimeMillis();
        if (seqNo <= this.maxOrderedSeq) {
            return null;
        }
        if (this.maxOrderedSeq == 0L) {
            this.handleInitialSync(seqNo);
        }
        if (seqNo == this.maxOrderedSeq + 1L) {
            this.readBuffer.set(index, (FSTStruct)packet);
            this.maxOrderedSeq = seqNo;
            DataPacket toDecode = (DataPacket)this.readBuffer.get(index);
            this.decodePacket(toDecode);
            this.retransCount = 0;
            if (!this.inSync()) {
                boolean onePack = true;
                while (onePack) {
                    onePack = false;
                    DataPacket pack = this.getPacket(seqNo + 1L);
                    while (pack.getSeqNo() == seqNo + 1L) {
                        this.decodePacket(pack);
                        this.maxOrderedSeq = ++seqNo;
                        pack = this.getPacket(seqNo + 1L);
                        onePack = true;
                    }
                }
                this.highestSeq = Math.max(this.maxOrderedSeq, this.highestSeq);
                if (this.inSync()) {
                    if (PacketSendBuffer.RETRANSDEBUG) {
                        FCLog.get().net("**************** in sync");
                    }
                    this.firstGapDetected = 0L;
                    return null;
                }
                if (toReturn != null) {
                    // empty if block
                }
                return toReturn;
            }
            return null;
        }
        if (this.firstGapDetected == 0L) {
            this.firstGapDetected = now2;
            toReturn = this.computeRetransPacket(now2);
        } else if (this.firstGapDetected < now2) {
            toReturn = this.computeRetransPacket(now2);
        }
        this.readBuffer.set(index, (FSTStruct)packet);
        return toReturn;
    }

    private void handleInitialSync(long seqNo) {
        this.maxOrderedSeq = seqNo - 1L;
        this.inInitialSync = true;
        FCLog.get().info("for sender " + this.receivesFrom + " bootstrap sequence " + this.getTopicEntry().getSubscriberConf().getTopicId() + " no " + seqNo);
        FCSubscriber subscriber = this.getTopicEntry().getSubscriber();
        if (subscriber != null) {
            subscriber.senderBootstrapped(this.receivesFrom, seqNo);
        }
    }

    private RetransPacket computeRetransPacket(long now) {
        RetransPacket toReturn = (RetransPacket)this.retrans.createCopy();
        toReturn.clear();
        long curSeq = this.maxOrderedSeq + 1L;
        boolean anotherGapNearCurrentGap = false;
        while (curSeq < this.highestSeq && !toReturn.isFull()) {
            if (this.getPacket(curSeq).getSeqNo() != curSeq) {
                if (!anotherGapNearCurrentGap) {
                    toReturn.current().setFrom(curSeq);
                }
                ++curSeq;
                while (curSeq < this.highestSeq && !toReturn.isFull() && this.getPacket(curSeq).getSeqNo() != curSeq) {
                    ++curSeq;
                }
                anotherGapNearCurrentGap = false;
                if (anotherGapNearCurrentGap) continue;
                toReturn.current().setTo(curSeq);
                toReturn.nextEntry();
                continue;
            }
            ++curSeq;
        }
        ++this.retransCount;
        if (this.retransCount > 10) {
            FCLog.get().warn("retransmission retrial at " + this.maxOrderedSeq + " count " + this.retransCount + " highest " + this.highestSeq + " stream " + this.getTopicEntry().getSubscriberConf().getTopicId() + " retrans:" + (Object)((Object)toReturn));
        }
        this.firstGapDetected = this.maxDelayNextRetrans + now;
        return toReturn;
    }

    private boolean isUnordered() {
        return this.isUnordered;
    }

    public boolean inSync() {
        return this.highestSeq == this.maxOrderedSeq;
    }

    void decodePacket(DataPacket packet) {
        if (this.receiver == null) {
            return;
        }
        if (this.isForeignPacket(packet)) {
            return;
        }
        long packetSeqNo = packet.getSeqNo();
        if (this.tmpPacket == null) {
            this.tmpPacket = (DataPacket)FSTStructAllocator.newPointer(DataPacket.class);
        }
        packet.dataPointer(this.tmpStruct);
        Bytez dataPacketBase = this.tmpStruct.getBase();
        int dataindex = (int)this.tmpStruct.getOffset();
        int packIndex = (int)packet.getOffset();
        this.decodeMsgBytes(packetSeqNo, dataPacketBase, dataindex, packIndex);
    }

    private void decodeMsgBytes(long packetSeqNo, Bytez dataPacketBase, int dataindex, int packIndex) {
        this.debugPrevSeq = packetSeqNo;
        this.currentPacketBytePointer.baseOn(dataPacketBase, dataindex);
        while (true) {
            short code;
            if ((code = this.currentPacketBytePointer.getShort()) > 3 || code < 0) {
                FCLog.get().warn("foreign traffic or error, maxOrdered " + this.maxOrderedSeq + " packseq " + packetSeqNo + " highest " + this.highestSeq);
                System.exit(1);
            }
            this.currentPacketBytePointer.next(2);
            if (code == 3) {
                if (this.isUnordered() || this.isUnreliable()) {
                    this.tmpPacket.baseOn(dataPacketBase, packIndex);
                    this.tmpPacket.setDecoded(true);
                }
                return;
            }
            short len = this.currentPacketBytePointer.getShort();
            this.currentPacketBytePointer.next(2);
            if (this.inInitialSync) {
                if (code == 1) {
                    this.inInitialSync = false;
                }
            } else {
                this.decoder.receiveChunk(packetSeqNo, this.currentPacketBytePointer.getBase(), (int)this.currentPacketBytePointer.getOffset(), len, code == 1);
            }
            this.currentPacketBytePointer.next((int)len);
        }
    }

    public void setUnreliable(boolean unreliable) {
        this.isUnreliable = unreliable;
    }

    public boolean isUnreliable() {
        return this.isUnreliable;
    }

    public void terminate() {
        this.terminated = true;
        this.freeImmediate();
    }

    private void freeImmediate() {
        long alloced = MallocBytezAllocator.alloced.get();
        this.packetAllocator.free();
        long curr = MallocBytezAllocator.alloced.get();
        FCLog.log("freed " + (alloced - curr) / 1024L / 1024L + "MB to " + curr / 1024L / 1024L + " MB");
    }

    public void resync() {
        this.maxOrderedSeq = 0L;
        this.startTime = 0L;
        this.retransCount = 0;
        this.firstGapDetected = 0L;
        this.debugPrevSeq = 0L;
        this.inInitialSync = true;
    }

    public void updateHeartBeat(long l) {
        this.lastHBMillis = l;
    }

    public long getLastHBMillis() {
        return this.lastHBMillis;
    }

    public String getReceivesFrom() {
        return this.receivesFrom;
    }
}

