/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.impl;

import org.nustaq.fastcast.util.RateMeasure;

public class BatchingController {
    public static final int SIZE_OBSERVATION_WINDOW_TICKS = 4;
    public static final int RATE_PRECISION = 20;
    static volatile long MinResolution = 0L;
    long lastCheckTS;
    int packetCounter;
    long nanosPerTick;
    long ticksPerSec;
    int packetsPerTick;
    int ratePerSecond;

    public BatchingController(int ratePerSecond) {
        this.ratePerSecond = ratePerSecond;
        if (MinResolution == 0L) {
            this.calibrate();
        }
        this.nanosPerTick = MinResolution;
        do {
            this.ticksPerSec = 1000000000L / this.nanosPerTick;
            this.packetsPerTick = (int)((long)ratePerSecond / this.ticksPerSec);
            if (this.packetsPerTick >= 20) continue;
            this.nanosPerTick *= 2L;
        } while (this.packetsPerTick < 20);
    }

    public int getRatePerSecond() {
        return this.ratePerSecond;
    }

    public String toString() {
        return "BatchingController{nanosPerTick=" + this.nanosPerTick + ", ticksPerSec=" + this.ticksPerSec + ", packetsPerTick=" + this.packetsPerTick + ", actualRate=" + (long)this.packetsPerTick * this.ticksPerSec + '}';
    }

    private void calibrate() {
        long sum = 0L;
        for (int n = 0; n < 100; ++n) {
            long nanos = System.nanoTime();
            while (System.nanoTime() == nanos) {
            }
            long diff = System.nanoTime() - nanos;
            sum += diff;
        }
        MinResolution = Math.max(1L, sum / 100L);
        System.out.println("timer resolution:" + MinResolution + " ns");
    }

    public int getElapsedTicks() {
        long now = System.nanoTime();
        if (this.lastCheckTS == 0L) {
            this.lastCheckTS = now;
            return 0;
        }
        if (now - this.lastCheckTS > 4L * this.nanosPerTick) {
            long elapsedTicks = (now - this.lastCheckTS) / this.nanosPerTick;
            this.lastCheckTS += this.nanosPerTick;
            this.packetCounter -= this.packetsPerTick;
            return 0;
        }
        return (int)((now - this.lastCheckTS) / this.nanosPerTick);
    }

    public int getAllowedPackets() {
        return this.getElapsedTicks() * this.packetsPerTick + 1;
    }

    public void countPacket() {
        ++this.packetCounter;
    }

    public Action getAction() {
        int allowedPackets = this.getAllowedPackets();
        if (this.packetCounter < allowedPackets) {
            return Action.NONE;
        }
        if (this.packetCounter < allowedPackets + this.packetsPerTick * 2) {
            return Action.BATCH;
        }
        return Action.BLOCK;
    }

    public static void main(String[] arg) {
        BatchingController limiter = new BatchingController(10000);
        RateMeasure m = new RateMeasure("msg rate");
        RateMeasure pm = new RateMeasure("packet rate");
        int msgPerPackAssumption = 4;
        int batchCount = 0;
        while (true) {
            Action a;
            if ((a = limiter.getAction()) == Action.NONE) {
                limiter.countPacket();
                pm.count();
                m.count();
                continue;
            }
            if (a == Action.BATCH) {
                if (batchCount == msgPerPackAssumption) {
                    limiter.countPacket();
                    pm.count();
                    batchCount = 0;
                }
                ++batchCount;
                m.count();
                continue;
            }
            boolean x = false;
        }
    }

    public static enum Action {
        NONE,
        BATCH,
        BLOCK;

    }
}

