/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.config;

import java.io.File;
import org.nustaq.fastcast.config.PhysicalTransportConf;
import org.nustaq.fastcast.config.PublisherConf;
import org.nustaq.fastcast.config.SubscriberConf;
import org.nustaq.fastcast.config.TopicConf;
import org.nustaq.kson.Kson;

public class ClusterConf {
    public PhysicalTransportConf[] transports;
    public TopicConf[] topics;

    public PhysicalTransportConf[] getTransports() {
        return this.transports;
    }

    public ClusterConf transports(PhysicalTransportConf ... transports) {
        this.transports = transports;
        return this;
    }

    public TopicConf[] getTopics() {
        return this.topics;
    }

    public ClusterConf topics(TopicConf ... topics) {
        this.topics = topics;
        return this;
    }

    public TopicConf getTopic(String name) {
        for (int i = 0; i < this.topics.length; ++i) {
            TopicConf topic = this.topics[i];
            if (topic.getName() == null) {
                throw new RuntimeException("unnamed topic. Please ensure each topic has a name assigned");
            }
            if (!name.equalsIgnoreCase(topic.getName())) continue;
            topic.validateAfterRead();
            return topic;
        }
        return null;
    }

    public static ClusterConf readFrom(String filePath) throws Exception {
        return (ClusterConf)new Kson().map(new Class[]{PublisherConf.class, SubscriberConf.class, TopicConf.class, ClusterConf.class}).readObject(new File(filePath));
    }
}

