/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.api.util;

import org.nustaq.fastcast.api.util.ByteArraySubscriber;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.serialization.simpleapi.DefaultCoder;
import org.nustaq.serialization.simpleapi.FSTCoder;

public abstract class ObjectSubscriber
extends ByteArraySubscriber {
    protected FSTCoder coder;
    protected boolean decodeInReceiver = false;

    public ObjectSubscriber(boolean dedicatedThread, Class ... preregister) {
        super(dedicatedThread);
        this.coder = new DefaultCoder(true, preregister);
    }

    public ObjectSubscriber(Class ... preregister) {
        this(true, preregister);
    }

    public ObjectSubscriber(boolean dedicatedThread) {
        this(dedicatedThread, new Class[0]);
    }

    public ObjectSubscriber() {
        this(true);
    }

    public ObjectSubscriber decodeInReceiverThread(boolean b) {
        this.decodeInReceiver = b;
        return this;
    }

    @Override
    public void messageReceived(final String sender, final long sequence, Bytez b, long off, int len) {
        if (!this.decodeInReceiver && this.executor != null) {
            super.messageReceived(sender, sequence, b, off, len);
        } else {
            if (this.tmpBuf.length < len) {
                this.tmpBuf = new byte[len];
            }
            b.getArr(off, this.tmpBuf, 0, len);
            final Object objectMessage = this.coder.toObject(this.tmpBuf, 0, this.tmpBuf.length);
            if (this.executor != null) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ObjectSubscriber.this.objectReceived(sender, sequence, objectMessage);
                    }
                });
            } else {
                this.objectReceived(sender, sequence, objectMessage);
            }
        }
    }

    @Override
    public void messageReceived(String sender, long sequence, byte[] bytes, int off, int len) {
        Object msg = this.coder.toObject(bytes, off, len);
        this.objectReceived(sender, sequence, msg);
    }

    protected abstract void objectReceived(String var1, long var2, Object var4);
}

