/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.impl;

import java.util.List;
import org.nustaq.fastcast.api.FCSubscriber;
import org.nustaq.fastcast.config.PublisherConf;
import org.nustaq.fastcast.config.SubscriberConf;
import org.nustaq.fastcast.impl.PacketSendBuffer;
import org.nustaq.fastcast.impl.ReceiveBufferDispatcher;
import org.nustaq.fastcast.impl.TransportDriver;
import org.nustaq.fastcast.transport.PhysicalTransport;

public class Topic {
    PublisherConf publisherConf;
    SubscriberConf subscriberConf;
    TransportDriver channelDispatcher;
    PacketSendBuffer sender;
    private FCSubscriber subscriber;
    int topicId = -1;
    private long hbTimeoutMS = 3000L;

    public Topic(SubscriberConf subscriberConf, PublisherConf publisherConf) {
        this.subscriberConf = subscriberConf;
        this.publisherConf = publisherConf;
        if (subscriberConf != null) {
            this.hbTimeoutMS = subscriberConf.getSenderHBTimeout();
        }
    }

    public List<String> getTimedOutSenders(List<String> res, long now, long timeout) {
        ReceiveBufferDispatcher receiver = this.channelDispatcher.getReceiver(this.topicId);
        if (receiver != null) {
            receiver.getTimedOutSenders(now, timeout, res);
        }
        return res;
    }

    public SubscriberConf getSubscriberConf() {
        return this.subscriberConf;
    }

    public PhysicalTransport getTrans() {
        return this.channelDispatcher.trans;
    }

    public void setSubscriberConf(SubscriberConf subscriberConf) {
        this.subscriberConf = subscriberConf;
        if (subscriberConf != null) {
            this.hbTimeoutMS = subscriberConf.getSenderHBTimeout();
        }
    }

    public boolean isUnordered() {
        return false;
    }

    public TransportDriver getChannelDispatcher() {
        return this.channelDispatcher;
    }

    public void setChannelDispatcher(TransportDriver channelDispatcher) {
        this.channelDispatcher = channelDispatcher;
    }

    public boolean isUnreliable() {
        if (this.subscriberConf != null) {
            return this.subscriberConf.isUnreliable();
        }
        return false;
    }

    public FCSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(FCSubscriber subs) {
        this.subscriber = subs;
    }

    public void setSender(PacketSendBuffer sender) {
        this.sender = sender;
    }

    public PacketSendBuffer getSender() {
        return this.sender;
    }

    public int getTopicId() {
        if (this.topicId < 0) {
            if (this.subscriberConf != null) {
                this.topicId = this.subscriberConf.getTopicId();
            } else if (this.publisherConf != null) {
                this.topicId = this.publisherConf.getTopicId();
            }
        }
        return this.topicId;
    }

    public void setPublisherConf(PublisherConf publisherConf) {
        this.publisherConf = publisherConf;
    }

    public PublisherConf getPublisherConf() {
        return this.publisherConf;
    }

    public long getHbTimeoutMS() {
        return this.hbTimeoutMS;
    }
}

