/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.fastcast.api.FCSubscriber;
import org.nustaq.fastcast.impl.PacketReceiveBuffer;
import org.nustaq.fastcast.impl.Topic;
import org.nustaq.fastcast.util.FCLog;
import org.nustaq.offheap.structs.structtypes.StructString;

public class ReceiveBufferDispatcher {
    ConcurrentHashMap<StructString, PacketReceiveBuffer> bufferMap = new ConcurrentHashMap();
    int packetSize;
    String nodeId;
    int historySize;
    int topic;
    FCSubscriber receiver;
    Topic topicEntry;

    public ReceiveBufferDispatcher(int packetSize, String nodeId, Topic entry, FCSubscriber rec) {
        this.receiver = rec;
        this.packetSize = packetSize;
        this.nodeId = nodeId;
        this.historySize = entry.getSubscriberConf().getReceiveBufferPackets();
        this.topic = entry.getTopicId();
        this.topicEntry = entry;
    }

    public Topic getTopicEntry() {
        return this.topicEntry;
    }

    public PacketReceiveBuffer getBuffer(StructString sender) {
        PacketReceiveBuffer receiveBuffer = this.bufferMap.get(sender);
        if (receiveBuffer == null) {
            int hSize = this.historySize;
            if ((long)hSize * (long)this.packetSize > (long)(Integer.MAX_VALUE - 2 * this.packetSize)) {
                int newHist = (Integer.MAX_VALUE - 2 * this.packetSize) / this.packetSize;
                this.topicEntry.getSubscriberConf().receiveBufferPackets(newHist);
                FCLog.get().warn("int overflow, degrading history size from " + hSize + " to " + newHist);
                this.historySize = newHist;
            }
            receiveBuffer = new PacketReceiveBuffer(this.packetSize, this.nodeId, this.historySize, sender.toString(), this.topicEntry, this.receiver);
            this.bufferMap.put((StructString)sender.createCopy(), receiveBuffer);
        }
        return receiveBuffer;
    }

    public void cleanup(String senderName) {
        StructString struct = new StructString(senderName);
        PacketReceiveBuffer packetReceiveBuffer = this.bufferMap.get(struct);
        this.bufferMap.remove(struct);
        if (packetReceiveBuffer != null) {
            packetReceiveBuffer.terminate();
            FCSubscriber subscriber = packetReceiveBuffer.getTopicEntry().getSubscriber();
            if (subscriber != null) {
                subscriber.senderTerminated(senderName);
            }
        } else {
            FCLog.get().warn("cannot find packetReceiver to terminate");
        }
    }

    public void cleanupTopic() {
        ArrayList keys = new ArrayList(this.bufferMap.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            String o = (String)keys.get(i);
            this.cleanup(o);
        }
    }

    public void getTimedOutSenders(long now, long timeout, List<String> res) {
        for (PacketReceiveBuffer next : this.bufferMap.values()) {
            if (now - next.getLastHBMillis() <= timeout) continue;
            res.add(next.getReceivesFrom());
        }
    }
}

