/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.api;

import java.io.IOException;
import java.util.HashMap;
import org.nustaq.fastcast.config.ClusterConf;
import org.nustaq.fastcast.config.PhysicalTransportConf;
import org.nustaq.fastcast.config.PublisherConf;
import org.nustaq.fastcast.config.SubscriberConf;
import org.nustaq.fastcast.config.TopicConf;
import org.nustaq.fastcast.impl.ControlPacket;
import org.nustaq.fastcast.impl.DataPacket;
import org.nustaq.fastcast.impl.Packet;
import org.nustaq.fastcast.impl.RetransEntry;
import org.nustaq.fastcast.impl.RetransPacket;
import org.nustaq.fastcast.impl.TransportDriver;
import org.nustaq.fastcast.transport.MulticastChannelPhysicalTransport;
import org.nustaq.fastcast.transport.PhysicalTransport;
import org.nustaq.fastcast.util.FCLog;
import org.nustaq.fastcast.util.FCUtils;
import org.nustaq.offheap.structs.unsafeimpl.FSTStructFactory;

public class FastCast {
    static FastCast fc;
    private ClusterConf config;
    protected HashMap<String, PhysicalTransport> transports = new HashMap();
    protected HashMap<String, TransportDriver> drivers = new HashMap();
    String nodeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastCast getFastCast() {
        Class<FastCast> clazz = FastCast.class;
        synchronized (FastCast.class) {
            if (fc != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return fc;
            }
            fc = new FastCast();
            FCLog.get().info("____ ____ ____ ___ ____ ____ ____ ___\n|--- |--| ====  |  |___ |--| ====  |  \n> v3");
            // ** MonitorExit[var0] (shouldn't be in output)
            return fc;
        }
    }

    public void setNodeId(String nodeName) {
        if (this.nodeId != null) {
            throw new RuntimeException("Node Id can only be set once per process");
        }
        this.nodeId = FCUtils.createNodeId(nodeName);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public PhysicalTransport getTransport(String name) {
        PhysicalTransport physicalTransport = this.transports.get(name);
        if (physicalTransport == null) {
            FCLog.log("could not find transport '" + name + "'. Falling back to transport 'default'");
            return this.transports.get("default");
        }
        return physicalTransport;
    }

    public TransportDriver onTransport(String transName) {
        return this.getTransportDriver(transName);
    }

    public TransportDriver getTransportDriver(String transName) {
        TransportDriver res = this.drivers.get(transName);
        if (res == null) {
            PhysicalTransport physicalTransport = this.getTransport(transName);
            res = new TransportDriver(physicalTransport, this.nodeId);
            this.drivers.put(transName, res);
        }
        return res;
    }

    public FastCast loadConfig(String filePath) throws Exception {
        this.setConfig(ClusterConf.readFrom(filePath));
        return this;
    }

    public void setConfig(ClusterConf config) {
        this.config = config;
        this.addTransportsFrom(config);
    }

    public SubscriberConf getSubscriberConf(String name) {
        TopicConf topic = this.getConfig().getTopic(name);
        if (topic != null) {
            return topic.getSub();
        }
        return null;
    }

    public PublisherConf getPublisherConf(String name) {
        TopicConf topic = this.getConfig().getTopic(name);
        if (topic != null) {
            return topic.getPublisher();
        }
        return null;
    }

    public ClusterConf getConfig() {
        return this.config;
    }

    public void addTransportsFrom(ClusterConf config) {
        PhysicalTransportConf[] trs = config.transports;
        for (int i = 0; i < trs.length; ++i) {
            PhysicalTransportConf tr = trs[i];
            this.addTransport(tr);
        }
    }

    public void addTransport(PhysicalTransportConf tconf) {
        if (this.nodeId == null) {
            throw new RuntimeException("define nodeId first");
        }
        if (this.transports.get(tconf.getName()) != null) {
            throw new ConfigurationAlreadyDefinedException("transport " + tconf.getName() + " already initialized ");
        }
        try {
            FCLog.log("Connecting transport " + tconf.getName() + " as " + this.getNodeId());
            MulticastChannelPhysicalTransport tr = new MulticastChannelPhysicalTransport(tconf, tconf.getSpinLoopMicros() == 0);
            tr.join();
            this.transports.put(tconf.getName(), tr);
        }
        catch (IOException e) {
            FCLog.log(e);
        }
    }

    static {
        FSTStructFactory.getInstance().registerSystemClz((byte)127, new Class[]{Packet.class, DataPacket.class, RetransPacket.class, RetransEntry.class, ControlPacket.class});
    }

    public static class ConfigurationAlreadyDefinedException
    extends RuntimeException {
        public ConfigurationAlreadyDefinedException(String message) {
            super(message);
        }
    }
}

