/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.util;

public class RateMeasure {
    int count;
    long lastStats;
    int checkEachMask = 127;
    long statInterval = 1000L;
    long lastRatePersecond;
    String name = "none";

    public RateMeasure(String name, long statInterval) {
        this.name = name;
        this.statInterval = statInterval;
    }

    public RateMeasure(String name) {
        this.name = name;
    }

    public void count() {
        ++this.count;
        if ((this.count & ~this.checkEachMask) == this.count) {
            this.checkStats();
        }
    }

    private void checkStats() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastStats;
        if (diff > this.statInterval) {
            this.lastRatePersecond = (long)this.count * 1000L / diff;
            this.lastStats = now;
            this.count = 0;
            this.statsUpdated(this.lastRatePersecond);
        }
    }

    protected void statsUpdated(long lastRatePersecond) {
        System.out.println("***** Stats for " + this.name + ":   " + lastRatePersecond + "   per second *********");
    }
}

