/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.util;

import java.io.PrintStream;

public class FCLog {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int SEVER = 3;
    public static final int FATAL = 4;
    static FCLog instance;
    int logLevel = 1;

    public static FCLog get() {
        if (instance == null) {
            instance = new FCLog();
        }
        return instance;
    }

    public static void setInstance(FCLog instance) {
        FCLog.instance = instance;
    }

    public static void log(String s) {
        FCLog.get().info(s);
    }

    public static void log(String s, Throwable th) {
        FCLog.get().info(s, th);
    }

    public static void log(Throwable th) {
        FCLog.get().warn(th);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    void internal_out(int level, String msg, Throwable th) {
        this.out(level, msg, th);
    }

    protected void out(int level, String msg, Throwable th) {
        if (level >= this.getLogLevel()) {
            if (msg != null) {
                System.out.println(msg);
            }
            if (th != null) {
                th.printStackTrace(new PrintStream(System.out));
            }
        }
    }

    public void info(String msg) {
        this.internal_out(1, msg, null);
    }

    public void info(String msg, Throwable e) {
        this.internal_out(1, msg, e);
    }

    public void info(Throwable e) {
        this.internal_out(1, null, e);
    }

    public void warn(String msg) {
        this.internal_out(2, msg, null);
    }

    public void warn(String msg, Throwable e) {
        this.internal_out(2, msg, e);
    }

    public void warn(Throwable e) {
        this.internal_out(2, null, e);
    }

    public void severe(String msg, Throwable e) {
        this.internal_out(3, msg, e);
    }

    public void fatal(String msg) {
        this.internal_out(4, msg, null);
    }

    public void fatal(String msg, Throwable e) {
        this.internal_out(4, msg, e);
    }

    public void debug(String msg, Throwable e) {
        this.internal_out(0, msg, e);
    }

    public void debug(Throwable e) {
        this.internal_out(0, null, e);
    }

    public void debug(String msg) {
        this.internal_out(0, msg, null);
    }

    public void net(String s) {
        this.internal_out(1, s, null);
    }
}

