/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.impl;

import org.nustaq.fastcast.impl.Packet;
import org.nustaq.fastcast.impl.RetransEntry;
import org.nustaq.offheap.structs.Templated;

public class RetransPacket
extends Packet {
    @Templated
    protected RetransEntry[] retransEntries = new RetransEntry[]{new RetransEntry(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    protected int retransIndex;

    public int retransEntriesLen() {
        return this.retransEntries.length;
    }

    public RetransEntry retransEntries(int i) {
        return this.retransEntries[i];
    }

    public RetransEntry current() {
        return this.retransEntries(this.retransIndex);
    }

    public void nextEntry() {
        ++this.retransIndex;
    }

    public int getRetransIndex() {
        return this.retransIndex;
    }

    public void setRetransIndex(int retransIndex) {
        this.retransIndex = retransIndex;
    }

    public void clear() {
        this.setRetransIndex(0);
    }

    public boolean isFull() {
        return this.getRetransIndex() >= this.retransEntriesLen() - 1;
    }

    @Override
    public String toString() {
        return "RetransPacket{seqNo=" + this.seqNo + ", topic=" + this.topic + ", sender=" + this.sender + ", receiver=" + this.receiver + ", retransEntries=" + this.entriesString() + ", retransIndex=" + this.retransIndex + '}';
    }

    protected String entriesString() {
        String res = "[";
        for (int n = 0; n < this.getRetransIndex(); ++n) {
            RetransEntry retransEntry = this.retransEntries(n);
            res = res + "[ " + retransEntry.getFrom() + "," + retransEntry.getTo() + "] ";
        }
        return res + "]";
    }

    public int computeNumPackets() {
        int res = 0;
        for (int i = 0; i < this.retransIndex; ++i) {
            res = (int)((long)res + this.retransEntries(i).getNumPackets());
        }
        return res;
    }
}

