/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.config;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.nustaq.fastcast.util.FCLog;

public class PhysicalTransportConf {
    String name;
    int dgramsize = 4000;
    String interfaceAddr = "lo";
    String multicastAddr = "229.9.9.9";
    int port = 45555;
    int trafficClass = 8;
    boolean loopBack = true;
    int ttl = 8;
    int socketReceiveBufferSize = 8000000;
    int socketSendBufferSize = 8000000;
    long autoFlushMS = 3L;
    int spinLoopMicros = 0;
    int idleParkMicros = 300;

    public PhysicalTransportConf() {
    }

    public PhysicalTransportConf(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PhysicalTransportConf setName(String name) {
        this.name = name;
        return this;
    }

    public int getDgramsize() {
        return this.dgramsize - 4;
    }

    public PhysicalTransportConf setDgramsize(int dgramsize) {
        this.dgramsize = dgramsize;
        return this;
    }

    public String getInterfaceAddr() {
        if (!Character.isDigit(this.interfaceAddr.charAt(0))) {
            Enumeration<NetworkInterface> nets = null;
            try {
                nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    if (!netint.getDisplayName().equalsIgnoreCase(this.interfaceAddr)) continue;
                    Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                    if (inetAddresses.hasMoreElements()) {
                        this.interfaceAddr = inetAddresses.nextElement().getHostAddress();
                        break;
                    }
                    FCLog.get().warn("specified interface " + this.interfaceAddr + " does not have an IP assigned");
                }
            }
            catch (SocketException e) {
                FCLog.log(e);
            }
        }
        return this.interfaceAddr;
    }

    public PhysicalTransportConf interfaceAdr(String ifacAdr) {
        this.interfaceAddr = ifacAdr;
        return this;
    }

    public String getMulticastAddr() {
        return this.multicastAddr;
    }

    public PhysicalTransportConf mulitcastAdr(String mcastAdr) {
        this.multicastAddr = mcastAdr;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public PhysicalTransportConf port(int port) {
        this.port = port;
        return this;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public PhysicalTransportConf trafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
        return this;
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public PhysicalTransportConf loopBack(boolean loopBack) {
        this.loopBack = loopBack;
        return this;
    }

    public int getTtl() {
        return this.ttl;
    }

    public PhysicalTransportConf ttl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public int getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    public PhysicalTransportConf socketReceiveBufferSize(int socketReceiveBufferSize) {
        this.socketReceiveBufferSize = socketReceiveBufferSize;
        return this;
    }

    public int getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    public PhysicalTransportConf socketSendBufferSize(int sendBufferSize) {
        this.socketSendBufferSize = sendBufferSize;
        return this;
    }

    public long getAutoFlushMS() {
        return this.autoFlushMS;
    }

    public int getIdleParkMicros() {
        return this.idleParkMicros;
    }

    public int getSpinLoopMicros() {
        return this.spinLoopMicros;
    }

    public PhysicalTransportConf autoFlushMS(long autoFlushMS) {
        this.autoFlushMS = autoFlushMS;
        return this;
    }

    public PhysicalTransportConf idleParkMicros(int idleParkMicros) {
        this.idleParkMicros = idleParkMicros;
        return this;
    }

    public PhysicalTransportConf spinLoopMicros(int spinLoopMicros) {
        this.spinLoopMicros = spinLoopMicros;
        return this;
    }
}

