/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.fastcast.api.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.nustaq.fastcast.api.FCSubscriber;
import org.nustaq.offheap.bytez.Bytez;

public abstract class ByteArraySubscriber
implements FCSubscriber {
    protected Executor executor;
    protected byte[] tmpBuf = new byte[0];

    public ByteArraySubscriber(boolean dedicatedThread) {
        if (dedicatedThread) {
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    public ByteArraySubscriber() {
        this(true);
    }

    @Override
    public void messageReceived(final String sender, final long sequence, Bytez b, long off, final int len) {
        if (this.executor != null) {
            final byte[] bytes = b.toBytes(off, len);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ByteArraySubscriber.this.messageReceived(sender, sequence, bytes, 0, len);
                }
            });
        } else {
            if (this.tmpBuf.length < len) {
                this.tmpBuf = new byte[len];
            }
            b.getArr(off, this.tmpBuf, 0, len);
            this.messageReceived(sender, sequence, this.tmpBuf, 0, len);
        }
    }

    protected abstract void messageReceived(String var1, long var2, byte[] var4, int var5, int var6);

    @Override
    public boolean dropped() {
        return true;
    }

    @Override
    public void senderTerminated(String senderNodeId) {
    }

    @Override
    public void senderBootstrapped(String receivesFrom, long seqNo) {
    }
}

