/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.util;

import de.ruedigermoeller.fastcast.util.FCLog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FCUtils {
    public static boolean NETLOG = true;
    public static boolean FAT_NODE_NAME = false;

    public static Executor createIncomingMessageThreadExecutor(final String name, int qsize) {
        ThreadPoolExecutor res = new ThreadPoolExecutor(1, 1, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(qsize));
        res.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new FCIncomingMessageThread(r, name);
            }
        });
        res.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                while (!executor.isShutdown() && !executor.getQueue().offer(r)) {
                    Thread.yield();
                }
            }
        });
        return res;
    }

    public static Executor createBoundedSingleThreadExecutor(final String name, int qsize) {
        ThreadPoolExecutor res = new ThreadPoolExecutor(1, 1, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(qsize));
        res.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, name);
            }
        });
        res.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                while (!executor.isShutdown() && !executor.getQueue().offer(r)) {
                    Thread.yield();
                }
            }
        });
        return res;
    }

    public static String createNodeId(String addendum) {
        if (FAT_NODE_NAME) {
            String host = "unknown";
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                FCLog.get().severe(null, e);
            }
            return host + "-" + addendum + "-" + (int)(Math.random() * 1000000.0);
        }
        return addendum + "-" + Integer.toHexString((int)(Math.random() * 1024000.0));
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "").indexOf("indows") > 0;
    }

    public static class FCIncomingMessageThread
    extends Thread {
        public FCIncomingMessageThread() {
        }

        public FCIncomingMessageThread(Runnable target) {
            super(target);
        }

        public FCIncomingMessageThread(String name) {
            super(name);
        }

        public FCIncomingMessageThread(Runnable target, String name) {
            super(target, name);
        }
    }
}

