/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.transport;

import de.ruedigermoeller.fastcast.transport.FCSocketConf;
import de.ruedigermoeller.fastcast.transport.Transport;
import de.ruedigermoeller.fastcast.util.FCLog;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.DatagramPacket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class SharedMemTransport
implements Transport {
    static final int QENTRY_HEADER = 8;
    MappedByteBuffer mWriteQueue;
    RandomAccessFile mRandomFile;
    FileChannel mChannel;
    int dgramSize;
    int packSiz;
    long address;
    int numPack;
    long currentReadSequence;
    private long currentWriteSequence;
    FCSocketConf conf;
    ByteBuffer mReadQueue;
    byte[] zeros;
    volatile boolean joined = false;

    public SharedMemTransport(FCSocketConf c) {
        this(c.getQueueFile(), c.getDgramsize(), c.getReceiveBufferSize());
        this.conf = c;
    }

    public SharedMemTransport(String path, int datagramsiz, int buffsiz) {
        this.dgramSize = datagramsiz;
        this.packSiz = this.dgramSize + 8;
        this.numPack = buffsiz / this.packSiz;
        try {
            this.initMemMap(path, this.packSiz * this.numPack + this.packSiz);
        }
        catch (Exception e) {
            FCLog.log(e);
        }
    }

    public long getPack(long index) {
        return this.address + index % (long)this.numPack * (long)this.packSiz;
    }

    public int getPackOff(long index) {
        return (int)(index % (long)this.numPack * (long)this.packSiz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] b, int off, int len) {
        FileLock lock = null;
        try {
            lock = this.mChannel.lock();
            long seq = 0L;
            int pos = this.getPackOff(this.currentWriteSequence);
            while ((seq = this.mWriteQueue.getLong(pos)) >= this.currentWriteSequence) {
                this.currentWriteSequence = seq != 0L ? seq + 1L : ++this.currentWriteSequence;
                pos = this.getPackOff(this.currentWriteSequence);
            }
            this.mWriteQueue.position(pos);
            this.mWriteQueue.putLong(this.currentWriteSequence);
            this.mWriteQueue.put(b, off, len);
            this.mWriteQueue.put(this.zeros, 0, this.dgramSize - len);
        }
        catch (IOException e) {
            FCLog.log(e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    FCLog.log(e);
                }
            }
        }
        ++this.currentWriteSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long findMaxSequence() {
        FileLock lock = null;
        long res = 1L;
        try {
            lock = this.mChannel.lock();
            this.positionQueue(this.mWriteQueue, 0L);
            int pos = this.mWriteQueue.position();
            for (int i = 0; i < this.numPack - 1; ++i) {
                res = Math.max(this.mWriteQueue.getLong(pos), res);
                pos += this.packSiz;
            }
        }
        catch (IOException e) {
            FCLog.log(e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    FCLog.log(e);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryRead(byte[] b, int off) {
        FileLock lock = null;
        this.positionQueue(this.mReadQueue, this.currentReadSequence);
        long seq = this.mReadQueue.getLong();
        if (seq < this.currentReadSequence) return false;
        SharedMemTransport sharedMemTransport = this;
        synchronized (sharedMemTransport) {
            try {
                lock = this.mChannel.lock();
                this.positionQueue(this.mReadQueue, this.currentReadSequence);
                seq = this.mReadQueue.getLong();
                try {
                    this.mReadQueue.get(b, off, this.dgramSize);
                }
                catch (Exception e) {
                    throw new RuntimeException("index " + this.mReadQueue.position() + " readSiz " + this.dgramSize, e);
                }
                lock.release();
                lock = null;
                this.currentReadSequence = seq + 1L;
                boolean e = true;
                return e;
            }
            catch (IOException e) {
                FCLog.get().fatal("Thread " + Thread.currentThread().getName(), e);
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException e) {
                        FCLog.log(e);
                    }
                }
            }
            return false;
        }
    }

    private void positionQueue(ByteBuffer buff, long seq) {
        buff.position((int)((long)this.packSiz * (seq % (long)this.numPack)));
    }

    protected void initMemMap(String filePath, int siz) throws IOException, NoSuchFieldException, IllegalAccessException {
        this.mRandomFile = new RandomAccessFile(filePath, "rw");
        this.mRandomFile.setLength(siz);
        this.mChannel = this.mRandomFile.getChannel();
        this.mWriteQueue = this.mChannel.map(FileChannel.MapMode.READ_WRITE, 0L, siz);
        this.mWriteQueue.load();
        this.mReadQueue = this.mWriteQueue.duplicate();
        Field f = Buffer.class.getDeclaredField("address");
        f.setAccessible(true);
        this.address = (Long)f.get(this.mWriteQueue);
        this.zeros = new byte[this.dgramSize];
    }

    @Override
    public boolean receive(DatagramPacket pack) throws IOException {
        return this.tryRead(pack.getData(), pack.getOffset());
    }

    @Override
    public void send(DatagramPacket pack) throws IOException {
        this.write(pack.getData(), pack.getOffset(), pack.getLength());
    }

    @Override
    public synchronized void join() throws IOException {
        if (this.joined) {
            return;
        }
        this.joined = true;
        this.currentReadSequence = this.currentWriteSequence = this.findMaxSequence() + 1L;
    }

    @Override
    public FCSocketConf getConf() {
        return this.conf;
    }

    public static void main(String[] arg) throws Exception {
        SharedMemTransport shmem = new SharedMemTransport("\\test\\queue.txt", 8000, 400000000);
        shmem.join();
        if (arg.length > 0) {
            byte[] read = new byte[9000];
            while (true) {
                shmem.tryRead(read, 0);
            }
        }
        byte[] write = new byte[]{1, 3, 5, 7, 9, 2, 4, 6, 8, 10};
        while (true) {
            Thread.sleep(1L);
            shmem.write(write, 0, write.length);
        }
    }
}

