/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.packeting;

import de.ruedigermoeller.fastcast.control.FlowControl;
import de.ruedigermoeller.fastcast.packeting.ControlPacket;
import de.ruedigermoeller.fastcast.packeting.DataPacket;
import de.ruedigermoeller.fastcast.packeting.RetransEntry;
import de.ruedigermoeller.fastcast.packeting.RetransPacket;
import de.ruedigermoeller.fastcast.packeting.TopicEntry;
import de.ruedigermoeller.fastcast.packeting.TopicStats;
import de.ruedigermoeller.fastcast.transport.Transport;
import de.ruedigermoeller.fastcast.util.FCLog;
import de.ruedigermoeller.fastcast.util.RateMeasure;
import de.ruedigermoeller.fastcast.util.Sleeper;
import de.ruedigermoeller.heapoff.bytez.Bytez;
import de.ruedigermoeller.heapoff.bytez.BytezAllocator;
import de.ruedigermoeller.heapoff.bytez.malloc.MallocBytezAllocator;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.FSTTypedStructAllocator;
import de.ruedigermoeller.heapoff.structs.structtypes.StructArray;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PacketSendBuffer {
    public static final int MAX_BULK_SEND_DATA = 2;
    public static final boolean RETRANSDEBUG = false;
    private static final int RETRANS_MEM = 10000;
    private static final int TAG_BUFF = 4;
    public static final int RETRANS_PACKET_PAUSE_THRESHOLD = 5;
    private static final boolean DEBUG_LAT = false;
    FSTTypedStructAllocator<DataPacket> packetAllocator;
    ArrayList<RetransPacket> retransRequests = new ArrayList();
    StructArray<DataPacket> history;
    String nodeId;
    int payMaxLen;
    volatile int currentAvail;
    int topic;
    AtomicLong currentSequence = new AtomicLong(1L);
    AtomicLong nextSendMsg = new AtomicLong(1L);
    FSTStruct currentPacketBytePointer;
    ControlPacket dropMsg;
    Sleeper sleeperSendMsg = new Sleeper();
    int sendPauseMicros = 100;
    private Lock putLock = new ReentrantLock();
    int maxSendPacketsQueued = 8;
    boolean isUnordered;
    boolean optForLatency = false;
    TopicEntry topicEntry;
    boolean useSpinLock;
    private Object sendWakeupLock = new Object[1];
    TopicStats stats;
    FlowControl control;
    long MaxRetransRepeatIntervalMS = 2L;
    int historySize;
    int maxDGramRate;
    RateMeasure rate = new RateMeasure("sendDgramRate", 100L){

        @Override
        protected void statsUpdated(long lastRatePersecond) {
            if (PacketSendBuffer.this.maxDGramRate > 0 && PacketSendBuffer.this.hasSendPressure()) {
                float percent = (float)lastRatePersecond / (float)PacketSendBuffer.this.maxDGramRate;
                PacketSendBuffer.this.sendPauseMicros = (int)(((float)PacketSendBuffer.this.sendPauseMicros * percent + (float)(1 * PacketSendBuffer.this.sendPauseMicros)) / 2.0f);
                if (PacketSendBuffer.this.sendPauseMicros < 1) {
                    PacketSendBuffer.this.sendPauseMicros = 1;
                }
                if (PacketSendBuffer.this.sendPauseMicros < 10 && (double)percent > 1.2) {
                    ++PacketSendBuffer.this.sendPauseMicros;
                }
            }
        }
    };
    long[] sentRetransSeq = new long[10000];
    long[] sentRetransTimes = new long[10000];
    int maxRetransAge = 0;
    long debugSeq = 0L;
    int suppressedRetransCount = 0;
    ThreadLocal<byte[]> msgBytes = new ThreadLocal();

    public PacketSendBuffer(int datagramSizeBytes, String clusterName, String nodeId, TopicEntry entry) {
        this.topic = entry.getTopic();
        this.topicEntry = entry;
        this.nodeId = nodeId;
        this.setOptForLatency(entry.getConf().isOptForLatency());
        this.useSpinLock = entry.getConf().useSpinlockInSendQueue();
        FCLog.log("init send buffer for topic " + entry.getName());
        DataPacket template = DataPacket.getTemplate(datagramSizeBytes);
        this.payMaxLen = template.data.length;
        template.getCluster().setString(clusterName);
        template.getSender().setString(nodeId);
        template.setTopic(this.topic);
        this.packetAllocator = new FSTTypedStructAllocator((FSTStruct)template, 10, (BytezAllocator)new MallocBytezAllocator());
        this.history = this.packetAllocator.newArray(this.topicEntry.getConf().getNumPacketHistory(), (FSTStruct)template);
        FCLog.log("allocating send buffer for topic " + this.topicEntry.getName() + " of " + this.history.getByteSize() / 1024 / 1024 + " MByte");
        this.historySize = this.history.size();
        this.dropMsg = new ControlPacket();
        this.dropMsg.getCluster().setString(clusterName);
        this.dropMsg.getSender().setString(nodeId);
        this.dropMsg.setTopic(this.topic);
        this.dropMsg.setType(ControlPacket.DROPPED);
        this.dropMsg = (ControlPacket)this.packetAllocator.newStruct((FSTStruct)this.dropMsg);
        DataPacket curP = this.getVolatile(this.currentSequence.get());
        this.currentPacketBytePointer = curP.detach();
        curP.setSeqNo(this.currentSequence.get());
        curP.dataPointer(this.currentPacketBytePointer);
        this.currentAvail = this.payMaxLen - 4;
        this.setMaxSendPacketsQueued(this.topicEntry.getConf().getMaxSendPacketQueueSize());
        this.setUnordered(this.topicEntry.isUnordered());
        this.sendPauseMicros = this.topicEntry.getConf().getSendPauseMicros();
        this.stats = this.topicEntry.getStats();
        this.control = this.topicEntry.getControl();
        this.maxDGramRate = this.topicEntry.getConf().getDGramRate();
    }

    public void free() {
        this.packetAllocator.free();
    }

    public TopicEntry getTopicEntry() {
        return this.topicEntry;
    }

    public TopicStats getStats() {
        return this.stats;
    }

    public boolean isUnordered() {
        return this.isUnordered;
    }

    public void setUnordered(boolean unordered) {
        this.isUnordered = unordered;
    }

    public int getMaxSendPacketsQueued() {
        return this.maxSendPacketsQueued;
    }

    public void setMaxSendPacketsQueued(int maxSendPacketsQueued) {
        this.maxSendPacketsQueued = maxSendPacketsQueued == 0 ? 0 : Math.max(maxSendPacketsQueued, 8);
    }

    DataPacket getVolatile(long seq) {
        return (DataPacket)this.history.get(this.getIndexFromSequence(seq));
    }

    private int getIndexFromSequence(long seq) {
        return (int)(seq % (long)this.historySize);
    }

    public boolean putMessage(int tag, Bytez b, int offset, int len, boolean tryPut) {
        if (this.maxSendPacketsQueued == 0) {
            return this.putMessageST(tag, b, offset, len, tryPut);
        }
        return this.putMessageMT(tag, b, offset, len, tryPut);
    }

    public boolean putMessageST(int tag, Bytez b, int offset, int len, boolean tryPut) {
        this.putMessageRecursive(tag, b, offset, len);
        this.fire();
        try {
            this.sendPackets(this.topicEntry.getTrans(), this.nextSendMsg.get(), this.currentSequence.get(), false, 0L);
        }
        catch (IOException e) {
            FCLog.log(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessageMT(int tag, Bytez b, int offset, int len, boolean tryPut) {
        this.putLock.lock();
        try {
            if (this.waitForSenderMT(len, tryPut)) {
                boolean bl = false;
                return bl;
            }
            this.putMessageRecursive(tag, b, offset, len);
        }
        finally {
            this.putLock.unlock();
        }
        return true;
    }

    boolean hasSendPressure() {
        return this.currentSequence.get() - this.nextSendMsg.get() > 2L;
    }

    private boolean waitForSenderMT(int len, boolean tryPut) {
        if (this.maxSendPacketsQueued == 0) {
            return false;
        }
        long nextQSeqNo = this.currentSequence.get() + 1L;
        long currentSendSeqNo = this.nextSendMsg.get();
        int packetsRequired = len / this.payMaxLen + 1;
        while (nextQSeqNo - currentSendSeqNo > (long)(this.maxSendPacketsQueued + packetsRequired) || this.retransRequests.size() > 0) {
            if (tryPut) {
                return true;
            }
            this.putLock.unlock();
            Thread.yield();
            this.putLock.lock();
            nextQSeqNo = this.currentSequence.get() + 1L;
            currentSendSeqNo = this.nextSendMsg.get();
        }
        return false;
    }

    private void putMessageRecursive(int tag, Bytez b, int offset, int len) {
        int loopCount = 0;
        while (true) {
            this.stats.msgSent();
            if (this.currentAvail > len + 4 + 2) {
                this.putInternal(tag, (short)1, b, offset, len);
                if (this.nextSendMsg.get() == this.currentSequence.get()) {
                    this.fire();
                }
                return;
            }
            if (this.isUnordered()) {
                if (len > this.payMaxLen - 4 - 2) {
                    throw new RuntimeException("unordered message size must not exceed packet size");
                }
                this.fire();
                this.putMessageRecursive(tag, b, offset, len);
                return;
            }
            int sendlen = this.currentAvail - 4 - 8;
            if (sendlen <= 8) {
                this.fire();
                continue;
            }
            this.putInternal(tag, (short)2, b, offset, sendlen);
            this.fire();
            tag = -1;
            offset += sendlen;
            len -= sendlen;
            if (++loopCount < this.maxSendPacketsQueued) continue;
            this.waitForSenderMT(len, false);
            loopCount = 0;
        }
    }

    public boolean isOptForLatency() {
        return this.optForLatency;
    }

    public boolean useSpinLock() {
        return this.useSpinLock && this.maxSendPacketsQueued > 0;
    }

    public void setOptForLatency(boolean optForLatency) {
        this.optForLatency = optForLatency;
    }

    private void putInternal(int tag, short code, Bytez b, int offset, int len) {
        int off = 0;
        if (tag >= 0) {
            off = 1;
        }
        this.currentPacketBytePointer.setShort(code);
        this.currentPacketBytePointer.next(2);
        this.currentPacketBytePointer.setShort((short)(len + off));
        this.currentPacketBytePointer.next(2);
        if (tag >= 0) {
            this.currentPacketBytePointer.setByte((byte)tag);
            this.currentPacketBytePointer.next(off);
        }
        this.currentPacketBytePointer.setBytes(b, offset, len);
        this.currentPacketBytePointer.next(len);
        this.currentAvail -= len + off + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire() {
        if (this.currentAvail == this.payMaxLen) {
            return;
        }
        this.currentPacketBytePointer.setShort((short)3);
        long curSeq = this.currentSequence.get();
        this.currentAvail -= 2;
        if (this.currentAvail < 0) {
            throw new RuntimeException("negative bytes left " + this.currentAvail);
        }
        this.getVolatile(curSeq).setBytesLeft(this.currentAvail);
        long newSeq = curSeq + 1L;
        DataPacket newPack = this.getVolatile(newSeq);
        newPack.dataPointer(this.currentPacketBytePointer);
        newPack.setSeqNo(newSeq);
        this.currentAvail = this.payMaxLen - 4;
        newPack.setSent(System.currentTimeMillis());
        this.currentSequence.incrementAndGet();
        if (!this.useSpinLock()) {
            Object object = this.sendWakeupLock;
            synchronized (object) {
                this.sendWakeupLock.notify();
            }
        }
    }

    public boolean send(Transport transport) throws IOException {
        long sendStart;
        long sendEnd;
        boolean anythingSent = false;
        if (this.retransRequests.size() > 0) {
            anythingSent = true;
            ArrayList<RetransPacket> curRetrans = this.retransRequests;
            this.retransRequests = new ArrayList();
            this.mergeRetransmissions(transport, curRetrans);
        }
        if ((sendEnd = Math.min((sendStart = this.nextSendMsg.get()) + 2L, this.currentSequence.get())) == sendStart) {
            return anythingSent;
        }
        this.sendPackets(transport, sendStart, sendEnd, false, 0L);
        return true;
    }

    void putRetransSent(long sequence, long tim) {
        int index = (int)(sequence % 10000L);
        this.sentRetransSeq[index] = sequence;
        this.sentRetransTimes[index] = tim;
    }

    long getLastRetransmitted(long sequence) {
        int index = (int)(sequence % 10000L);
        if (this.sentRetransSeq[index] == sequence) {
            return this.sentRetransTimes[index];
        }
        return 0L;
    }

    private void mergeRetransmissions(Transport transport, ArrayList<RetransPacket> curRetrans) throws IOException {
        long now = System.currentTimeMillis();
        for (int i = 0; i < curRetrans.size(); ++i) {
            RetransPacket retransPacket = curRetrans.get(i);
            if (retransPacket == null) continue;
            this.sendRetransmissionResponse(transport, retransPacket, now);
        }
    }

    private void sendRetransmissionResponse(Transport transport, RetransPacket retransPacket, long now) throws IOException {
        for (int ii = 0; ii < retransPacket.getRetransIndex(); ++ii) {
            RetransEntry en = retransPacket.retransEntries(ii);
            this.putLock.lock();
            long fromSeqNo = this.getVolatile(en.getFrom()).getSeqNo();
            if (fromSeqNo != en.getFrom()) {
                fromSeqNo = en.getFrom();
                if (this.currentSequence.get() - fromSeqNo > (long)this.maxRetransAge) {
                    this.maxRetransAge = (int)(this.currentSequence.get() - fromSeqNo);
                    FCLog.get().warn("old retransmission from " + retransPacket.getSender() + " age " + this.maxRetransAge + " requested:" + fromSeqNo + " curseq " + this.currentSequence.get() + " topic " + this.topicEntry.getConf().getName());
                }
                this.dropMsg.setReceiver(retransPacket.getSender());
                this.dropMsg.setSeqNo(en.getFrom());
                FCLog.get().warn("Sending Drop " + (Object)((Object)this.dropMsg) + " requestedSeq " + fromSeqNo + " on service " + this.getTopicEntry().getConf().getName() + " currentSeq " + this.currentSequence + " age: " + (this.currentSequence.get() - en.getFrom()));
                transport.send(new DatagramPacket(this.dropMsg.getBase().toBytes((int)this.dropMsg.getOffset(), this.dropMsg.getByteSize()), 0, this.dropMsg.getByteSize()));
            } else {
                this.sendPackets(transport, en.getFrom(), en.getTo(), true, now);
            }
            this.putLock.unlock();
        }
        int retransPacketsSummed = retransPacket.computeNumPackets();
        for (int i = 0; i < retransPacketsSummed / 4; ++i) {
            this.sleeperSendMsg.sleepMicros(this.sendPauseMicros);
        }
    }

    private void sendPackets(Transport transport, long sendStart, long sendEnd, boolean retrans, long now) throws IOException {
        for (long i = sendStart; i < sendEnd; ++i) {
            DataPacket dataPacket = this.getVolatile(i);
            if (retrans) {
                this.putRetransSent(i, now);
            } else {
                if (this.debugSeq != 0L && dataPacket.getSeqNo() != this.debugSeq + 1L) {
                    FCLog.get().fatal("FATAL error, current seq:" + this.debugSeq + " expected Seq:[" + i + "] real read:" + dataPacket.getSeqNo());
                    FCLog.get().fatal("current put seq " + this.currentSequence.get());
                    FCLog.get().fatal("current send seq " + this.nextSendMsg.get());
                    FCLog.get().fatal("current pointer and currentpackpointer " + dataPacket.___offset + " " + this.currentPacketBytePointer.___offset);
                    FCLog.get().fatal(null, new Exception("stack trace"));
                    for (int ii = 0; ii < 20; ++ii) {
                        FCLog.get().fatal("  =>" + this.getVolatile(i + (long)ii).getSeqNo());
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        FCLog.log(e);
                    }
                    System.exit(1);
                }
                this.debugSeq = dataPacket.getSeqNo();
                dataPacket.setSendPauseSender(this.sendPauseMicros);
            }
            this.sleeperSendMsg.sleepMicros(this.sendPauseMicros);
            int dGramSize = dataPacket.getDGramSize();
            try {
                byte[] b = this.msgBytes.get();
                if (b == null) {
                    b = new byte[transport.getConf().getDgramsize()];
                    this.msgBytes.set(b);
                }
                dataPacket.getBytes(b, 0, dGramSize);
                DatagramPacket pack = new DatagramPacket(b, 0, dGramSize);
                this.rate.count();
                transport.send(pack);
                if (retrans) {
                    this.stats.retransRSPSent(1, dGramSize);
                    continue;
                }
                this.stats.dataPacketSent(dGramSize);
                continue;
            }
            catch (Throwable th) {
                System.out.println("seq " + i + " start " + sendStart + " end " + sendEnd + " idx " + this.getIndexFromSequence(i) + " len " + dataPacket.getBase().length() + " off+siz " + (dataPacket.getOffset() + (long)dGramSize));
                throw new RuntimeException(th);
            }
        }
        if (!retrans) {
            this.nextSendMsg.set(sendEnd);
        }
    }

    public void addRetransmissionRequest(RetransPacket retransPacket, Transport trans) throws IOException {
        RetransPacket copy = (RetransPacket)retransPacket.createCopy();
        this.stats.retransRQReceived(copy.computeNumPackets(), copy.getSendPauseSender());
        this.retransRequests.add(copy);
    }

    public Object getSendWakeupLock() {
        return this.sendWakeupLock;
    }

    public void doFlowControl() {
        if (this.control == null) {
            // empty if block
        }
        int tmp = this.sendPauseMicros;
        if (this.control != null) {
            this.control.adjustSendPause(this.sendPauseMicros, this.stats);
            this.sendPauseMicros = Math.max(tmp, this.topicEntry.getConf().getSendPauseMicros());
            this.sendPauseMicros = Math.min(this.sendPauseMicros, 2 * this.topicEntry.getConf().getSendPauseMicros());
        }
        this.stats.setLastSendPause(this.sendPauseMicros);
        this.stats.reset();
    }
}

