/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.gui;

import de.ruedigermoeller.fastcast.gui.ClusterViewApp;
import de.ruedigermoeller.fastcast.gui.TopicChart;
import de.ruedigermoeller.fastcast.packeting.TopicStats;
import de.ruedigermoeller.fastcast.remoting.FCFutureResultHandler;
import de.ruedigermoeller.fastcast.remoting.FCSendContext;
import de.ruedigermoeller.fastcast.service.FCMembership;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTreeCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class NodesView
extends BorderPane
implements FCMembership.MemberShipListener {
    TreeView tree = new TreeView();
    TreeItem root;
    VBox charts;
    ContextMenu topicMenu;

    public void init() {
        try {
            this.tree.setCellFactory((Callback)new Callback<TreeView, TreeCell>(){

                public TreeCell call(TreeView arg0) {
                    return new TextFieldTreeCell(){

                        public void updateItem(Object s, boolean b) {
                            super.updateItem(s, b);
                            if (NodesView.this.getSelectedPath(this.getTreeItem()).size() == 2) {
                                this.setContextMenu(NodesView.this.topicMenu);
                            } else {
                                this.setContextMenu(null);
                            }
                        }
                    };
                }
            });
            this.root = new TreeItem((Object)".");
            this.tree.setRoot(this.root);
            this.tree.setShowRoot(false);
            this.root.setExpanded(true);
            this.charts = new VBox(4.0);
            ScrollPane sp = new ScrollPane();
            sp.setContent((Node)this.charts);
            SplitPane split = new SplitPane();
            split.getItems().add((Object)this.tree);
            split.getItems().add((Object)sp);
            this.setCenter((Node)split);
            split.setOrientation(Orientation.HORIZONTAL);
            split.setDividerPositions(new double[]{0.18});
            this.topicMenu = this.buildTopicPopup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createAndAddChart(final ChartType type) {
        TreeItem selectedItem = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        ArrayList<TreeItem> path = this.getSelectedPath(selectedItem);
        if (path.size() == 2) {
            final TopicChart chart = new TopicChart();
            String nodeid = path.get(1).getValue().toString();
            final String topic = (String)path.get(0).getValue();
            if (path.get(1).getValue() instanceof FCMembership.MemberNodeInfo) {
                nodeid = ((FCMembership.MemberNodeInfo)path.get(1).getValue()).getNodeId();
            }
            chart.init(type.isSend(), type.isStacked(), nodeid, type.getTitlePrefix() + nodeid + ", " + path.get(0).getValue(), "seconds ago", type.getYLabel());
            this.addChart(chart);
            final String finalNodeid = nodeid;
            new Thread("Chart Data"){

                @Override
                public void run() {
                    while (chart.isRunning()) {
                        try {
                            Thread.sleep(1000L);
                            FCSendContext.get().setReceiver(finalNodeid);
                            ClusterViewApp.App.remoteMembership.getStats(topic, new FCFutureResultHandler(){

                                public void resultReceived(Object obj, String sender) {
                                    TopicStats stats = (TopicStats)obj;
                                    if (stats.getRecordEnd() - stats.getRecordStart() < 500L) {
                                        System.out.println("skipped stats duration:" + (stats.getRecordEnd() - stats.getRecordStart()));
                                        return;
                                    }
                                    switch (type) {
                                        case SEND_RETRANS: {
                                            chart.shiftAndAddValues(stats.getPacketsSentPerSecond(), stats.getPacketsRetransSentPerSecond());
                                            break;
                                        }
                                        case SEND_MSG: {
                                            chart.shiftAndAddValues(stats.getMsgSent(), stats.getPacketsSentPerSecond());
                                            break;
                                        }
                                        case SEND_BW: {
                                            chart.shiftAndAddValues((double)stats.getBytesSentPerSecond() / 1000.0 / 1000.0, 0.0);
                                            break;
                                        }
                                        case REC_MSG: {
                                            chart.shiftAndAddValues(stats.getMsgReceived(), stats.getPacketsRecPerSecond());
                                            break;
                                        }
                                        case REC_RETRANS: {
                                            double packetsSentPerSecond = stats.getPacketsRecPerSecond();
                                            chart.shiftAndAddValues(packetsSentPerSecond, stats.getRetransReq());
                                            break;
                                        }
                                        case REC_BW: {
                                            chart.shiftAndAddValues((double)stats.getBytesRecPerSecond() / 1000.0 / 1000.0, 0.0);
                                        }
                                    }
                                    this.done();
                                }
                            });
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        }
    }

    private ArrayList<TreeItem> getSelectedPath(TreeItem selectedItem) {
        if (selectedItem == null) {
            return new ArrayList<TreeItem>();
        }
        ArrayList<TreeItem> path = new ArrayList<TreeItem>();
        if (selectedItem == null) {
            return path;
        }
        while (selectedItem != this.root) {
            path.add(selectedItem);
            selectedItem = selectedItem.getParent();
        }
        return path;
    }

    ContextMenu buildTopicPopup() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem senderChart = new MenuItem("Show Send DGram Stats");
        senderChart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NodesView.this.createAndAddChart(ChartType.SEND_RETRANS);
            }
        });
        MenuItem sendMsgChart = new MenuItem("Show Send Msg Stats");
        sendMsgChart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NodesView.this.createAndAddChart(ChartType.SEND_MSG);
            }
        });
        MenuItem sendBWChart = new MenuItem("Show Send Bandwidth Stats");
        sendBWChart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NodesView.this.createAndAddChart(ChartType.SEND_BW);
            }
        });
        MenuItem recChart = new MenuItem("Show Receive Msg Stats");
        recChart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NodesView.this.createAndAddChart(ChartType.REC_MSG);
            }
        });
        MenuItem recDGChart = new MenuItem("Show Receive DGram Stats");
        recDGChart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NodesView.this.createAndAddChart(ChartType.REC_RETRANS);
            }
        });
        MenuItem recBWChart = new MenuItem("Show Receive Bandwith Stats");
        recBWChart.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NodesView.this.createAndAddChart(ChartType.REC_BW);
            }
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{senderChart, sendMsgChart, sendBWChart, recDGChart, recChart, recBWChart});
        return contextMenu;
    }

    public void addChart(final TopicChart chart) {
        chart.setMaxHeight(200.0);
        chart.setPrefHeight(200.0);
        chart.close.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                chart.setRunning(false);
                NodesView.this.charts.getChildren().remove((Object)chart);
            }
        });
        this.charts.getChildren().add(0, (Object)chart);
    }

    public void remNodeChart(String nodeid) {
        for (int i = 0; i < this.charts.getChildren().size(); ++i) {
            TopicChart node = (TopicChart)((Object)this.charts.getChildren().get(i));
            if (!node.getNodeId().equals(nodeid)) continue;
            this.charts.getChildren().remove((Object)node);
            node.setRunning(false);
            --i;
        }
    }

    @Override
    public synchronized void nodeAdded(final String sender, Object state) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final TreeItem item = new TreeItem((Object)sender);
                NodesView.this.root.getChildren().add((Object)item);
                FCSendContext.get().setReceiver(sender);
                ClusterViewApp.App.remoteMembership.getNodeInfo(new FCFutureResultHandler(){

                    public void resultReceived(final Object obj, String sender) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                item.setValue(obj);
                                this.done();
                            }
                        });
                    }
                });
                FCSendContext.get().setReceiver(sender);
                ClusterViewApp.App.remoteMembership.getActiveTopics(new FCFutureResultHandler(){

                    public void resultReceived(final Object obj, final String sender) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TreeItem nodeItem = NodesView.this.findNodeItem(sender);
                                nodeItem.getChildren().add((Object)new TreeItem(obj));
                            }
                        });
                    }
                });
            }
        });
    }

    TreeItem findNodeItem(String id) {
        for (int i = 0; i < this.root.getChildren().size(); ++i) {
            TreeItem o = (TreeItem)this.root.getChildren().get(i);
            if (o.getValue().equals(id)) {
                return o;
            }
            if (!(o.getValue() instanceof FCMembership.MemberNodeInfo) || !((FCMembership.MemberNodeInfo)o.getValue()).getNodeId().equals(id)) continue;
            return o;
        }
        return null;
    }

    @Override
    public void nodeLost(final String nodeId) {
        Platform.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NodesView nodesView = NodesView.this;
                synchronized (nodesView) {
                    NodesView.this.tree.getSelectionModel().clearSelection();
                    NodesView.this.root.getChildren().remove((Object)NodesView.this.findNodeItem(nodeId));
                    NodesView.this.remNodeChart(nodeId);
                }
            }
        });
    }

    static enum ChartType {
        SEND_RETRANS(true, "Regular/Retransmission Dgrams sent from ", "datagrams", true),
        SEND_MSG(false, "Messages/Datagrams sent from ", "msg / dgrams", true),
        SEND_BW(false, "Traffic sent by ", "MBytes", true),
        REC_RETRANS(true, "Dgrams received vs. Retrans Req sent from ", "dgrams/req sent", false),
        REC_MSG(false, "Msg received/Dgrams received from ", "msg / dgrams", false),
        REC_BW(false, "Traffic received by ", "MBytes", false);

        boolean stacked;
        String titlePrefix;
        private String YLabel;
        boolean isSend;

        private ChartType(boolean stacked, String titlePrefix, String ya, boolean send) {
            this.stacked = stacked;
            this.titlePrefix = titlePrefix;
            this.YLabel = ya;
            this.isSend = send;
        }

        boolean isSend() {
            return this.isSend;
        }

        boolean isStacked() {
            return this.stacked;
        }

        String getTitlePrefix() {
            return this.titlePrefix;
        }

        public String getYLabel() {
            return this.YLabel;
        }

        public void setYLabel(String YLabel) {
            this.YLabel = YLabel;
        }
    }
}

