/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.gui;

import de.ruedigermoeller.fastcast.config.FCClusterConfig;
import de.ruedigermoeller.fastcast.config.FCTopicConf;
import de.ruedigermoeller.fastcast.gui.NodesView;
import de.ruedigermoeller.fastcast.remoting.FastCast;
import de.ruedigermoeller.fastcast.service.FCMembership;
import java.io.File;
import java.io.IOException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class ClusterViewApp
extends Application
implements FCMembership.MemberShipListener {
    public static ClusterViewApp App;
    FCMembership remoteMembership;
    FCMembership localMembership;
    NodesView clGui;
    static String[] sArgs;

    public void start(Stage primaryStage) throws Exception {
        App = this;
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root);
        try {
            scene.getStylesheets().addAll((Object[])new String[]{this.getClass().getResource("/css/clusterview.css").toExternalForm()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        primaryStage.setScene(scene);
        primaryStage.setTitle("FastCast Cluster View");
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                Platform.exit();
                System.exit(-1);
            }
        });
        TabPane tabPane = new TabPane();
        tabPane.setSide(Side.TOP);
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab charts = this.createNodesTab();
        tabPane.getTabs().addAll((Object[])new Tab[]{charts});
        root.setCenter(charts.getContent());
        BorderPane.setMargin((Node)charts.getContent(), (Insets)new Insets(8.0, 6.0, 4.0, 6.0));
        root.setTop(this.createTopPane());
        primaryStage.setWidth(900.0);
        primaryStage.setHeight(600.0);
        primaryStage.show();
        if (sArgs.length > 0) {
            new Thread(){

                @Override
                public void run() {
                    ClusterViewApp.this.initCluster(sArgs[0]);
                }
            }.start();
        } else {
            System.out.println("please provide a full path to cluster.yaml definition file");
            System.exit(-1);
        }
    }

    private Tab createNodesTab() {
        Tab t = new Tab();
        t.setText("Nodes");
        this.clGui = new NodesView();
        this.clGui.init();
        t.setContent((Node)this.clGui);
        return t;
    }

    private Tab createServiceTab() {
        Tab t = new Tab();
        t.setText("Discovery");
        return t;
    }

    private Node createTopPane() {
        BorderPane canv = new BorderPane();
        Label fast = new Label(".     .    .  . .FastCAST");
        fast.setStyle("    -fx-alignment: center-right;     -fx-padding: 5 10 5 10;\n    -fx-font-family: \"Verdana\";\n    -fx-stroke: black;    -fx-stroke-width: 1;    -fx-font-size: 20px;\n    -fx-font-weight: bold;\n    -fx-text-fill: white;\n    -fx-background-insets: 0,1,4,5,6;\n    -fx-background-radius: 9,8,5,4,3;");
        fast.setEffect((Effect)new GaussianBlur(2.0));
        canv.setStyle(" -fx-background-color:linear-gradient(from 60% 0% to 100% 100%, white 0%, #709070 100%);");
        canv.setRight((Node)fast);
        return canv;
    }

    private void initCluster(String yamlFinam) {
        if (yamlFinam == null || !new File(yamlFinam).exists()) {
            System.out.println("file does not exits " + yamlFinam);
            System.exit(0);
        }
        try {
            FCTopicConf toJoin = null;
            FCClusterConfig fcClusterConfig = FCClusterConfig.read(yamlFinam);
            FCTopicConf[] topics = fcClusterConfig.getTopics();
            for (int i = 0; i < topics.length; ++i) {
                FCTopicConf topic = topics[i];
                if (topic.getServiceClass() == null || !topic.getServiceClass().equals(FCMembership.class.getName())) continue;
                toJoin = topic;
                break;
            }
            if (toJoin == null) {
                System.out.println("no FCMembership Service found");
                System.exit(0);
            }
            FastCast.getRemoting().joinCluster(yamlFinam, "gui", null);
            if (!toJoin.isAutoStart()) {
                FastCast.getRemoting().start(toJoin.getName());
            }
            this.localMembership = (FCMembership)FastCast.getRemoting().getService(toJoin.getName());
            this.localMembership.setDoLogClusterMessages(true);
            this.remoteMembership = (FCMembership)((Object)FastCast.getRemoting().getRemoteService(toJoin.getName()));
            this.localMembership.setListener(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        sArgs = args;
        ClusterViewApp.launch((String[])args);
    }

    @Override
    public void nodeAdded(String sender, Object state) {
        this.clGui.nodeAdded(sender, state);
    }

    @Override
    public void nodeLost(String nodeId) {
        this.clGui.nodeLost(nodeId);
    }
}

