/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.control;

import de.ruedigermoeller.fastcast.packeting.MsgReceiver;
import de.ruedigermoeller.fastcast.packeting.PacketReceiveBuffer;
import de.ruedigermoeller.fastcast.packeting.TopicEntry;
import de.ruedigermoeller.fastcast.remoting.FCRemotingListener;
import de.ruedigermoeller.fastcast.remoting.FastCast;
import de.ruedigermoeller.fastcast.util.FCUtils;
import de.ruedigermoeller.heapoff.structs.structtypes.StructString;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class ReceiveBufferDispatcher {
    Executor topicWideDeliveryThread;
    HashMap<StructString, PacketReceiveBuffer> bufferMap = new HashMap();
    int packetSize;
    String clusterName;
    String nodeId;
    int historySize;
    int topic;
    MsgReceiver receiver;
    TopicEntry topicEntry;

    public ReceiveBufferDispatcher(int packetSize, String clusterName, String nodeId, TopicEntry entry, MsgReceiver rec) {
        this.receiver = rec;
        this.packetSize = packetSize;
        this.clusterName = clusterName;
        this.nodeId = nodeId;
        this.historySize = entry.getConf().getReceiveBufferPackets();
        this.topic = entry.getTopic();
        this.topicEntry = entry;
        this.topicWideDeliveryThread = FCUtils.createIncomingMessageThreadExecutor("global delivery " + this.topicEntry.getName(), this.topicEntry.getConf().getDecodeQSize());
    }

    public TopicEntry getTopicEntry() {
        return this.topicEntry;
    }

    public PacketReceiveBuffer getBuffer(StructString sender) {
        PacketReceiveBuffer receiveBuffer = this.bufferMap.get(sender);
        if (receiveBuffer == null) {
            receiveBuffer = new PacketReceiveBuffer(this.packetSize, this.clusterName, this.nodeId, this.historySize, sender.toString(), this.topicEntry, this.receiver, this.topicWideDeliveryThread);
            this.bufferMap.put((StructString)sender.createCopy(), receiveBuffer);
        }
        return receiveBuffer;
    }

    public void cleanup(String s) {
        StructString struct = new StructString(s);
        PacketReceiveBuffer packetReceiveBuffer = this.bufferMap.get(struct);
        this.bufferMap.remove(struct);
        packetReceiveBuffer.terminate();
        FCRemotingListener remotingListener = FastCast.getRemoting().getRemotingListener();
        if (remotingListener != null) {
            remotingListener.senderDied(this.topicEntry.getTopic(), this.topicEntry.getName(), s);
        }
    }
}

