/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.config;

import de.ruedigermoeller.fastcast.config.FCClusterConfig;
import de.ruedigermoeller.fastcast.config.FCTopicConf;
import de.ruedigermoeller.fastcast.service.FCMembership;
import de.ruedigermoeller.fastcast.transport.FCSocketConf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class FCConfigBuilder {
    String nodeName;
    ArrayList<FCSocketConf> trans = new ArrayList();
    ArrayList<FCTopicConf> topics = new ArrayList();

    public static FCConfigBuilder New() {
        return new FCConfigBuilder();
    }

    public TopicBuilder socketTransport(String transportName, String networkIface, String multicastIp, int multicastPort) {
        FCSocketConf sc = new FCSocketConf(transportName);
        sc.setIfacAdr(networkIface);
        sc.setMcastAdr(multicastIp);
        sc.setPort(multicastPort);
        this.trans.add(sc);
        return new TopicBuilder(transportName);
    }

    public TopicBuilder sharedMemTransport(String transportName, File file) {
        return this.sharedMemTransport(transportName, file, 200, 16000);
    }

    public TopicBuilder sharedMemTransport(String transportName, File file, int sizeMByte, int packetSizeBytes) {
        FCSocketConf conf = new FCSocketConf(transportName);
        file.getParentFile().mkdirs();
        conf.setQueueFile(file.getAbsolutePath());
        if (packetSizeBytes < 3000 || packetSizeBytes > 32000) {
            packetSizeBytes = 8000;
        }
        conf.setDgramsize(packetSizeBytes);
        conf.setSendBufferSize(sizeMByte * 1000 * 1000);
        conf.setTransportType(FCSocketConf.MCAST_IPC);
        this.trans.add(conf);
        return new TopicBuilder(transportName);
    }

    public FCClusterConfig build() {
        FCClusterConfig conf = new FCClusterConfig();
        HashSet<Object> doubles = new HashSet<Object>();
        FCSocketConf[] sockets = new FCSocketConf[this.trans.size()];
        for (int i = 0; i < sockets.length; ++i) {
            String name = this.trans.get(i).getName();
            if (doubles.contains(name)) {
                throw new RuntimeException("transport " + name + " configured twice");
            }
            sockets[i] = this.trans.get(i);
            doubles.add(name);
        }
        conf.setTransports(sockets);
        FCTopicConf[] tops = new FCTopicConf[this.topics.size()];
        doubles.clear();
        for (int i = 0; i < tops.length; ++i) {
            String name = this.topics.get(i).getName();
            int topicId = this.topics.get(i).getTopic();
            if (doubles.contains(name) || doubles.contains(topicId)) {
                throw new RuntimeException("Topic name or Id defined twice " + topicId);
            }
            tops[i] = this.topics.get(i);
            doubles.add(name);
            doubles.add(topicId);
        }
        conf.setTopics(tops);
        return conf;
    }

    public class TopicBuilder {
        String transName;

        public TopicBuilder(String transportName) {
            this.transName = transportName;
        }

        public TopicBuilder topic(String topicname, int topicId) {
            return this.topic(topicname, topicId, 1000, 5);
        }

        public TopicBuilder topic(String topicname, int topicId, int maxDatagramsPerSecond) {
            return this.topic(topicname, topicId, maxDatagramsPerSecond, 5);
        }

        public TopicBuilder topic(String topicname, int topicId, int maxDatagramsPerSecond, int maxGCPauseSeconds) {
            FCTopicConf conf = new FCTopicConf();
            conf.setTransport(this.transName);
            conf.setName(topicname);
            conf.setTopic(topicId);
            conf.setDGramRate(maxDatagramsPerSecond);
            conf.setMaxSendPacketQueueSize(maxDatagramsPerSecond / 10);
            conf.setNumPacketHistory(maxDatagramsPerSecond * maxGCPauseSeconds + conf.getMaxSendPacketQueueSize());
            conf.setReceiveBufferPackets(maxDatagramsPerSecond);
            FCConfigBuilder.this.topics.add(conf);
            return this;
        }

        public TopicBuilder setOpenCalls(int maxOpen, long timeoutMS) {
            FCTopicConf fcTopicConf = FCConfigBuilder.this.topics.get(FCConfigBuilder.this.topics.size() - 1);
            fcTopicConf.setMaxOpenRespondedCalls(maxOpen);
            fcTopicConf.setResponseMethodsTimeout((int)timeoutMS);
            return this;
        }

        public TopicBuilder setSendQueuePercentage(int percentageOfSendHistory) {
            if (percentageOfSendHistory > 50 || percentageOfSendHistory < 5) {
                throw new RuntimeException("illegal arg, use 5..50");
            }
            FCTopicConf fcTopicConf = FCConfigBuilder.this.topics.get(FCConfigBuilder.this.topics.size() - 1);
            int maxDatagramsPerSecond = fcTopicConf.getNumPacketHistory();
            fcTopicConf.setMaxSendPacketQueueSize(maxDatagramsPerSecond / percentageOfSendHistory);
            return this;
        }

        public TopicBuilder setRequestRespOptions(int maxOpenRequests, int timeOutMillis) {
            FCTopicConf fcTopicConf = FCConfigBuilder.this.topics.get(FCConfigBuilder.this.topics.size() - 1);
            fcTopicConf.setMaxOpenRespondedCalls(maxOpenRequests);
            fcTopicConf.setResponseMethodsTimeout(timeOutMillis);
            return this;
        }

        public TopicBuilder membership(String topicname, int topicId) {
            FCTopicConf conf = new FCTopicConf();
            conf.setTransport(this.transName);
            conf.setName(topicname);
            conf.setTopic(topicId);
            conf.setServiceClass(FCMembership.class.getName());
            conf.setDGramRate(10);
            conf.setNumPacketHistory(100);
            conf.setReceiveBufferPackets(20);
            conf.setMaxSendPacketQueueSize(5);
            conf.setAutoStart(true);
            FCConfigBuilder.this.topics.add(conf);
            return this;
        }

        public FCConfigBuilder end() {
            return FCConfigBuilder.this;
        }

        public TopicBuilder datagramSize(int sizBytes) {
            FCConfigBuilder.this.trans.get(FCConfigBuilder.this.trans.size() - 1).setDgramsize(sizBytes);
            return this;
        }
    }
}

