/*
 * Decompiled with CFR 0.152.
 */
package de.rtner.security.auth.spi;

import de.rtner.security.auth.spi.PBKDF2;
import de.rtner.security.auth.spi.PBKDF2Formatter;
import de.rtner.security.auth.spi.PBKDF2Parameters;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;

public class SaltedDatabaseServerLoginModule
extends DatabaseServerLoginModule {
    private static final String HMAC_ALGORITHM = "hmacAlgorithm";
    private static final String HASH_CHARSET = "hashCharset";
    private static final String FORMATTER = "formatter";
    private static final String ENGINE = "engine";
    private static final String ENGINE_PARAMETERS = "engine-parameters";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"hmacAlgorithm", "hashCharset", "formatter", "engine", "engine-parameters"};
    public final String DEFAULT_FORMATTER = "de.rtner.security.auth.spi.PBKDF2HexFormatter";
    public final String DEFAULT_ENGINE = "de.rtner.security.auth.spi.PBKDF2Engine";
    public final String DEFAULT_PARAMETER = "de.rtner.security.auth.spi.PBKDF2Parameters";
    protected String hashAlgorithm = null;
    protected String hashCharset = null;
    protected String formatterClassName = null;
    protected PBKDF2Formatter formatter = null;
    protected String engineClassName = null;
    protected String parameterClassName = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.hashAlgorithm = (String)options.get(HMAC_ALGORITHM);
        if (this.hashAlgorithm == null) {
            this.hashAlgorithm = "HMacSHA1";
        }
        this.hashCharset = (String)options.get(HASH_CHARSET);
        this.formatterClassName = (String)options.get(FORMATTER);
        if (this.formatterClassName == null) {
            this.formatterClassName = "de.rtner.security.auth.spi.PBKDF2HexFormatter";
        }
        this.engineClassName = (String)options.get(ENGINE);
        if (this.engineClassName == null) {
            this.engineClassName = "de.rtner.security.auth.spi.PBKDF2Engine";
        }
        this.parameterClassName = (String)options.get(ENGINE_PARAMETERS);
        if (this.parameterClassName == null) {
            this.parameterClassName = "de.rtner.security.auth.spi.PBKDF2Parameters";
        }
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean verifyOK;
        block0: {
            PBKDF2 pBKDF2Engine;
            PBKDF2Formatter f;
            PBKDF2Parameters p;
            verifyOK = false;
            if (inputPassword == null || expectedPassword == null || (p = this.getEngineParameters()) == null || (f = this.getFormatter()) == null || f.fromString(p, expectedPassword) || (pBKDF2Engine = this.getEngine(p)) == null) break block0;
            verifyOK = pBKDF2Engine.verifyKey(inputPassword);
        }
        return verifyOK;
    }

    protected PBKDF2Parameters getEngineParameters() {
        PBKDF2Parameters p = this.newInstance(this.parameterClassName, PBKDF2Parameters.class);
        if (p != null) {
            p.setHashAlgorithm(this.hashAlgorithm);
            p.setHashCharset(this.hashCharset);
        }
        return p;
    }

    protected PBKDF2 getEngine(PBKDF2Parameters parameters) {
        PBKDF2 engine = this.newInstance(this.engineClassName, PBKDF2.class);
        if (engine != null) {
            engine.setParameters(parameters);
        }
        return engine;
    }

    protected PBKDF2Formatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = this.newInstance(this.formatterClassName, PBKDF2Formatter.class);
        }
        return this.formatter;
    }

    protected <T> T newInstance(String name, Class<T> clazz) {
        T r = null;
        try {
            Class<?> loadedClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(name);
            r = (T)loadedClass.newInstance();
        }
        catch (Exception e) {
            LoginException le = new LoginException(PicketBoxMessages.MESSAGES.failedToInstantiateClassMessage(clazz));
            le.initCause(e);
            this.setValidateError(le);
        }
        return r;
    }
}

