/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.section;

import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionModel;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.prelle.javafx.Section;
import org.prelle.javafx.SymbolIcon;

public abstract class ListSection<T>
extends Section {
    protected static final System.Logger logger = RPGFrameworkJavaFX.logger;
    protected Button btnAdd;
    protected Button btnDel;
    protected ListView<T> list;
    protected ObjectProperty<T> showHelpFor = new SimpleObjectProperty();
    @FXML
    protected ObjectProperty<Node> headerNodeProperty = new SimpleObjectProperty();

    public ListSection(String title) {
        super.setId(title);
        this.initListComponents();
        this.getStyleClass().add((Object)"list-section");
        this.setTitle(title);
        this.setContent((Node)this.list);
        this.initListInteractivity();
    }

    private void initListComponents() {
        this.list = new ListView();
        this.list.setMaxHeight(Double.MAX_VALUE);
        this.btnAdd = new Button(null, (Node)new SymbolIcon("add"));
        this.btnDel = new Button(null, (Node)new SymbolIcon("delete"));
        this.btnDel.setDisable(true);
        this.getButtons().addAll((Object[])new Button[]{this.btnAdd, this.btnDel});
    }

    protected void initListInteractivity() {
        this.showHelpFor.bind((ObservableValue)this.list.getSelectionModel().selectedItemProperty());
        this.list.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.selectionChanged(o, n));
        this.btnAdd.setOnAction(ev -> this.onAdd());
        this.btnDel.setOnAction(ev -> this.onDelete(this.list.getSelectionModel().getSelectedItem()));
        this.headerNodeProperty.addListener((ov, o, n) -> {
            if (n == null) {
                this.setContent((Node)this.list);
            } else {
                VBox box = new VBox(5.0, new Node[]{n, this.list});
                box.setMaxHeight(Double.MAX_VALUE);
                this.list.setMaxHeight(Double.MAX_VALUE);
                VBox.setVgrow(this.list, (Priority)Priority.ALWAYS);
                this.setContent((Node)box);
            }
        });
    }

    protected void selectionChanged(T old, T neu) {
        this.btnDel.setDisable(neu == null);
    }

    public void setData(List<T> data) {
        this.list.getItems().setAll(data);
    }

    public ReadOnlyObjectProperty<T> showHelpForProperty() {
        return this.showHelpFor;
    }

    public SelectionModel<T> getSelectionModel() {
        return this.list.getSelectionModel();
    }

    public ListView<T> getListView() {
        return this.list;
    }

    protected abstract void onAdd();

    protected abstract void onDelete(T var1);

    protected void onSettings() {
        logger.log(System.Logger.Level.WARNING, "onSettings() not overloaded in " + String.valueOf(((Object)((Object)this)).getClass()));
    }

    public ObjectProperty<Node> headerNodeProperty() {
        return this.headerNodeProperty;
    }

    public Node getHeaderNode() {
        return (Node)this.headerNodeProperty.get();
    }

    public Section setHeaderNode(Node value) {
        this.headerNodeProperty.set((Object)value);
        return this;
    }
}

