/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.section;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import java.util.function.Function;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.image.Image;
import org.controlsfx.control.GridView;
import org.prelle.javafx.Section;
import org.prelle.javafx.SymbolIcon;

public class IconSection<T extends DataItem, D extends DataItemValue<T>>
extends Section {
    private static final System.Logger logger = System.getLogger(IconSection.class.getPackageName());
    private final Image EMPTY = new Image(RPGFrameworkJFXConstants.class.getResourceAsStream("Person.png"));
    static final int SIZE = 64;
    protected Function<T, Image> iconResolver;
    protected Button btnAdd;
    protected Button btnDel;
    protected IntegerProperty slots = new SimpleIntegerProperty(4);
    protected ObservableList<D> items = FXCollections.observableArrayList();
    protected SelectionModel<D> selectionModel = new SingleSelectionModel<D>(){

        protected D getModelItem(int index) {
            return (DataItemValue)IconSection.this.items.get(index);
        }

        protected int getItemCount() {
            return IconSection.this.items.size();
        }
    };
    private ObjectProperty<D> showHelpFor = new SimpleObjectProperty();
    private ObjectProperty<EventHandler<ActionEvent>> onAddProperty = new SimpleObjectProperty();
    private ObjectProperty<EventHandler<ActionEvent>> onDeleteProperty = new SimpleObjectProperty();
    private GridView<D> tiles;

    public IconSection(Function<T, Image> iconResolver, String title) {
        this.iconResolver = iconResolver;
        this.setTitle(title);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    public ObservableList<D> getItems() {
        return this.items;
    }

    public IntegerProperty slotsProperty() {
        return this.slots;
    }

    public int getSlots() {
        return this.slots.get();
    }

    public IconSection<T, D> setSlots(int value) {
        this.slots.set(value);
        return this;
    }

    public ReadOnlyObjectProperty<D> showHelpForProperty() {
        return this.showHelpFor;
    }

    private void initComponents() {
        this.tiles = new GridView(this.items);
        this.tiles.setHorizontalCellSpacing(10.0);
        this.tiles.setVerticalCellSpacing(10.0);
        this.tiles.setCellWidth(68.0);
        this.tiles.setCellHeight(80.0);
        this.btnAdd = new Button(null, (Node)new SymbolIcon("add"));
        this.btnDel = new Button(null, (Node)new SymbolIcon("delete"));
        this.btnDel.setDisable(true);
        this.getButtons().addAll((Object[])new Button[]{this.btnAdd, this.btnDel});
    }

    private void initLayout() {
        this.setContent((Node)this.tiles);
    }

    private void initInteractivity() {
        this.slots.addListener((ov, o, n) -> this.refresh());
        this.items.addListener(new ListChangeListener<D>(){

            public void onChanged(ListChangeListener.Change<? extends D> changes) {
                logger.log(System.Logger.Level.INFO, "Items changed");
                IconSection.this.refresh();
            }
        });
        this.btnAdd.setOnAction(ev -> this.onAdd((ActionEvent)ev));
        this.btnDel.setOnAction(ev -> this.onDelete((ActionEvent)ev));
    }

    public void refresh() {
        logger.log(System.Logger.Level.INFO, "refresh");
    }

    protected void onAdd(ActionEvent ev) {
        if (this.onAddProperty.get() != null) {
            ((EventHandler)this.onAddProperty.get()).handle((Event)ev);
        }
    }

    protected void onDelete(ActionEvent ev) {
        if (this.onDeleteProperty.get() != null) {
            ((EventHandler)this.onDeleteProperty.get()).handle((Event)ev);
        }
    }

    public void setOnAddAction(EventHandler<ActionEvent> handler) {
        this.onAddProperty.set(handler);
    }

    public void setOnDeleteAction(EventHandler<ActionEvent> handler) {
        this.onDeleteProperty.set(handler);
    }

    public boolean select(D item) {
        this.selectionModel.select(item);
        return this.selectionModel.getSelectedItem() == item;
    }

    public SelectionModel<D> getSelectionModel() {
        return this.selectionModel;
    }
}

