/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.section;

import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.section.IconGridCell;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.GridView;
import org.prelle.javafx.Section;
import org.prelle.javafx.SymbolIcon;

public abstract class GridSection<T>
extends Section {
    protected static final System.Logger logger = RPGFrameworkJavaFX.logger;
    protected Button btnAdd;
    protected Button btnDel;
    protected GridView<T> list;
    protected ObjectProperty<T> showHelpFor = new SimpleObjectProperty();
    @FXML
    protected ObjectProperty<Node> headerNodeProperty = new SimpleObjectProperty();
    private SelectionModel<T> selectionModel;
    protected transient List<IconGridCell> allCells = new ArrayList<IconGridCell>();

    public GridSection(String title) {
        super.setId(title);
        this.initListComponents();
        this.getStyleClass().add((Object)"list-section");
        this.setTitle(title);
        this.setContent((Node)this.list);
        this.initListInteractivity();
    }

    private void initListComponents() {
        this.list = new GridView();
        this.list.setMaxHeight(Double.MAX_VALUE);
        this.list.setHorizontalCellSpacing(10.0);
        this.list.setVerticalCellSpacing(10.0);
        this.selectionModel = new SingleSelectionModel<T>(){

            protected T getModelItem(int index) {
                return GridSection.this.list.getItems().get(index);
            }

            protected int getItemCount() {
                return GridSection.this.list.getItems().size();
            }
        };
        this.btnAdd = new Button(null, (Node)new SymbolIcon("add"));
        this.btnDel = new Button(null, (Node)new SymbolIcon("delete"));
        this.btnDel.setDisable(true);
        this.getButtons().addAll((Object[])new Button[]{this.btnAdd, this.btnDel});
    }

    protected void initListInteractivity() {
        this.showHelpFor.bind((ObservableValue)this.selectionModel.selectedItemProperty());
        this.btnAdd.setOnAction(ev -> this.onAdd());
        this.btnDel.setOnAction(ev -> this.onDelete(this.selectionModel.getSelectedItem()));
        this.headerNodeProperty.addListener((ov, o, n) -> {
            if (n == null) {
                this.setContent((Node)this.list);
            } else {
                VBox box = new VBox(5.0, new Node[]{n, this.list});
                box.setMaxHeight(Double.MAX_VALUE);
                this.list.setMaxHeight(Double.MAX_VALUE);
                VBox.setVgrow(this.list, (Priority)Priority.ALWAYS);
                this.setContent((Node)box);
            }
        });
        this.selectionModel.selectedIndexProperty().addListener((ov, o, n) -> {
            for (IconGridCell cell : this.allCells) {
                if (cell.getIndex() != ((Integer)o).intValue()) continue;
                cell.pseudoClassStateChanged(IconGridCell.PSEUDO_CLASS_SELECTED, false);
            }
        });
    }

    public void setData(List<T> data) {
        this.list.getItems().setAll(data);
    }

    public ReadOnlyObjectProperty<T> showHelpForProperty() {
        return this.showHelpFor;
    }

    public SelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    public GridView<T> getListView() {
        return this.list;
    }

    protected abstract void onAdd();

    protected abstract void onDelete(T var1);

    protected void onSettings() {
        logger.log(System.Logger.Level.WARNING, "onSettings() not overloaded in " + String.valueOf(((Object)((Object)this)).getClass()));
    }

    public ObjectProperty<Node> headerNodeProperty() {
        return this.headerNodeProperty;
    }

    public Node getHeaderNode() {
        return (Node)this.headerNodeProperty.get();
    }

    public Section setHeaderNode(Node value) {
        this.headerNodeProperty.set((Object)value);
        return this;
    }
}

