/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.section;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.chargen.CharacterController;
import de.rpgframework.jfx.section.HistoryElementSection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.Section;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.TitledComponent;
import org.prelle.javafx.WindowMode;

public class AppearanceSection
extends Section
implements ResponsiveControl {
    private static final System.Logger logger = System.getLogger(AppearanceSection.class.getPackageName());
    private static final ResourceBundle RES = ResourceBundle.getBundle(HistoryElementSection.class.getPackageName() + ".Section");
    private static Preferences CONFIG = Preferences.userRoot().node("/de/rpgframework/lastDir/open");
    private Button btnPortraitEdit;
    private Button btnPortraitRemove;
    public ImageView iView;
    private TextField tfColorHair;
    private TextField tfColorSkin;
    private TextField tfColorEyes;
    private TextField tfSize;
    private TextField tfWeight;
    private TextField tfBirthday;
    private RuleSpecificCharacterObject<?, ?, ?, ?> model;
    private Image dummyImage;

    public AppearanceSection() {
        this(null);
    }

    public AppearanceSection(RuleSpecificCharacterObject model) {
        super(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.title"), null);
        this.setId("appearance");
        this.initComponents();
        if (ResponsiveControlManager.getCurrentMode() == WindowMode.MINIMAL) {
            this.toMinimal();
        } else {
            this.toNonMinimal();
        }
        this.model = model;
        this.refresh();
        this.initInteractivity();
    }

    private void initComponents() {
        this.btnPortraitEdit = new Button(null, (Node)new SymbolIcon("Edit"));
        this.btnPortraitEdit.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.button.edit")));
        this.btnPortraitRemove = new Button(null, (Node)new SymbolIcon("delete"));
        this.btnPortraitRemove.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.button.delete")));
        this.getButtons().addAll((Object[])new Button[]{this.btnPortraitEdit, this.btnPortraitRemove});
        this.iView = new ImageView();
        this.iView.setFitWidth(200.0);
        this.iView.setFitHeight(200.0);
        this.iView.setStyle("-fx-background-color: rgba(128,0,0,0.5);");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("Placeholder.png");
        Image img = new Image(is);
        logger.log(System.Logger.Level.WARNING, "AppearanceSection: Exception of " + String.valueOf(img) + " is " + String.valueOf(img.getException()));
        this.iView.setImage(img);
        this.tfColorHair = new TextField();
        this.tfColorHair.setPrefColumnCount(8);
        this.tfColorHair.setMinWidth(70.0);
        this.tfColorSkin = new TextField();
        this.tfColorSkin.setPrefColumnCount(8);
        this.tfColorEyes = new TextField();
        this.tfColorEyes.setPrefColumnCount(8);
        this.tfBirthday = new TextField();
        this.tfBirthday.setPrefColumnCount(8);
        this.tfSize = new TextField();
        this.tfSize.setPrefColumnCount(4);
        this.tfWeight = new TextField();
        this.tfWeight.setPrefColumnCount(4);
    }

    private void toMinimal() {
        logger.log(System.Logger.Level.WARNING, "toMinimal");
        FlowPane input = new FlowPane(new Node[]{new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.colorHair"), (Node)this.tfColorHair), new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.colorSkin"), (Node)this.tfColorSkin), new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.size"), (Node)this.tfSize), new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.colorEyes"), (Node)this.tfColorEyes), new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.birthday"), (Node)this.tfBirthday), new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.weight"), (Node)this.tfWeight)});
        input.setVgap(5.0);
        input.setHgap(5.0);
        VBox layout = new VBox(5.0, new Node[]{input, this.iView});
        layout.setAlignment(Pos.TOP_CENTER);
        this.setContent((Node)layout);
        logger.log(System.Logger.Level.WARNING, "Call requestLayout() on " + String.valueOf((Object)this));
        super.requestLayout();
    }

    private void toNonMinimal() {
        logger.log(System.Logger.Level.WARNING, "toNonMinimal");
        GridPane input = new GridPane();
        input.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        input.setVgap(5.0);
        input.setHgap(5.0);
        input.getColumnConstraints().add((Object)new ColumnConstraints(80.0, 100.0, 200.0));
        Label lbColorHair = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.colorHair"));
        Label lbColorSkin = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.colorSkin"));
        Label lbColorEyes = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.colorEyes"));
        Label lbBirthday = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.birthday"));
        Label lbWeight = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.weight"));
        Label lbSize = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.label.size"));
        lbColorHair.getStyleClass().add((Object)"base");
        lbColorSkin.getStyleClass().add((Object)"base");
        lbColorEyes.getStyleClass().add((Object)"base");
        lbBirthday.getStyleClass().add((Object)"base");
        lbWeight.getStyleClass().add((Object)"base");
        lbSize.getStyleClass().add((Object)"base");
        input.add((Node)lbColorHair, 0, 0);
        input.add((Node)this.tfColorHair, 1, 0);
        input.add((Node)lbColorSkin, 0, 1);
        input.add((Node)this.tfColorSkin, 1, 1);
        input.add((Node)lbColorEyes, 0, 2);
        input.add((Node)this.tfColorEyes, 1, 2);
        input.add((Node)lbSize, 0, 3);
        input.add((Node)this.tfSize, 1, 3);
        input.add((Node)lbWeight, 0, 4);
        input.add((Node)this.tfWeight, 1, 4);
        input.add((Node)lbBirthday, 0, 5);
        input.add((Node)this.tfBirthday, 1, 5);
        HBox layout = new HBox(10.0, new Node[]{input, this.iView});
        HBox.setHgrow((Node)layout, (Priority)Priority.SOMETIMES);
        input.setMaxHeight(Double.MAX_VALUE);
        this.setContent((Node)layout);
        super.requestLayout();
    }

    private void initInteractivity() {
        this.tfColorHair.textProperty().addListener((ov, o, n) -> this.model.setHairColor(n));
        this.tfColorEyes.textProperty().addListener((ov, o, n) -> this.model.setEyeColor(n));
        this.tfColorSkin.textProperty().addListener((ov, o, n) -> this.model.setSkinColor(n));
        this.tfSize.textProperty().addListener((ov, o, n) -> this.model.setSize(Integer.parseInt(n)));
        this.tfWeight.textProperty().addListener((ov, o, n) -> this.model.setWeight(Integer.parseInt(n)));
        this.tfBirthday.textProperty().addListener((ov, o, n) -> this.model.setAge(n));
        this.btnPortraitRemove.setOnAction(ev -> {
            if (this.model != null) {
                this.model.setImage(null);
            }
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("Placeholder.png");
            Image img = new Image(is);
            System.err.println("AppearanceSection: " + String.valueOf(img.getException()));
            this.iView.setImage(img);
        });
        this.btnPortraitEdit.setOnAction(ev -> this.onAdd());
    }

    public void setResponsiveMode(WindowMode value) {
        switch (value) {
            case MINIMAL: {
                this.toMinimal();
                break;
            }
            default: {
                this.toNonMinimal();
            }
        }
    }

    public void refresh() {
        if (this.model != null) {
            this.tfColorEyes.setText(this.model.getEyeColor());
            this.tfColorHair.setText(this.model.getHairColor());
            this.tfColorSkin.setText(this.model.getSkinColor());
            this.tfSize.setText(String.valueOf(this.model.getSize()));
            this.tfWeight.setText(String.valueOf(this.model.getWeight()));
            this.tfBirthday.setText(this.model.getAge());
            if (this.model.getImage() != null) {
                try {
                    Image image = new Image((InputStream)new ByteArrayInputStream(this.model.getImage()));
                    if (image.isError()) {
                        logger.log(System.Logger.Level.WARNING, "Failed loading image from character: " + String.valueOf(image.getException()));
                        image.getException().printStackTrace();
                    }
                    this.iView.setImage(image);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.WARNING, "Failed loading image from character: " + String.valueOf(e));
                }
            } else {
                this.iView.setImage(this.dummyImage);
            }
        }
    }

    private void onAdd() {
        block8: {
            logger.log(System.Logger.Level.DEBUG, "opening image selection dialog");
            FileChooser chooser = new FileChooser();
            chooser.setTitle(ResourceI18N.get((ResourceBundle)RES, (String)"section.appearance.filechooser.title"));
            String lastDir = CONFIG.get("image", System.getProperty("user.home"));
            File lastDir2 = new File(lastDir);
            if (lastDir2.exists()) {
                chooser.setInitialDirectory(lastDir2);
            }
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All", new String[]{"*.*"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            try {
                File selection = chooser.showOpenDialog((Window)new Stage());
                if (selection == null) break block8;
                CONFIG.put("image", selection.getParentFile().getAbsolutePath().toString());
                try {
                    byte[] imgBytes = Files.readAllBytes(selection.toPath());
                    Image image = new Image((InputStream)new ByteArrayInputStream(imgBytes));
                    if (image.isError()) {
                        logger.log(System.Logger.Level.ERROR, "Error loading image " + String.valueOf(selection) + ": ", (Throwable)image.getException());
                        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, image.getException()});
                        return;
                    }
                    if (image.getWidth() > 400.0 || image.getHeight() > 400.0) {
                        String msg = ResourceI18N.format((ResourceBundle)RES, (String)"section.appearance.error.image_too_large", (Object[])new Object[]{image.getWidth(), image.getHeight()});
                        logger.log(System.Logger.Level.ERROR, "Image too large: " + msg);
                        double factorX = image.getWidth() > 400.0 ? 400.0 / image.getWidth() : 1.0;
                        double factorY = image.getHeight() > 400.0 ? 400.0 / image.getHeight() : 1.0;
                        double scale = Math.min(factorX, factorY);
                        logger.log(System.Logger.Level.ERROR, "Scale by " + scale);
                        image = this.resample(image, scale);
                        logger.log(System.Logger.Level.ERROR, "After " + image.getWidth() + "x" + image.getHeight());
                        int w = (int)image.getWidth();
                        int h = (int)image.getHeight();
                        byte[] buf = new byte[w * h * 4];
                        image.getPixelReader().getPixels(0, 0, w, h, PixelFormat.getByteBgraInstance(), buf, 0, w * 4);
                    }
                    this.iView.setImage(image);
                    if (this.model != null) {
                        this.model.setImage(imgBytes);
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.WARNING, "Failed loading image from " + String.valueOf(selection) + ": " + String.valueOf(e), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed opening image dialog: " + String.valueOf(e));
                BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, e.toString()});
            }
        }
    }

    private Image resample(Image input, double scaleFactor) {
        int W = (int)input.getWidth();
        int H = (int)input.getHeight();
        double S = scaleFactor;
        logger.log(System.Logger.Level.INFO, "Scale image to " + (double)W * S + "x" + (double)H * S);
        WritableImage output = new WritableImage((int)((double)W * S) + 1, (int)((double)H * S) + 1);
        PixelReader reader = input.getPixelReader();
        PixelWriter writer = output.getPixelWriter();
        for (int y = 0; y < H; ++y) {
            for (int x = 0; x < W; ++x) {
                int argb = reader.getArgb(x, y);
                int dy = 0;
                while ((double)dy < S) {
                    int dx = 0;
                    while ((double)dx < S) {
                        writer.setArgb((int)((double)x * S) + dx, (int)((double)y * S) + dy, argb);
                        ++dx;
                    }
                    ++dy;
                }
            }
        }
        return output;
    }

    public void updateController(CharacterController ctrl) {
        this.model = ctrl.getModel();
        this.refresh();
    }

    public void setDummyImage(Image dummyImage) {
        this.dummyImage = dummyImage;
    }
}

