/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pane;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.Reward;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.prelle.javafx.TitledComponent;

public class RewardPane
extends VBox {
    private static PropertyResourceBundle RES = (PropertyResourceBundle)ResourceBundle.getBundle("de.rpgframework.jfx.Panes");
    protected Reward reward;
    private TextField tfName;
    private TextField tfGamemaster;
    private DatePicker datePicker;

    public RewardPane(Reward data) {
        this.reward = data;
        this.initComponents();
        this.initLayout();
        if (data == null) {
            this.reward = new Reward();
        }
        this.refresh();
        this.initInteractivity();
    }

    protected void initComponents() {
        this.tfName = new TextField();
        this.tfName.setPrefColumnCount(30);
        this.tfGamemaster = new TextField();
        LocalDateTime now = LocalDateTime.now();
        this.datePicker = new DatePicker();
        this.datePicker.setValue((Object)now.toLocalDate());
    }

    protected void initLayout() {
        this.setSpacing(5.0);
        TitledComponent tcName = new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"pane.reward.name"), (Node)this.tfName).setTitleMinWidth(Double.valueOf(110.0));
        TitledComponent tcGamemaster = new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"pane.reward.gamemaster"), (Node)this.tfGamemaster).setTitleMinWidth(Double.valueOf(110.0));
        TitledComponent tcRealData = new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"pane.reward.realdate"), (Node)this.datePicker).setTitleMinWidth(Double.valueOf(110.0));
        this.getChildren().addAll((Object[])new Node[]{tcName, tcGamemaster, tcRealData});
    }

    protected void initInteractivity() {
        this.tfName.textProperty().addListener((ov, o, n) -> this.reward.setTitle(n));
        this.tfGamemaster.textProperty().addListener((ov, o, n) -> this.reward.setGamemaster(n));
        this.datePicker.valueProperty().addListener((ov, o, n) -> this.reward.setDate(Date.from(n.atStartOfDay(ZoneId.systemDefault()).toInstant())));
    }

    public Reward getData() {
        return this.reward;
    }

    private void refresh() {
        if (this.reward == null) {
            return;
        }
        this.tfName.setText(this.reward.getTitle());
        this.tfGamemaster.setText(this.reward.getGamemaster());
        this.datePicker.setValue((Object)LocalDate.ofInstant(this.reward.getDate().toInstant(), ZoneId.systemDefault()));
    }
}

