/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pages;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.export.CharacterExportPlugin;
import de.rpgframework.genericrpg.export.ExportPluginRegistry;
import de.rpgframework.jfx.pages.CharacterExportPluginConfigPane;
import de.rpgframework.jfx.pages.CharacterViewLayout;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.TilePane;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.ManagedDialog;

public class CharacterExportPluginSelectorPane<C extends RuleSpecificCharacterObject<?, ?, ?, ?>>
extends TilePane {
    private static final System.Logger logger = System.getLogger(CharacterExportPluginSelectorPane.class.getPackageName());
    private static final ResourceBundle RES = ResourceBundle.getBundle(CharacterViewLayout.class.getName());
    private C character;
    private List<Button> buttons;
    private Node toClose;

    public CharacterExportPluginSelectorPane(C charac) {
        this.character = charac;
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.buttons = new ArrayList<Button>();
        logger.log(System.Logger.Level.INFO, "Loading plugins");
        List plugins = ExportPluginRegistry.getCharacterExportPlugins(this.character);
        logger.log(System.Logger.Level.INFO, "Loaded plugins = " + String.valueOf(plugins));
        for (CharacterExportPlugin plugin : plugins) {
            Button button = new Button(plugin.getName(Locale.getDefault()));
            button.setContentDisplay(ContentDisplay.TOP);
            button.setUserData((Object)plugin);
            button.setWrapText(true);
            button.setStyle("-fx-border-width: 0px; -fx-font-size: 150%; -fx-max-width: 150px");
            byte[] imgData = plugin.getIcon();
            if (imgData != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(imgData);
                ImageView iView = new ImageView(new Image((InputStream)bis));
                iView.setPreserveRatio(true);
                iView.setFitHeight(150.0);
                button.setGraphic((Node)iView);
            }
            this.buttons.add(button);
        }
    }

    private void initLayout() {
        this.setHgap(20.0);
        this.setVgap(20.0);
        this.getChildren().addAll(this.buttons);
    }

    private void initInteractivity() {
        for (Button btn : this.buttons) {
            btn.setOnAction(ev -> this.export((CharacterExportPlugin)btn.getUserData()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(CharacterExportPlugin<C> plugin) {
        logger.log(System.Logger.Level.WARNING, "Export ''{0}'' using ''{1}''/{2}", this.character.getName(), plugin.getName(Locale.getDefault()), plugin.getClass().getSimpleName());
        CharacterExportPluginConfigPane config = new CharacterExportPluginConfigPane(plugin);
        CloseType closed = FlexibleApplication.getInstance().showAlertAndCall(new ManagedDialog(ResourceI18N.get((ResourceBundle)RES, (String)"dialog.exportpluginselector.configs"), (Node)config, new CloseType[]{CloseType.OK, CloseType.CANCEL}), null);
        logger.log(System.Logger.Level.INFO, "Dialog closed with {0}", closed);
        if (closed == CloseType.CANCEL) {
            return;
        }
        byte[] data = null;
        try {
            data = plugin.createExport(this.character);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.ERROR, "Error in export plugin", (Throwable)e);
            Platform.runLater(() -> BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, ResourceI18N.get((ResourceBundle)RES, (String)"dialog.exportpluginselector.export_except"), e}));
            return;
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "Close selector pane: " + String.valueOf(this.toClose));
            if (this.toClose != null) {
                FlexibleApplication.getInstance().close(this.toClose, CloseType.OK);
            }
        }
        logger.log(System.Logger.Level.INFO, "PDF data created - try to save it now");
        try {
            String baseDir = System.getProperty("eden.basedir");
            Path temp = Paths.get(baseDir, "pdfs", this.character.getName() + plugin.getFileType());
            if (!Files.exists(temp.getParent(), new LinkOption[0])) {
                Files.createDirectories(temp.getParent(), new FileAttribute[0]);
            }
            logger.log(System.Logger.Level.INFO, "Write to " + String.valueOf(temp));
            Files.write(temp, data, new OpenOption[0]);
            logger.log(System.Logger.Level.INFO, "Wrote to " + String.valueOf(temp));
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.OPEN_FILE, (Object[])new Object[]{temp});
            Platform.runLater(() -> BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{0, ResourceI18N.format((ResourceBundle)RES, (String)"dialog.exportpluginselector.export_ok", (Object[])new Object[]{temp.toString()})}));
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "Failed creating PDF file: " + String.valueOf(e));
            e.printStackTrace();
        }
    }

    public void setToClose(Node toClose) {
        this.toClose = toClose;
    }
}

