/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.chargen.SelectedValueController;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.DataItem;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.prelle.javafx.SymbolIcon;

public class SelectedValueListCell<V extends ComplexDataItemValue<? extends DataItem>>
extends ListCell<V> {
    private static final String NORMAL_STYLE = "quality-cell";
    protected static final System.Logger logger = System.getLogger(SelectedValueListCell.class.getPackageName());
    protected Supplier<SelectedValueController<V>> controlProvider;
    protected CommonCharacter<?, ?, ?, ?> model;
    protected HBox layout;
    protected VBox bxCenter;
    protected Label name;
    private Label total;
    protected Label lblLock;
    private ImageView imgRecommended;
    protected Separator sep = new Separator(Orientation.HORIZONTAL);
    protected Label lbDescr;
    protected HBox line1;
    protected HBox line2;

    public SelectedValueListCell(Supplier<SelectedValueController<V>> ctrlProv, CommonCharacter<?, ?, ?, ?> model) {
        this.controlProvider = ctrlProv;
        this.model = model;
        this.layout = new HBox(5.0);
        this.name = new Label();
        this.name.getStyleClass().add((Object)"base");
        this.total = new Label();
        this.lbDescr = new Label();
        this.imgRecommended = new ImageView();
        this.imgRecommended.setFitHeight(16.0);
        this.imgRecommended.setFitWidth(16.0);
        this.lblLock = new Label(null, (Node)new SymbolIcon("lock"));
        this.lblLock.setMaxWidth(50.0);
        this.initStyle();
        this.initLayout();
        this.initInteractivity();
        this.getStyleClass().add((Object)"qualityvalue-list-cell");
    }

    private void initStyle() {
        this.total.getStyleClass().add((Object)"text-secondary-info");
        this.name.setStyle("-fx-font-weight: bold");
        this.getStyleClass().add((Object)NORMAL_STYLE);
    }

    protected void initLayout() {
        Region buf = new Region();
        buf.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)buf, (Priority)Priority.ALWAYS);
        this.line1 = new HBox(10.0);
        this.line1.getChildren().addAll((Object[])new Node[]{this.name, buf, this.lblLock});
        this.line2 = new HBox(5.0);
        this.line2.getChildren().addAll((Object[])new Node[]{this.lbDescr});
        this.line2.setAlignment(Pos.CENTER_LEFT);
        this.bxCenter = new VBox(2.0);
        this.bxCenter.getChildren().addAll((Object[])new Node[]{this.line1, this.line2});
        this.bxCenter.getChildren().add((Object)this.sep);
        this.layout.getChildren().addAll((Object[])new Node[]{this.bxCenter});
        this.layout.setFillHeight(false);
        this.layout.setAlignment(Pos.BOTTOM_CENTER);
        this.bxCenter.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.bxCenter, (Priority)Priority.ALWAYS);
        this.setAlignment(Pos.CENTER);
    }

    private void initInteractivity() {
        this.setOnDragDetected(event -> this.dragStarted((MouseEvent)event));
    }

    private void dragStarted(MouseEvent event) {
        logger.log(System.Logger.Level.DEBUG, "drag started for " + String.valueOf(this.getItem()));
        if (this.getItem() == null) {
            return;
        }
        Node source = (Node)event.getSource();
        logger.log(System.Logger.Level.DEBUG, "drag src = " + String.valueOf(source));
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = "qualityval:" + ((ComplexDataItem)((ComplexDataItemValue)this.getItem()).getModifyable()).getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    public void updateItem(V item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            SelectedValueController<V> charGen = this.controlProvider.get();
            this.name.setText(item.getNameWithoutRating());
            this.lbDescr.setVisible(!item.getDecisions().isEmpty());
            this.lbDescr.setManaged(!item.getDecisions().isEmpty());
            this.lbDescr.setText(item.getDecisionString(Locale.getDefault(), this.model));
            Possible removeable = charGen.canBeDeselected(item);
            if (removeable != null) {
                this.lblLock.setVisible(!removeable.get());
                if (removeable.get()) {
                    this.lblLock.setTooltip(null);
                } else {
                    this.lblLock.setTooltip(new Tooltip("Auto-Injected"));
                }
            }
            this.setGraphic((Node)this.layout);
        }
    }

    protected void editClicked(V ref) {
        logger.log(System.Logger.Level.WARNING, "TODO: editClicked for " + String.valueOf(((Object)((Object)this)).getClass()));
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{0, "The developer forgot to support editing '" + ((ComplexDataItem)((ComplexDataItemValue)this.getItem()).getResolved()).getTypeString() + "' or hide the edit button :)"});
    }
}

