/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.DataSet;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class DataSetListCell
extends ListCell<DataSet> {
    private CommonCharacter<?, ?, ?, ?> model;
    private CheckBox cbSelected;
    private Label name;
    private HBox languages;
    private HBox layout;
    private boolean updating;

    public DataSetListCell(CommonCharacter<?, ?, ?, ?> model) {
        this.model = model;
        this.cbSelected = new CheckBox();
        this.name = new Label();
        this.languages = new HBox(5.0);
        this.name.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.name, (Priority)Priority.ALWAYS);
        this.layout = new HBox(5.0, new Node[]{this.cbSelected, this.name, this.languages});
    }

    public BooleanProperty selectedCheckboxProperty() {
        return this.cbSelected.selectedProperty();
    }

    public void updateItem(DataSet item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.updating = true;
        if (empty) {
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)this.layout);
            this.name.setText(item.getName(Locale.getDefault()));
            this.cbSelected.setUserData((Object)item.getID());
            this.cbSelected.selectedProperty().addListener((ov, o, n) -> {
                if (this.updating) {
                    return;
                }
                if (n.booleanValue()) {
                    this.model.getDataSets().add(((DataSet)this.getItem()).getID());
                } else {
                    this.model.getDataSets().remove(((DataSet)this.getItem()).getID());
                }
            });
            this.languages.getChildren().clear();
            for (Locale loc : item.getLocales()) {
                String lang = loc.getLanguage();
                if (lang.equals("de")) {
                    Label icon = new Label("  " + String.valueOf(Character.toChars(127465)) + String.valueOf(Character.toChars(127466)));
                    icon.setStyle("-fx-font-family: \"Segoe UI Symbol\"; -fx-font-size: 150%");
                    this.languages.getChildren().add((Object)icon);
                    continue;
                }
                if (lang.equals("en")) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(Character.toChars(127482));
                    sb.append(Character.toChars(127480));
                    Label icon = new Label("   " + String.valueOf(Character.toChars(127482)) + String.valueOf(Character.toChars(127480)));
                    icon.setStyle("-fx-font-family: \"Segoe UI Symbol\"; -fx-font-size: 150%");
                    this.languages.getChildren().add((Object)icon);
                    continue;
                }
                this.languages.getChildren().add((Object)new Label("  " + lang));
            }
        }
        this.updating = false;
    }
}

