/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.GenericCore;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.Selector;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ComplexDataItemListCell<T extends ComplexDataItem>
extends ListCell<T> {
    private static final System.Logger logger = System.getLogger(ComplexDataItemListCell.class.getName());
    protected Supplier<ComplexDataItemController<T, ? extends ComplexDataItemValue<T>>> controlProv;
    private Function<T, String> costStringGetter;
    private Function<Requirement, String> reqResolver;
    private Selector<T, ? extends ComplexDataItemValue<T>> selector;
    protected Label lbName = new Label();
    private Label lbCost = new Label();
    protected Label lbSource;
    protected HBox line1 = new HBox(20.0, new Node[]{this.lbName, this.lbCost});
    protected VBox layout;

    public ComplexDataItemListCell() {
        this.lbSource = new Label();
        this.lbName.getStyleClass().add((Object)"base");
        this.lbSource.getStyleClass().add((Object)"text-tertiary-info");
        HBox.setHgrow((Node)this.lbName, (Priority)Priority.ALWAYS);
        this.lbName.setMaxWidth(Double.MAX_VALUE);
        this.layout = new VBox(new Node[]{this.line1, this.lbSource});
    }

    public ComplexDataItemListCell(Supplier<ComplexDataItemController<T, ? extends ComplexDataItemValue<T>>> controlProv) {
        this();
        this.controlProv = controlProv;
        if (controlProv != null) {
            this.setOnDragDetected(event -> this.dragStarted((MouseEvent)event));
            this.setOnMouseClicked(event -> this.clicked((MouseEvent)event));
        }
    }

    public ComplexDataItemListCell(Supplier<ComplexDataItemController<T, ? extends ComplexDataItemValue<T>>> controlProv, Function<Requirement, String> req) {
        this();
        this.controlProv = controlProv;
        this.reqResolver = req;
        if (controlProv != null) {
            this.setOnDragDetected(event -> this.dragStarted((MouseEvent)event));
            this.setOnMouseClicked(event -> this.clicked((MouseEvent)event));
        }
    }

    public ComplexDataItemListCell(Supplier<ComplexDataItemController<T, ? extends ComplexDataItemValue<T>>> controlProv, Function<Requirement, String> req, Selector<T, ? extends ComplexDataItemValue<T>> selector) {
        this();
        this.controlProv = controlProv;
        this.reqResolver = req;
        this.selector = selector;
        if (controlProv != null) {
            this.setOnDragDetected(event -> this.dragStarted((MouseEvent)event));
            this.setOnMouseClicked(event -> this.clicked((MouseEvent)event));
        }
    }

    public ComplexDataItemListCell(Function<T, String> costStringGetter) {
        this();
        this.costStringGetter = costStringGetter;
        if (this.controlProv != null) {
            this.setOnDragDetected(event -> this.dragStarted((MouseEvent)event));
            this.setOnMouseClicked(event -> this.clicked((MouseEvent)event));
        }
    }

    protected List<String> getIgnoreKeys() {
        return List.of();
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.lbName.setText(item.getName());
            this.lbSource.setText(String.join((CharSequence)", ", GenericCore.getBestPageReferenceLongNames(item, (Locale)Locale.getDefault())));
            if (this.controlProv != null && this.controlProv.get() != null) {
                try {
                    Possible poss = this.controlProv.get().canBeSelected(item, new Decision[0]);
                    this.lbName.setDisable(!poss.get());
                    this.setUserData(!poss.get());
                    ToDoElement showMess = poss.getMostSevereExcept(this.getIgnoreKeys());
                    this.lbSource.setStyle(poss.get() || showMess == null ? "" : "-fx-text-fill: highlight");
                    if ((poss.get() || showMess == null) && poss.getState() != Possible.State.REQUIREMENTS_NOT_MET) {
                        this.lbSource.setText(String.join((CharSequence)", ", GenericCore.getBestPageReferenceShortNames(item, (Locale)Locale.getDefault())));
                    } else if (poss.getState() == Possible.State.REQUIREMENTS_NOT_MET) {
                        if (poss.getUnfulfilledRequirements() != null && !poss.getUnfulfilledRequirements().isEmpty()) {
                            ArrayList<String> reqStrings = new ArrayList<String>();
                            for (Requirement r : poss.getUnfulfilledRequirements()) {
                                reqStrings.add(this.reqResolver != null ? this.reqResolver.apply(r) : String.valueOf(r));
                            }
                            this.lbSource.setText(String.join((CharSequence)", ", reqStrings));
                            this.lbSource.setStyle("-fx-text-fill: highlight");
                        }
                    } else if (poss.getMostSevere() != null) {
                        this.lbSource.setText(showMess.getMessage(Locale.getDefault()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.lbSource.setText(String.join((CharSequence)", ", GenericCore.getBestPageReferenceShortNames(item, (Locale)Locale.getDefault())));
                this.lbName.setDisable(false);
                this.setUserData(true);
                this.lbSource.setStyle("");
            }
            if (this.controlProv != null && this.controlProv.get() != null) {
                String costStr = this.controlProv.get().getSelectionCostString(item);
                if (costStr != null) {
                    this.lbCost.setText(costStr);
                } else {
                    float cost = this.controlProv.get().getSelectionCost(item);
                    if (String.valueOf(cost).endsWith(".0")) {
                        this.lbCost.setText(String.valueOf((int)cost));
                    } else {
                        this.lbCost.setText(String.valueOf(cost));
                    }
                }
            } else if (this.costStringGetter != null) {
                this.lbCost.setText(this.costStringGetter.apply(item));
            }
            this.setGraphic((Node)this.layout);
        }
    }

    private void dragStarted(MouseEvent event) {
        logger.log(System.Logger.Level.WARNING, "Drag started " + String.valueOf(event.getSource()));
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        if (this.getItem() == null) {
            return;
        }
        content.putString(((ComplexDataItem)this.getItem()).getTypeString() + ":" + ((ComplexDataItem)this.getItem()).getId());
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    private void clicked(MouseEvent event) {
        logger.log(System.Logger.Level.WARNING, "clicked " + String.valueOf(this.getItem()));
        if (event.getClickCount() != 2) {
            return;
        }
        if (this.getItem() == null) {
            return;
        }
        logger.log(System.Logger.Level.INFO, "doubleclicked " + String.valueOf(this.getItem()));
        if (this.selector != null) {
            this.selector.implSelect((ComplexDataItem)this.getItem());
            logger.log(System.Logger.Level.ERROR, "Selected " + String.valueOf(this.getItem()) + "?");
        } else {
            logger.log(System.Logger.Level.ERROR, "No selector connected");
        }
    }
}

