/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.data.Choice;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.prelle.javafx.SymbolIcon;

public class ChoiceCell
extends ListCell<Choice> {
    private StringConverter<Choice> conv;
    private Supplier<RuleSpecificCharacterObject> modelSupp;
    private Consumer<Choice> editHandler;
    private Button btnEdit;
    private Label choiceText;
    private Label decisionText;
    private HBox layout;

    public ChoiceCell(StringConverter<Choice> conv, Supplier<RuleSpecificCharacterObject> modelSupp, Consumer<Choice> callback) {
        this.conv = conv;
        this.modelSupp = modelSupp;
        this.editHandler = callback;
        if (this.editHandler == null) {
            throw new NullPointerException("callback for editing may not be NULL");
        }
        this.btnEdit = new Button(null, (Node)new SymbolIcon("edit"));
        this.choiceText = new Label();
        this.choiceText.setWrapText(true);
        this.choiceText.getStyleClass().add((Object)"base");
        this.decisionText = new Label();
        VBox box = new VBox(5.0, new Node[]{this.choiceText, this.decisionText});
        this.layout = new HBox(10.0, new Node[]{this.btnEdit, box});
        this.initInteractivity();
    }

    private void refresh() {
        RuleSpecificCharacterObject model = this.modelSupp.get();
        if (model == null) {
            this.btnEdit.setStyle("-fx-background-color: orange");
            this.decisionText.setText("?model missing?");
        } else {
            if (model.hasDecisionBeenMade(((Choice)this.getItem()).getUUID())) {
                this.btnEdit.setStyle("-fx-background-color: transparent");
            } else {
                this.btnEdit.setStyle("-fx-background-color: red");
            }
            if (model.getDecision(((Choice)this.getItem()).getUUID()) != null) {
                this.decisionText.setText(String.valueOf(model.getDecision(((Choice)this.getItem()).getUUID())));
            } else {
                this.decisionText.setText("?");
            }
        }
    }

    private void initInteractivity() {
        this.btnEdit.setOnAction(ev -> {
            this.editHandler.accept((Choice)this.getItem());
            this.refresh();
        });
    }

    public void updateItem(Choice item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.choiceText.setText(this.conv != null ? this.conv.toString((Object)item) : String.valueOf(item));
            this.refresh();
            this.setGraphic((Node)this.layout);
        }
    }
}

