/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.AFilterInjector;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.IRefreshableList;
import de.rpgframework.jfx.cells.ComplexDataItemListCell;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.NavigButtonControl;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.WindowMode;

public abstract class Selector<T extends DataItem, V extends DataItemValue<T>>
extends Pane
implements ResponsiveControl,
IRefreshableList {
    private static final System.Logger logger = System.getLogger(Selector.class.getPackageName());
    private static final Collator COLLATOR = Collator.getInstance(Locale.getDefault());
    protected ComplexDataItemController<T, V> control;
    protected NavigButtonControl btnCtrl;
    protected Function<Requirement, String> resolver;
    protected Function<Modification, String> mResolver;
    protected ListView<T> listPossible;
    protected Predicate<T> baseFilter;
    protected AFilterInjector<T> filter;
    protected Label phAvailable;
    protected VBox col1;
    protected VBox col2;
    protected GenericDescriptionVBox genericDescr;
    protected Pane help;
    protected Label lbNotPossible;

    public Selector(ComplexDataItemController<T, V> ctrl, Function<Requirement, String> resolver, Function<Modification, String> mResolver, AFilterInjector<T> filter) {
        if (ctrl == null) {
            throw new NullPointerException("Controller may not be NULL");
        }
        this.control = ctrl;
        this.filter = filter;
        this.resolver = resolver;
        this.mResolver = mResolver;
        this.initComponents();
        this.initLayout();
        this.listPossible.getItems().addAll((Collection)ctrl.getAvailable());
        if (filter != null) {
            filter.updateChoices(ctrl.getAvailable());
        }
        this.initInteractivity();
        this.updateLayout();
        this.refreshList();
    }

    public Selector(ComplexDataItemController<T, V> ctrl, Predicate<T> baseFilter, Function<Requirement, String> resolver, Function<Modification, String> mResolver, AFilterInjector<T> filter) {
        if (ctrl == null) {
            throw new NullPointerException("Controller may not be NULL");
        }
        this.control = ctrl;
        this.filter = filter;
        this.resolver = resolver;
        this.mResolver = mResolver;
        this.baseFilter = baseFilter;
        this.initComponents();
        this.initLayout();
        List list = ctrl.getAvailable();
        if (baseFilter != null) {
            list = list.stream().filter(baseFilter).collect(Collectors.toList());
        }
        if (filter != null) {
            filter.updateChoices(list);
        }
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.listPossible.getItems().setAll(list);
        this.initInteractivity();
        this.updateLayout();
    }

    private void initComponents() {
        this.phAvailable = new Label();
        this.phAvailable.setWrapText(true);
        this.listPossible = new ListView();
        this.listPossible.setPlaceholder((Node)this.phAvailable);
        this.listPossible.setStyle("-fx-border-width: 1px; -fx-border-color: white; -fx-border-style:solid; -fx-pref-width: 24em");
        this.listPossible.setCellFactory(lv -> new ComplexDataItemListCell(() -> this.control, this.resolver, this));
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
        logger.log(System.Logger.Level.ERROR, "Instantiate GenericDescriptionVBox with {0} and {1}", this.resolver, this.mResolver);
        this.genericDescr = new GenericDescriptionVBox(this.resolver, this.mResolver);
        this.lbNotPossible = new Label();
        this.lbNotPossible.setStyle("-fx-text-fill: highlight;");
        this.lbNotPossible.setWrapText(true);
        this.lbNotPossible.setMaxWidth(Double.MAX_VALUE);
        this.lbNotPossible.setAlignment(Pos.BASELINE_RIGHT);
        this.lbNotPossible.setTextAlignment(TextAlignment.RIGHT);
    }

    private void initLayout() {
        this.getChildren().clear();
        this.col1 = new VBox(new Node[]{this.listPossible});
        this.col1.setFillWidth(true);
        this.col1.setMaxHeight(Double.MAX_VALUE);
        this.col1.setStyle("-fx-max-width: 24em");
        HBox.setHgrow((Node)this.col1, (Priority)Priority.ALWAYS);
        VBox.setVgrow(this.listPossible, (Priority)Priority.ALWAYS);
        VBox filterNode = null;
        if (this.filter != null) {
            filterNode = new VBox(5.0);
            this.filter.addFilter(this, (Pane)filterNode);
        }
        if (filterNode != null) {
            this.col1.getChildren().add(this.col1.getChildren().size() - 1, (Object)filterNode);
        }
        this.col2 = new VBox(new Node[]{this.genericDescr, this.lbNotPossible});
        this.col2.setFillWidth(true);
        this.col2.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow((Node)this.lbNotPossible, (Priority)Priority.NEVER);
    }

    private void initInteractivity() {
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.selectionChanged(n));
    }

    protected void selectionChanged(T n) {
        Pane box = this.getDescriptionNode(n);
        logger.log(System.Logger.Level.ERROR, "Selected {0} and show description node {1}", n, box);
        this.col2.getChildren().setAll((Object[])new Node[]{box, this.lbNotPossible});
        VBox.setVgrow((Node)box, (Priority)Priority.ALWAYS);
        this.help.getChildren().setAll((Object[])new Node[]{this.col1, this.col2});
        Possible poss = this.control.canBeSelected(n, new Decision[0]);
        logger.log(System.Logger.Level.ERROR, "  poss= {0}  btnCtrl={1}", poss, this.btnCtrl);
        if (this.btnCtrl != null) {
            this.btnCtrl.setDisabled(CloseType.OK, !poss.get());
        }
        if (poss.getState() == Possible.State.REQUIREMENTS_NOT_MET) {
            List problems = poss.getUnfulfilledRequirements().stream().map(r -> this.resolver.apply((Requirement)r)).collect(Collectors.toList());
            this.lbNotPossible.setText(String.join((CharSequence)", ", problems));
        } else if (!poss.get()) {
            this.lbNotPossible.setText(poss.getMostSevere().getMessage());
        } else {
            this.lbNotPossible.setText(null);
        }
    }

    protected Pane getDescriptionNode(T selected) {
        this.genericDescr.setData((DataItem)selected);
        return this.genericDescr;
    }

    protected void updateLayout() {
        WindowMode mode = ResponsiveControlManager.getCurrentMode();
        Pane box = this.getDescriptionNode((DataItem)this.listPossible.getSelectionModel().getSelectedItem());
        box.setMaxHeight(Double.MAX_VALUE);
        this.col2.getChildren().setAll((Object[])new Node[]{box, this.lbNotPossible});
        VBox.setVgrow((Node)box, (Priority)Priority.ALWAYS);
        if (mode == WindowMode.MINIMAL) {
            this.help = new VBox(10.0, new Node[]{this.col1, this.col2});
            VBox.setVgrow((Node)this.col1, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)this.col2, (Priority)Priority.ALWAYS);
            this.getChildren().setAll((Object[])new Node[]{this.help});
        } else {
            this.col2.setStyle("-fx-pref-width: 28em");
            this.help = new HBox(20.0, new Node[]{this.col1, this.col2});
            HBox.setHgrow((Node)this.col1, (Priority)Priority.SOMETIMES);
            HBox.setHgrow((Node)box, (Priority)Priority.SOMETIMES);
            this.getChildren().setAll((Object[])new Node[]{this.help});
        }
    }

    public void setResponsiveMode(WindowMode value) {
        this.updateLayout();
    }

    public void setBaseFilter(Predicate<T> filter) {
        this.baseFilter = filter;
        this.refreshList();
    }

    public T getSelected() {
        return (T)((DataItem)this.listPossible.getSelectionModel().getSelectedItem());
    }

    @Override
    public void refreshList() {
        List<T> list = this.control.getAvailable();
        if (this.baseFilter != null) {
            list = list.stream().filter(this.baseFilter).collect(Collectors.toList());
        }
        if (this.filter != null) {
            list = this.filter.applyFilter(list);
        }
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return COLLATOR.compare(o1.getName(), o2.getName());
            }
        });
        this.listPossible.getItems().setAll(list);
    }

    public void setButtonControl(NavigButtonControl btnCtrl) {
        this.btnCtrl = btnCtrl;
    }

    public void implSelect(T toSelect) {
        logger.log(System.Logger.Level.ERROR, "implSelect {0}", toSelect);
        this.btnCtrl.fireEvent(CloseType.OK);
    }
}

