/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.SelectedValueController;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.SelectedValuesControllerTwoColumnSkin;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.WindowMode;

public class SelectedValuesControllerNode<V extends ComplexDataItemValue<?>>
extends Control
implements ResponsiveControl {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private static final String DEFAULT_STYLE_CLASS = "selection-control";
    private ObjectProperty<SelectedValueController<V>> control;
    private ObjectProperty<ObservableList<V>> availableProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<ObservableList<V>> selectedProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<Callback<ListView<V>, ListCell<V>>> cellFactoryProperty;
    private ObjectProperty<Predicate<V>> availableFilterProperty = new SimpleObjectProperty();
    private ObjectProperty<Predicate<V>> selectedFilterProperty = new SimpleObjectProperty();
    private ObjectProperty<Node> selectedListHeadProperty = new SimpleObjectProperty();
    private BooleanProperty showHeadingsProperty;
    private StringProperty availableHeadingProperty;
    private StringProperty selectedHeadingProperty;
    private StringProperty availablePlaceholderProperty;
    private StringProperty selectedPlaceholderProperty;
    private ObjectProperty<V> showHelpForProperty;
    private StringProperty availableStyleProperty;
    private StringProperty selectedStyleProperty;
    private ObjectProperty<Function<Requirement, String>> requirementResolver = new SimpleObjectProperty();
    private ObjectProperty<Function<Modification, String>> modificationResolver = new SimpleObjectProperty();

    public SelectedValuesControllerNode(SelectedValueController<V> controller) {
        this.control = new SimpleObjectProperty(controller);
        this.cellFactoryProperty = new SimpleObjectProperty();
        this.showHeadingsProperty = new SimpleBooleanProperty(true);
        this.availableHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.available"));
        this.selectedHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.selected"));
        this.availablePlaceholderProperty = new SimpleStringProperty();
        this.selectedPlaceholderProperty = new SimpleStringProperty();
        this.showHelpForProperty = new SimpleObjectProperty();
        this.availableStyleProperty = new SimpleStringProperty();
        this.selectedStyleProperty = new SimpleStringProperty();
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.control.addListener((ov, o, n) -> this.refresh());
        this.refresh();
    }

    public Skin<?> createDefaultSkin() {
        return new SelectedValuesControllerTwoColumnSkin(this);
    }

    public ObjectProperty<SelectedValueController<V>> getControllerProperty() {
        return this.control;
    }

    public SelectedValueController<V> getController() {
        return (SelectedValueController)this.control.get();
    }

    public void setController(SelectedValueController<V> value) {
        this.control.set(value);
    }

    public void refresh() {
        if (this.control.get() == null) {
            logger.log(System.Logger.Level.WARNING, "No controller yet");
            return;
        }
        if (logger.isLoggable(System.Logger.Level.DEBUG)) {
            logger.log(System.Logger.Level.DEBUG, "ComplexDataItemControllerNode.refresh: " + String.valueOf(((SelectedValueController)this.control.get()).getSelected()));
        }
        try {
            ((ObservableList)this.availableProperty.get()).setAll((Collection)((SelectedValueController)this.control.get()).getAvailable().stream().sorted((o1, o2) -> o1.getNameWithoutRating().compareTo(o2.getNameWithoutRating())).collect(Collectors.toList()));
            if (this.selectedFilterProperty.get() != null) {
                ((ObservableList)this.selectedProperty.get()).setAll((Collection)((SelectedValueController)this.control.get()).getSelected().stream().filter(this.getSelectedFilter()).collect(Collectors.toList()));
            } else {
                ((ObservableList)this.selectedProperty.get()).setAll((Collection)((SelectedValueController)this.control.get()).getSelected());
            }
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "ComplexDataItemControllerNode.refresh: done");
        }
    }

    public ObjectProperty<ObservableList<V>> availableProperty() {
        return this.availableProperty;
    }

    public ObservableList<V> getAvailable() {
        return (ObservableList)this.availableProperty.get();
    }

    public ObjectProperty<ObservableList<V>> selectedProperty() {
        return this.selectedProperty;
    }

    public ObservableList<V> getSelected() {
        return (ObservableList)this.selectedProperty.get();
    }

    public ObjectProperty<Callback<ListView<V>, ListCell<V>>> cellFactoryProperty() {
        return this.cellFactoryProperty;
    }

    public Callback<ListView<V>, ListCell<V>> getCellFactory() {
        return (Callback)this.cellFactoryProperty.get();
    }

    public void setCellFactory(Callback<ListView<V>, ListCell<V>> value) {
        this.cellFactoryProperty.setValue(value);
    }

    public ObjectProperty<Predicate<V>> selectedFilterProperty() {
        return this.selectedFilterProperty;
    }

    public Predicate<V> getSelectedFilter() {
        return (Predicate)this.selectedFilterProperty.get();
    }

    public void setSelectedFilter(Predicate<V> value) {
        this.selectedFilterProperty.setValue(value);
    }

    public ObjectProperty<Node> selectedListHeadProperty() {
        return this.selectedListHeadProperty;
    }

    public Node getSelectedListHead() {
        return (Node)this.selectedListHeadProperty.get();
    }

    public void setSelectedListHead(Node value) {
        this.selectedListHeadProperty.setValue((Object)value);
    }

    public BooleanProperty showHeadingsProperty() {
        return this.showHeadingsProperty;
    }

    public boolean getShowHeadings() {
        return this.showHeadingsProperty.get();
    }

    public void setShowHeadings(boolean value) {
        this.showHeadingsProperty.set(value);
    }

    public StringProperty availableHeadingProperty() {
        return this.availableHeadingProperty;
    }

    public String getAvailableHeading() {
        return (String)this.availableHeadingProperty.get();
    }

    public void setAvailableHeading(String value) {
        this.availableHeadingProperty.set((Object)value);
    }

    public StringProperty selectedHeadingProperty() {
        return this.selectedHeadingProperty;
    }

    public String getSelectedHeading() {
        return (String)this.selectedHeadingProperty.get();
    }

    public void setSelectedHeading(String value) {
        this.selectedHeadingProperty.set((Object)value);
    }

    public StringProperty availablePlaceholderProperty() {
        return this.availablePlaceholderProperty;
    }

    public String getAvailablePlaceholder() {
        return (String)this.availablePlaceholderProperty.get();
    }

    public void setAvailablePlaceholder(String value) {
        this.availablePlaceholderProperty.set((Object)value);
    }

    public StringProperty selectedPlaceholderProperty() {
        return this.selectedPlaceholderProperty;
    }

    public String getSelectedPlaceholder() {
        return (String)this.selectedPlaceholderProperty.get();
    }

    public void setSelectedPlaceholder(String value) {
        this.selectedPlaceholderProperty.set((Object)value);
    }

    public ObjectProperty<V> showHelpForProperty() {
        return this.showHelpForProperty;
    }

    public V getShowHelpFor() {
        return (V)((ComplexDataItemValue)this.showHelpForProperty.get());
    }

    public void setShowHelpFor(V value) {
        this.showHelpForProperty.setValue(value);
    }

    public StringProperty availableStyleProperty() {
        return this.availableStyleProperty;
    }

    public String getAvailableStyle() {
        return (String)this.availableStyleProperty.get();
    }

    public void setAvailableStyle(String value) {
        this.availableStyleProperty.set((Object)value);
    }

    public StringProperty selectedStyleProperty() {
        return this.selectedStyleProperty;
    }

    public String getSelectedStyle() {
        return (String)this.selectedStyleProperty.get();
    }

    public void setSelectedStyle(String value) {
        this.selectedStyleProperty.set((Object)value);
    }

    public ObjectProperty<Function<Requirement, String>> requirementResolverProperty() {
        return this.requirementResolver;
    }

    public Function<Requirement, String> getRequirementResolver() {
        return (Function)this.requirementResolver.get();
    }

    public SelectedValuesControllerNode<V> setRequirementResolver(Function<Requirement, String> value) {
        this.requirementResolver.setValue(value);
        return this;
    }

    public ObjectProperty<Function<Modification, String>> modificationResolverProperty() {
        return this.modificationResolver;
    }

    public Function<Modification, String> getModificationResolver() {
        return (Function)this.modificationResolver.get();
    }

    public SelectedValuesControllerNode<V> setModificationResolver(Function<Modification, String> value) {
        this.modificationResolver.setValue(value);
        return this;
    }

    public void setResponsiveMode(WindowMode value) {
        System.err.println("ComplexDataItemControllerNode.setResponsive(" + String.valueOf(value) + ")");
        ((SelectedValuesControllerTwoColumnSkin)this.getSkin()).setResponsiveMode(value);
    }
}

