/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.jfx.FreePointsNode;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class FreePointsNodeSkin
extends SkinBase<FreePointsNode> {
    private VBox content;
    private Label points;
    private Label name;
    private Circle clip;

    public FreePointsNodeSkin(FreePointsNode skinnable) {
        super((Control)skinnable);
        this.initComponents();
        this.initLayout();
        this.updateClipping();
        this.initInteractivity();
    }

    private void initComponents() {
        this.points = new Label(FreePointsNodeSkin.getStringFor(Float.valueOf(((FreePointsNode)this.getSkinnable()).getPoints())));
        this.points.getStyleClass().add((Object)"points");
        this.name = new Label(((FreePointsNode)this.getSkinnable()).getName());
        this.name.getStyleClass().add((Object)"name");
    }

    private void initLayout() {
        this.content = new VBox();
        this.content.setStyle("-fx-spacing: 0.2em;");
        this.content.getChildren().addAll((Object[])new Node[]{this.points, this.name});
        this.content.setAlignment(Pos.CENTER);
        Group grp = new Group(new Node[]{this.content});
        this.getChildren().add((Object)grp);
    }

    private static String getStringFor(Number n) {
        int intVal = (int)((Float)n).floatValue();
        if ((float)intVal == ((Float)n).floatValue()) {
            return String.valueOf(intVal);
        }
        return String.valueOf(n);
    }

    private void initInteractivity() {
        ((FreePointsNode)this.getSkinnable()).pointsProperty().addListener((ov, o, n) -> this.points.setText(FreePointsNodeSkin.getStringFor(n)));
        ((FreePointsNode)this.getSkinnable()).nameProperty().addListener((ov, o, n) -> this.name.setText(n));
        this.content.widthProperty().addListener((ov, o, n) -> {
            this.updateSize();
            this.updateClipping();
        });
        this.content.heightProperty().addListener((ov, o, n) -> {
            this.updateSize();
            this.updateClipping();
        });
        ((FreePointsNode)this.getSkinnable()).heightProperty().addListener((ov, o, n) -> {
            this.updateSize();
            this.updateClipping();
        });
    }

    private void updateSize() {
        if (this.content.getHeight() <= 0.0 || this.content.getWidth() <= 0.0) {
            return;
        }
        double size = Math.max(this.content.getWidth(), this.content.getHeight());
        this.content.resize(size, size);
    }

    private void updateClipping() {
        Control reference = this.getSkinnable();
        double x = reference.widthProperty().get() / 2.2;
        double y = reference.heightProperty().get() / 2.2;
        double rad = Math.min(x, y);
        this.clip = new Circle(x, y, rad, Paint.valueOf((String)"black"));
        ((FreePointsNode)this.getSkinnable()).setClip((Node)this.clip);
    }
}

