/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ChoiceOrigin;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.DecisionContainer;
import de.rpgframework.genericrpg.data.GenericRPGTools;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationChoice;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import org.prelle.javafx.ImageSpinningListView;
import org.prelle.javafx.ListWithDetailsView;
import org.prelle.javafx.ListWithDetailsViewColumn;
import org.prelle.javafx.NodeWithTitle;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.WindowMode;

public class DataItemPane<T extends DataItem>
extends ListWithDetailsView<T>
implements ResponsiveControl {
    static final ResourceBundle RES = ResourceBundle.getBundle(DataItemPane.class.getName());
    private ObjectProperty<Function<Modification, String>> modifConverter = new SimpleObjectProperty();
    private ObjectProperty<Function<ModifiedObjectType, String>> refTypeConverter = new SimpleObjectProperty();
    private ObjectProperty<Function<Choice, String>> choiceConverter = new SimpleObjectProperty();
    private DecisionContainer decisionContainer;
    private ObjectProperty<BiConsumer<T, Choice>> decisionHandler = new SimpleObjectProperty();
    private ObjectProperty<BiConsumer<T, ModificationChoice>> modDecisionHandler = new SimpleObjectProperty();
    private ObjectProperty<NodeWithTitle> customNode1 = new SimpleObjectProperty();
    private ObjectProperty<WindowMode> layoutMode = new SimpleObjectProperty((Object)WindowMode.EXPANDED);
    private BooleanProperty showDecisionColumn = new SimpleBooleanProperty(true);
    private BooleanProperty showStatsColumn = new SimpleBooleanProperty(true);
    private BooleanProperty showModificationsInDescription = new SimpleBooleanProperty(true);
    private transient Function<Requirement, String> reqR;
    private transient Function<Modification, String> modR;
    private ImageSpinningListView<T> selector;
    private ListWithDetailsViewColumn<T> colEffects;
    private ListWithDetailsViewColumn<T> colChoices;
    private ListWithDetailsViewColumn<T> colDescription;

    public DataItemPane(Function<Requirement, String> reqR, Function<Modification, String> modR) {
        this.layoutMode.set((Object)ResponsiveControlManager.getCurrentMode());
        this.reqR = reqR;
        this.modR = modR;
        this.initComponents();
        this.initInteractivity();
    }

    private void initColumns() {
        this.colEffects = new ListWithDetailsViewColumn(ResourceI18N.get((ResourceBundle)RES, (String)"tab.effects"), item -> this.getContentStats(item));
        this.colChoices = new ListWithDetailsViewColumn(ResourceI18N.get((ResourceBundle)RES, (String)"tab.choices"), item -> this.getContentStats(item));
        this.colDescription = new ListWithDetailsViewColumn(ResourceI18N.get((ResourceBundle)RES, (String)"tab.description"), item -> {
            GenericDescriptionVBox ret = new GenericDescriptionVBox(this.reqR, this.modR);
            ret.setUseScrollPane(false);
            ret.showModificationsInDescriptionProperty().bind((ObservableValue)this.showModificationsInDescriptionProperty());
            ret.setData((DataItem)item);
            return ret;
        });
    }

    private void initComponents() {
        this.initColumns();
        this.selector = new ImageSpinningListView();
        this.getColumns().addAll((Object[])new ListWithDetailsViewColumn[]{this.colChoices, this.colDescription});
        this.setSelectorNode((ListView)this.selector);
    }

    private void initInteractivity() {
        this.customNode1Property().addListener((ov, o, n) -> {
            this.getColumns().setAll((Object[])new ListWithDetailsViewColumn[]{this.colChoices, this.colDescription});
            if (n != null) {
                ListWithDetailsViewColumn custCol = new ListWithDetailsViewColumn(n.getTitle(), item -> n.getContent());
                this.getColumns().add(0, (Object)custCol);
            }
        });
    }

    public ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.selector.getSelectionModel().selectedItemProperty();
    }

    public T getSelectedItem() {
        return (T)((DataItem)this.selector.getSelectionModel().getSelectedItem());
    }

    public DataItemPane<T> setSelectedItem(T value) {
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.ERROR, "setSelectedItem({0}) for {1}", value, this.getId());
        this.selector.getSelectionModel().select(value);
        return this;
    }

    public void setItems(Collection<T> items) {
        this.selector.setItems(FXCollections.observableArrayList(items));
        this.selector.refreshNames();
    }

    public ObjectProperty<Function<Modification, String>> modificationConverterProperty() {
        return this.modifConverter;
    }

    public Function<Modification, String> getModificationConverter() {
        return (Function)this.modifConverter.get();
    }

    public DataItemPane<T> setModificationConverter(Function<Modification, String> value) {
        this.modifConverter.set(value);
        return this;
    }

    public ObjectProperty<Function<ModifiedObjectType, String>> referenceTypeConverterProperty() {
        return this.refTypeConverter;
    }

    public Function<ModifiedObjectType, String> getReferenceTypeConverter() {
        return (Function)this.refTypeConverter.get();
    }

    public DataItemPane<T> setReferenceTypeConverter(Function<ModifiedObjectType, String> value) {
        this.refTypeConverter.set(value);
        return this;
    }

    public ObjectProperty<Function<Choice, String>> choiceConverterProperty() {
        return this.choiceConverter;
    }

    public Function<Choice, String> getChoiceConverter() {
        return (Function)this.choiceConverter.get();
    }

    public DataItemPane<T> setChoiceConverter(Function<Choice, String> value) {
        this.choiceConverter.set(value);
        return this;
    }

    public void setUseForChoices(DecisionContainer value) {
        this.decisionContainer = value;
    }

    public ObjectProperty<BiConsumer<T, Choice>> decisionHandlerProperty() {
        return this.decisionHandler;
    }

    public BiConsumer<T, Choice> getDecisionHandler() {
        return (BiConsumer)this.decisionHandler.get();
    }

    public DataItemPane<T> setDecisionHandler(BiConsumer<T, Choice> value) {
        this.decisionHandler.set(value);
        return this;
    }

    public ObjectProperty<BiConsumer<T, ModificationChoice>> modDecisionHandlerProperty() {
        return this.modDecisionHandler;
    }

    public BiConsumer<T, ModificationChoice> getModDecisionHandler() {
        return (BiConsumer)this.modDecisionHandler.get();
    }

    public DataItemPane<T> setModDecisionHandler(BiConsumer<T, ModificationChoice> value) {
        this.modDecisionHandler.set(value);
        return this;
    }

    public ObjectProperty<NodeWithTitle> customNode1Property() {
        return this.customNode1;
    }

    public NodeWithTitle getCustomNode1() {
        return (NodeWithTitle)this.customNode1.get();
    }

    public DataItemPane<T> setCustomNode1(NodeWithTitle value) {
        this.customNode1.set((Object)value);
        return this;
    }

    public BooleanProperty showDecisionColumnProperty() {
        return this.showDecisionColumn;
    }

    public Boolean isShowDecisionColumn() {
        return this.showDecisionColumn.get();
    }

    public DataItemPane<T> setShowDecisionColumn(Boolean value) {
        this.showDecisionColumn.set(value.booleanValue());
        return this;
    }

    public BooleanProperty showStatsColumnProperty() {
        return this.showStatsColumn;
    }

    public Boolean isShowStatsColumn() {
        return this.showStatsColumn.get();
    }

    public DataItemPane<T> setShowStatsColumn(Boolean value) {
        this.showStatsColumn.set(value.booleanValue());
        return this;
    }

    public ObjectProperty<WindowMode> layoutModeProperty() {
        return this.layoutMode;
    }

    public BooleanProperty showModificationsInDescriptionProperty() {
        return this.showModificationsInDescription;
    }

    public Boolean isShowModificationsInDescription() {
        return this.showModificationsInDescription.get();
    }

    public DataItemPane<T> setShowModificationsInDescription(Boolean value) {
        this.showModificationsInDescription.set(value.booleanValue());
        return this;
    }

    public void setResponsiveMode(WindowMode value) {
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, this.getId() + ": mode changed to " + String.valueOf(value));
        this.layoutMode.set((Object)value);
    }

    public ObjectProperty<Callback<T, Image>> imageConverterProperty() {
        return this.selector.imageConverterProperty();
    }

    public Callback<T, Image> getImageConverter() {
        return this.selector.getImageConverter();
    }

    public DataItemPane<T> setImageConverter(Callback<T, Image> value) {
        this.selector.setImageConverter(value);
        return this;
    }

    public ObjectProperty<Callback<T, String>> nameConverterProperty() {
        return this.selector.stringConverterProperty();
    }

    public Callback<T, String> getNameConverter() {
        return this.selector.getStringConverter();
    }

    public DataItemPane<T> setNameConverter(Callback<T, String> value) {
        this.selector.setStringConverter(value);
        return this;
    }

    private Node getContentStats(T raw) {
        VBox contentStats = new VBox();
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.DEBUG, "getContentStats() for {0} using {1}", raw, this.getModificationConverter());
        if (raw instanceof ComplexDataItem) {
            ComplexDataItem item = (ComplexDataItem)raw;
            ModifiedObjectType previousType = null;
            Function<Modification, String> modConv = this.getModificationConverter();
            for (Modification m : item.getModifications()) {
                DataItemModification mod;
                if (m.getReferenceType() != previousType) {
                    String category = String.valueOf(m.getReferenceType());
                    if (this.getReferenceTypeConverter() != null && m.getReferenceType() != null) {
                        category = this.getReferenceTypeConverter().apply(m.getReferenceType());
                    }
                    RPGFrameworkJavaFX.logger.log(System.Logger.Level.DEBUG, "RefTypeConv {0} converted {1} into {2}", this.getReferenceTypeConverter(), m.getReferenceType(), category);
                    if (category != null) {
                        Label head = new Label(category);
                        head.getStyleClass().add((Object)"base");
                        contentStats.getChildren().add((Object)head);
                        VBox.setMargin((Node)head, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
                    }
                }
                previousType = m.getReferenceType();
                Button button = null;
                Tooltip tooltip = null;
                String text = modConv != null ? modConv.apply(m) : String.valueOf(m);
                Text choiceText = new Text(text);
                choiceText.setStyle("-fx-fill: -fx-text-base-color");
                Text decText = new Text();
                decText.getStyleClass().add((Object)"base");
                if (m instanceof DataItemModification) {
                    DataItem toShow;
                    mod = (DataItemModification)m;
                    if (mod.getConnectedChoice() != null) {
                        RPGFrameworkJavaFX.logger.log(System.Logger.Level.DEBUG, "Determine decision text for " + String.valueOf(mod) + " and choice " + String.valueOf(mod.getConnectedChoice()) + " using " + String.valueOf(this.decisionContainer));
                        if (this.decisionContainer.getDecision(mod.getConnectedChoice()) != null) {
                            this.updateChoice(mod, decText);
                        }
                        Choice choice = item.getChoice(mod.getConnectedChoice());
                        button = new Button(decText.getText().length() == 0 ? "?" : "!");
                        button.setOnAction(ev -> {
                            this.getDecisionHandler().accept(this.getSelectedItem(), choice);
                            RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "Decision dialog closed------------------updating choice");
                            this.updateChoice(mod, decText);
                        });
                        button.setUserData((Object)choice);
                    } else if (mod.getResolvedKey() != null && mod.getResolvedKey() instanceof DataItem && (toShow = (DataItem)mod.getResolvedKey()) != null) {
                        tooltip = new Tooltip(toShow.getDescription());
                        tooltip.setWrapText(true);
                        tooltip.setMaxWidth(300.0);
                    }
                } else if (m instanceof ModificationChoice) {
                    mod = (ModificationChoice)m;
                    button = new Button(decText.getText().length() == 0 ? "?" : "!");
                    button.setOnAction(arg_0 -> this.lambda$getContentStats$6((ModificationChoice)mod, decText, arg_0));
                    button.setUserData((Object)mod);
                }
                TextFlow label = new TextFlow(new Node[]{choiceText, decText});
                if (button == null) {
                    contentStats.getChildren().add((Object)label);
                    continue;
                }
                HBox box = new HBox(5.0, new Node[]{button, label});
                box.setAlignment(Pos.CENTER_LEFT);
                contentStats.getChildren().add((Object)box);
            }
        }
        return contentStats;
    }

    private void updateChoice(DataItemModification mod, Text decText) {
        System.err.println("DataItemPane.updateChoice(" + String.valueOf(mod) + ") for " + String.valueOf(this.getSelectedItem()) + " with " + String.valueOf(this.decisionContainer));
        RPGFrameworkJavaFX.updateChoice(this.decisionContainer, (ChoiceOrigin)this.getSelectedItem(), this.getModificationConverter(), mod, decText);
    }

    private void updateChoice(ModificationChoice mod, Text decText) {
        Decision dec = this.decisionContainer.getDecision(mod.getUUID());
        if (dec == null) {
            decText.setText("");
        } else {
            List modList = GenericRPGTools.decisionToModifications((ModificationChoice)mod, (Decision)dec);
            List modListS = modList.stream().map(mb -> this.getModificationConverter().apply((Modification)mb)).collect(Collectors.toList());
            decText.setText(" (" + String.join((CharSequence)", ", modListS) + ")");
        }
    }

    private /* synthetic */ void lambda$getContentStats$6(ModificationChoice mod, Text decText, ActionEvent ev) {
        if (this.getModDecisionHandler() == null) {
            RPGFrameworkJavaFX.logger.log(System.Logger.Level.ERROR, "Missing modDecisionHandler");
        } else {
            this.getModDecisionHandler().accept(this.getSelectedItem(), mod);
            RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "Decision dialog closed------------------");
            this.updateChoice(mod, decText);
        }
    }
}

