/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.DataItemPane;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;

public class DataItemListPane<T extends DataItem>
extends DataItemPane<T> {
    @FXML
    private ObjectProperty<T> selectedItem = new SimpleObjectProperty();
    private ListView<T> list;

    public DataItemListPane(Function<Requirement, String> reqR, Function<Modification, String> modR) {
        super(reqR, modR);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.list = new ListView();
    }

    private void initLayout() {
        this.setSelectorNode(this.list);
    }

    private void initInteractivity() {
        this.heightProperty().addListener((ov, o, n) -> this.recalculateSpinnerHeight());
        this.widthProperty().addListener((ov, o, n) -> this.recalculateSpinnerHeight());
        this.selectedItem.bind((ObservableValue)this.list.getSelectionModel().selectedItemProperty());
    }

    private void recalculateSpinnerHeight() {
        this.list.setPrefHeight(this.getHeight());
    }

    @Override
    public void setItems(List<T> data) {
        this.list.getItems().setAll(data);
    }
}

