/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.jfx.ComplexDataItemControllerNode;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.javafx.AlertManager;
import org.prelle.javafx.AlertType;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.WindowMode;

public class ComplexDataItemControllerTwoColumnSkin<T extends ComplexDataItem, V extends ComplexDataItemValue<T>>
extends SkinBase<ComplexDataItemControllerNode<T, V>> {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private static final String COL2_BASESTYLE = "-fx-margin: 0 1em 0 0; -fx-min-width: 23em;";
    private Button btnAdd;
    private Button btnDel;
    private ListView<T> listPossible;
    private ListView<V> listSelected;
    private HBox line1Select;
    private Label lblAvailable;
    private Label lblSelected;
    private Label phAvailable;
    private Label phSelected;
    private Callback<ListView<T>, ListCell<T>> cfAvailable;
    private Callback<ListView<V>, ListCell<V>> cfSelected;
    private HBox columns;
    private VBox col1;
    private VBox col2;

    protected ComplexDataItemControllerTwoColumnSkin(ComplexDataItemControllerNode<T, V> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.setResponsiveMode(ResponsiveControlManager.getCurrentMode());
    }

    private void initComponents() {
        this.btnAdd = new Button(null, (Node)new SymbolIcon("Add"));
        this.btnDel = new Button(null, (Node)new SymbolIcon("Delete"));
        this.btnDel.setDisable(true);
        this.cfAvailable = new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> param) {
                ListCell cell = ((ComplexDataItemControllerNode)ComplexDataItemControllerTwoColumnSkin.this.getSkinnable()).getAvailableCellFactory() != null ? (ListCell)((ComplexDataItemControllerNode)ComplexDataItemControllerTwoColumnSkin.this.getSkinnable()).getAvailableCellFactory().call(param) : ComplexDataItemControllerTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> ComplexDataItemControllerTwoColumnSkin.this.mouseClickedAvailable(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> ComplexDataItemControllerTwoColumnSkin.this.dragDetectedAvailable(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.cfSelected = new Callback<ListView<V>, ListCell<V>>(){

            public ListCell<V> call(ListView<V> param) {
                ListCell cell = ((ComplexDataItemControllerNode)ComplexDataItemControllerTwoColumnSkin.this.getSkinnable()).getSelectedCellFactory() != null ? (ListCell)((ComplexDataItemControllerNode)ComplexDataItemControllerTwoColumnSkin.this.getSkinnable()).getSelectedCellFactory().call(param) : ComplexDataItemControllerTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> ComplexDataItemControllerTwoColumnSkin.this.mouseClickedSelected(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> ComplexDataItemControllerTwoColumnSkin.this.dragDetectedSelected(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.phAvailable = new Label();
        this.phAvailable.setWrapText(true);
        this.phSelected = new Label();
        this.phSelected.setWrapText(true);
        this.phSelected.setStyle("-fx-background-color: -fx-second-background");
        this.listPossible = new ListView();
        this.listPossible.setCellFactory(this.cfAvailable);
        this.listPossible.itemsProperty().bind(((ComplexDataItemControllerNode)this.getSkinnable()).availableProperty());
        this.listPossible.setPlaceholder((Node)this.phAvailable);
        this.listPossible.setStyle(((ComplexDataItemControllerNode)this.getSkinnable()).getAvailableStyle());
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
        this.listSelected = new ListView();
        this.listSelected.setCellFactory(this.cfSelected);
        this.listSelected.itemsProperty().bind(((ComplexDataItemControllerNode)this.getSkinnable()).selectedProperty());
        this.listSelected.setPlaceholder((Node)this.phSelected);
        this.listSelected.setStyle(((ComplexDataItemControllerNode)this.getSkinnable()).getSelectedStyle());
        this.listSelected.setMaxHeight(Double.MAX_VALUE);
        this.lblAvailable = new Label(" " + ((ComplexDataItemControllerNode)this.getSkinnable()).getAvailableHeading());
        this.lblSelected = new Label(" " + ((ComplexDataItemControllerNode)this.getSkinnable()).getSelectedHeading());
        this.lblAvailable.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.lblSelected.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
    }

    private void initLayout() {
        this.columns = new HBox();
        this.columns.setStyle("-fx-spacing: 1em;");
        this.getChildren().add((Object)this.columns);
        this.columns.getChildren().clear();
        Region buf = new Region();
        buf.setMaxWidth(Double.MAX_VALUE);
        this.line1Select = new HBox(new Node[]{buf, this.btnAdd, this.btnDel});
        this.line1Select.prefWidthProperty().bind((ObservableValue)this.listSelected.widthProperty());
        HBox.setHgrow((Node)buf, (Priority)Priority.SOMETIMES);
        if (((ComplexDataItemControllerNode)this.getSkinnable()).getSelectedListHead() != null) {
            this.line1Select.getChildren().add(0, (Object)((ComplexDataItemControllerNode)this.getSkinnable()).getSelectedListHead());
        }
        this.col1 = new VBox(new Node[]{this.listPossible});
        this.col2 = new VBox(new Node[]{this.line1Select, this.listSelected});
        VBox.setVgrow(this.listPossible, (Priority)Priority.ALWAYS);
        VBox.setVgrow(this.listSelected, (Priority)Priority.ALWAYS);
        this.col1.setFillWidth(false);
        this.col2.setStyle(COL2_BASESTYLE);
        HBox.setHgrow((Node)this.col1, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)this.col2, (Priority)Priority.SOMETIMES);
        this.columns.getChildren().addAll((Object[])new Node[]{this.col1, this.col2});
        this.columns.setFillHeight(true);
        if (((ComplexDataItemControllerNode)this.getSkinnable()).getShowHeadings()) {
            VBox.setMargin((Node)this.lblAvailable, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            VBox.setMargin((Node)this.lblSelected, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            this.col1.getChildren().add(0, (Object)this.lblAvailable);
            this.col2.getChildren().add(0, (Object)this.lblSelected);
        }
        if (((ComplexDataItemControllerNode)this.getSkinnable()).filterNodeProperty().get() != null) {
            this.col1.getChildren().add(this.col1.getChildren().size() - 1, ((ComplexDataItemControllerNode)this.getSkinnable()).getFilterNode());
        }
        if (((ComplexDataItemControllerNode)this.getSkinnable()).selectedListPostNodeProperty().get() != null) {
            this.col2.getChildren().add((Object)((ComplexDataItemControllerNode)this.getSkinnable()).getSelectedListPostNode());
        }
    }

    private void initInteractivity() {
        ((ComplexDataItemControllerNode)this.getSkinnable()).showHeadingsProperty().addListener((ov, o, n) -> this.initLayout());
        ((ComplexDataItemControllerNode)this.getSkinnable()).availableHeadingProperty().addListener((ov, o, n) -> this.lblAvailable.setText(" " + n));
        ((ComplexDataItemControllerNode)this.getSkinnable()).selectedHeadingProperty().addListener((ov, o, n) -> this.lblSelected.setText(" " + n));
        ((ComplexDataItemControllerNode)this.getSkinnable()).availableStyleProperty().addListener((ov, o, n) -> this.listPossible.setStyle(n));
        ((ComplexDataItemControllerNode)this.getSkinnable()).selectedStyleProperty().addListener((ov, o, n) -> this.listSelected.setStyle(n));
        ((ComplexDataItemControllerNode)this.getSkinnable()).filterNodeProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.col1.getChildren().remove((Object)o);
            }
            if (n != null) {
                this.col1.getChildren().add(this.col1.getChildren().size() - 1, (Object)n);
            }
        });
        ((ComplexDataItemControllerNode)this.getSkinnable()).selectedListHeadProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.line1Select.getChildren().remove(o);
            }
            if (n != null) {
                this.line1Select.getChildren().add(0, n);
            }
        });
        this.phAvailable.textProperty().bind((ObservableValue)((ComplexDataItemControllerNode)this.getSkinnable()).availablePlaceholderProperty());
        this.phSelected.textProperty().bind((ObservableValue)((ComplexDataItemControllerNode)this.getSkinnable()).selectedPlaceholderProperty());
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((ComplexDataItemControllerNode)this.getSkinnable()).setShowHelpFor(n));
        this.listSelected.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            this.btnDel.setDisable(n == null || !((ComplexDataItemControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)n).get());
            ((ComplexDataItemControllerNode)this.getSkinnable()).setShowHelpFor(n != null ? (ComplexDataItem)n.getModifyable() : null);
        });
        this.listPossible.setOnDragOver(ev -> this.dragOverAvailable((DragEvent)ev));
        this.listSelected.setOnDragOver(ev -> this.dragOverSelected((DragEvent)ev));
        this.listPossible.setOnDragDropped(ev -> this.dragDroppedAvailable((DragEvent)ev));
        this.listSelected.setOnDragDropped(ev -> this.dragDroppedSelected((DragEvent)ev));
        this.btnAdd.setOnAction(ev -> this.onAddClicked());
        this.btnDel.setOnAction(ev -> this.onDeleteClicked((ComplexDataItemValue)this.listSelected.getSelectionModel().getSelectedItem()));
    }

    private static <T> ListCell<T> createDefaultCellImpl() {
        return new ListCell<T>(){

            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof Node) {
                    this.setText(null);
                    Node currentNode = this.getGraphic();
                    Node newNode = (Node)item;
                    if (currentNode == null || !currentNode.equals(newNode)) {
                        this.setGraphic(newNode);
                    }
                } else {
                    this.setText(item == null ? "null" : item.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    protected void userSelects(T toSelect) {
        logger.log(System.Logger.Level.WARNING, "userSelects(" + String.valueOf(toSelect) + ")");
        ComplexDataItemController ctrl = ((ComplexDataItemControllerNode)this.getSkinnable()).getController();
        Possible possible = ctrl.canBeSelected(toSelect, new Decision[0]);
        logger.log(System.Logger.Level.DEBUG, "possible = " + String.valueOf(possible));
        if (possible.get()) {
            logger.log(System.Logger.Level.DEBUG, "ctrl = " + String.valueOf(ctrl));
            if (!ctrl.getChoicesToDecide(toSelect).isEmpty()) {
                List options = ctrl.getChoicesToDecide(toSelect);
                logger.log(System.Logger.Level.DEBUG, "called getChoicesToDecide returns {0} choices", options.size());
                if (((ComplexDataItemControllerNode)this.getSkinnable()).getOptionCallback() != null) {
                    Platform.runLater(() -> {
                        logger.log(System.Logger.Level.DEBUG, "call getOptionCallback");
                        Decision[] decisions = ((ComplexDataItemControllerNode)this.getSkinnable()).getOptionCallback().apply((ComplexDataItem)toSelect, options);
                        if (decisions != null) {
                            logger.log(System.Logger.Level.WARNING, "call select(option, decision[{0}])", decisions.length);
                            OperationResult res = ctrl.select((DataItem)toSelect, decisions);
                            if (res.wasSuccessful()) {
                                logger.log(System.Logger.Level.INFO, "Selecting {0} with options was successful", toSelect);
                            } else {
                                logger.log(System.Logger.Level.WARNING, "Selecting {0} with options failed: {1}", toSelect, res.getError());
                                AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)"Failed adding", (String)res.getError());
                            }
                        }
                    });
                } else {
                    logger.log(System.Logger.Level.ERROR, "Item {0} has choices to make, but no GUI callback defined", toSelect.getId());
                }
            } else {
                logger.log(System.Logger.Level.DEBUG, "call select(option)");
                OperationResult res = ctrl.select(toSelect, new Decision[0]);
                if (res.wasSuccessful()) {
                    logger.log(System.Logger.Level.INFO, "Selecting {0} was successful", toSelect);
                } else {
                    logger.log(System.Logger.Level.WARNING, "Selecting {0} failed: {1}", toSelect, res.getError());
                    AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)"Failed adding", (String)res.getError());
                }
            }
        } else {
            logger.log(System.Logger.Level.DEBUG, "can not be Selected(" + String.valueOf(toSelect) + "): " + String.valueOf(possible.getI18NKey()));
            FlexibleApplication.getInstance().showAlertAndCall(AlertType.NOTIFICATION, "Selection failed", possible.toString());
        }
    }

    private void mouseClickedAvailable(ListCell<T> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.userSelects((ComplexDataItem)cell.getItem());
            ((ComplexDataItemControllerNode)this.getSkinnable()).refresh();
        }
    }

    private void mouseClickedSelected(ListCell<V> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2 && ((ComplexDataItemControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)((ComplexDataItemValue)cell.getItem())).get()) {
            ((ComplexDataItemControllerNode)this.getSkinnable()).getController().deselect((DataItemValue)((ComplexDataItemValue)cell.getItem()));
        }
    }

    protected void dragDetectedAvailable(ListCell<T> cell, MouseEvent event) {
        ComplexDataItem data = (ComplexDataItem)cell.getItem();
        if (data == null) {
            return;
        }
        logger.log(System.Logger.Level.DEBUG, "check: can be selected");
        if (!((ComplexDataItemControllerNode)this.getSkinnable()).getController().canBeSelected((DataItem)data, new Decision[0]).get()) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = data.getTypeString() + ":" + data.getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    protected void dragDetectedSelected(ListCell<V> cell, MouseEvent event) {
        ComplexDataItemValue data = (ComplexDataItemValue)cell.getItem();
        if (data == null) {
            return;
        }
        if (!((ComplexDataItemControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)data).get()) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = ((ComplexDataItem)data.getModifyable()).getTypeString() + ":" + ((ComplexDataItem)data.getModifyable()).getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    private void dragOverSelected(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            String enhanceID = event.getDragboard().getString();
            ComplexDataItem toSelect = null;
            for (ComplexDataItem tmp : ((ComplexDataItemControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = tmp.getTypeString() + ":" + tmp.getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null && ((ComplexDataItemControllerNode)this.getSkinnable()).getController().canBeSelected(toSelect, new Decision[0]).get()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
        }
    }

    private void dragDroppedSelected(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            ComplexDataItem toSelect = null;
            for (ComplexDataItem tmp : ((ComplexDataItemControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = tmp.getTypeString() + ":" + tmp.getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                this.userSelects(toSelect);
                ((ComplexDataItemControllerNode)this.getSkinnable()).refresh();
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void dragOverAvailable(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private void dragDroppedAvailable(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            ComplexDataItemValue toSelect = null;
            for (ComplexDataItemValue tmp : ((ComplexDataItemControllerNode)this.getSkinnable()).getController().getSelected()) {
                String cmp = ((ComplexDataItem)tmp.getModifyable()).getTypeString() + ":" + ((ComplexDataItem)tmp.getModifyable()).getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                ((ComplexDataItemControllerNode)this.getSkinnable()).getController().deselect(toSelect);
                ((ComplexDataItemControllerNode)this.getSkinnable()).refresh();
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    public void setResponsiveMode(WindowMode value) {
        logger.log(System.Logger.Level.TRACE, "setResponsiveMode({0})", value);
        if (value == WindowMode.MINIMAL) {
            this.columns.getChildren().remove((Object)this.col1);
            this.col2.setStyle("-fx-min-width: 20em; -fx-max-width: 23em");
            this.btnAdd.setVisible(true);
        } else {
            this.btnAdd.setVisible(false);
            this.col2.setStyle(COL2_BASESTYLE);
            if (!this.columns.getChildren().contains((Object)this.col1)) {
                this.columns.getChildren().add(0, (Object)this.col1);
            }
        }
        this.columns.requestLayout();
    }

    private void onAddClicked() {
        ComplexDataItem selected;
        logger.log(System.Logger.Level.WARNING, "Add button clicked");
        GenericDescriptionVBox descr = new GenericDescriptionVBox(((ComplexDataItemControllerNode)this.getSkinnable()).getRequirementResolver(), ((ComplexDataItemControllerNode)this.getSkinnable()).getModificationResolver());
        descr.setStyle("-fx-min-height: 5em");
        VBox pane = new VBox(10.0, new Node[]{this.col1, descr});
        VBox.setVgrow((Node)this.col1, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)descr, (Priority)Priority.SOMETIMES);
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> descr.setData((DataItem)n));
        ManagedDialog dialog = new ManagedDialog(ResourceI18N.get((ResourceBundle)RPGFrameworkJFXConstants.UI, (String)"label.selectOne"), (Node)pane, new CloseType[]{CloseType.CANCEL, CloseType.OK});
        CloseType closed = FlexibleApplication.getInstance().showAndWait((Node)dialog);
        logger.log(System.Logger.Level.WARNING, "Closed with " + String.valueOf(closed));
        if (closed == CloseType.OK && (selected = (ComplexDataItem)this.listPossible.getSelectionModel().getSelectedItem()) != null) {
            this.userSelects(selected);
        }
    }

    private void onDeleteClicked(V selected) {
        logger.log(System.Logger.Level.DEBUG, "Delete button clicked for " + String.valueOf(selected));
        boolean success = ((ComplexDataItemControllerNode)this.getSkinnable()).getController().deselect(selected);
        if (success) {
            this.listSelected.getItems().remove(selected);
        }
    }
}

