/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.PartialController;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.OptionalNodePane;

public class ChoiceFewDialog
extends ManagedDialog {
    private String modText;
    private DataItem decideFor;
    private UUID choice;
    private List<?> options;
    private PartialController<?> control;
    private OptionalNodePane pane;
    private List<RadioButton> buttons;
    private ToggleGroup toggleGroup;
    private Decision decision;

    public ChoiceFewDialog(DataItem decideFor, UUID choice, String modText, List<?> options, PartialController<?> control) {
        this.decideFor = decideFor;
        this.modText = modText;
        this.choice = choice;
        this.options = options;
        this.control = control;
        if (control == null) {
            throw new NullPointerException();
        }
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.toggleGroup = new ToggleGroup();
        this.buttons = new ArrayList<RadioButton>();
        for (Object resolved : this.options) {
            String name = resolved instanceof DataItem ? ((DataItem)resolved).getName() : String.valueOf(resolved);
            RadioButton cb = new RadioButton(name);
            cb.getStyleClass().add((Object)"base");
            this.toggleGroup.getToggles().add((Object)cb);
            cb.setUserData(resolved);
            this.buttons.add(cb);
        }
    }

    private void initLayout() {
        Label lbModText = new Label(this.modText);
        VBox layout = new VBox(5.0, new Node[]{lbModText});
        for (RadioButton cb : this.buttons) {
            layout.getChildren().add((Object)cb);
            Object resolved = cb.getUserData();
            if (resolved == null || !(resolved instanceof DataItem)) continue;
            Label desc = new Label(((DataItem)resolved).getDescription());
            desc.setWrapText(true);
            desc.setStyle("-fx-max-width: 35em");
            layout.getChildren().add((Object)desc);
        }
        super.setContent((Node)layout);
        super.setTitle(this.decideFor.getName());
    }

    private void initInteractivity() {
        for (RadioButton btn : this.buttons) {
            btn.setOnAction(ev -> {
                Object resolved = btn.getUserData();
                RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "Resolved {0}", resolved);
                String key = String.valueOf(resolved);
                if (resolved instanceof Enum) {
                    key = ((Enum)resolved).name();
                } else if (resolved instanceof DataItem) {
                    key = ((DataItem)resolved).getId();
                }
                RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "Decide {0} for {1} in controller {2}", key, this.choice, this.control);
                this.decision = new Decision(this.choice, key);
                this.control.decide((Object)this.decideFor, this.choice, this.decision);
            });
        }
    }

    public Decision getDecision() {
        return this.decision;
    }
}

